/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.notification;

import com.alee.extended.image.WebImage;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.painter.Painter;
import com.alee.extended.panel.AlignPanel;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationListener;
import com.alee.managers.notification.NotificationOption;
import com.alee.managers.notification.NotificationStyle;
import com.alee.managers.popup.PopupAdapter;
import com.alee.managers.popup.PopupStyle;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class WebNotificationPopup
extends WebPopup {
    protected List<NotificationListener> listeners = new ArrayList<NotificationListener>(1);
    protected boolean clickToClose = true;
    protected boolean closeOnOptionSelection = true;
    protected long displayTime = 0L;
    protected WebTimer displayTimer;
    protected boolean accepted;
    protected Icon icon;
    protected Component content;
    protected List<NotificationOption> options;
    protected WebImage iconImage;
    protected WebPanel contentPanel;
    protected WebPanel optionsPanel;

    public WebNotificationPopup() {
        this(NotificationStyle.web);
    }

    public WebNotificationPopup(NotificationStyle notificationStyle) {
        this(notificationStyle.getPainter());
    }

    public WebNotificationPopup(PopupStyle popupStyle) {
        super(popupStyle);
        this.initializeNotificationPopup();
    }

    public WebNotificationPopup(Painter stylePainter) {
        super(stylePainter);
        this.initializeNotificationPopup();
    }

    protected void initializeNotificationPopup() {
        this.setLayout(new BorderLayout(15, 5));
        this.setAnimated(true);
        this.iconImage = new WebImage();
        this.add((Component)new AlignPanel(this.iconImage, 0, 0), (Object)"West");
        this.updateIcon();
        this.contentPanel = new WebPanel();
        this.contentPanel.setOpaque(false);
        this.add((Component)new AlignPanel(this.contentPanel, 0, 0), (Object)"Center");
        this.updateContent();
        this.optionsPanel = new WebPanel(new HorizontalFlowLayout(4, false));
        this.optionsPanel.setOpaque(false);
        this.add((Component)new AlignPanel(this.optionsPanel, 4, 0), (Object)"South");
        this.updateOptions();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebNotificationPopup.this.clickToClose) {
                    if (SwingUtils.isLeftMouseButton(e)) {
                        WebNotificationPopup.this.acceptAndHide();
                    } else {
                        WebNotificationPopup.this.hidePopup();
                    }
                }
            }
        });
        this.addPopupListener(new PopupAdapter(){

            @Override
            public void popupWillBeOpened() {
                WebNotificationPopup.this.accepted = false;
            }

            @Override
            public void popupOpened() {
                WebNotificationPopup.this.startDelayedClose();
            }

            @Override
            public void popupWillBeClosed() {
                WebNotificationPopup.this.stopDelayedClose();
                if (WebNotificationPopup.this.accepted) {
                    WebNotificationPopup.this.fireAccepted();
                } else {
                    WebNotificationPopup.this.fireClosed();
                }
            }
        });
    }

    private void startDelayedClose() {
        if (!(this.displayTime <= 0L || this.displayTimer != null && this.displayTimer.isRunning())) {
            this.displayTimer = WebTimer.delay((long)this.displayTime, (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebNotificationPopup.this.hidePopup();
                }
            });
        }
    }

    private void stopDelayedClose() {
        if (this.displayTimer != null && this.displayTimer.isRunning()) {
            this.displayTimer.stop();
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.updateIcon();
    }

    public void setIcon(NotificationIcon iconType) {
        this.setIcon(iconType.getIcon());
    }

    protected void updateIcon() {
        this.iconImage.setIcon(this.icon);
        this.revalidate();
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.content = content;
        this.updateContent();
    }

    public void setContent(String content) {
        this.setContent(new WebLabel(content));
    }

    protected void updateContent() {
        this.contentPanel.removeAll();
        if (this.content != null) {
            this.contentPanel.add(this.content);
        }
        this.contentPanel.revalidate();
    }

    public List<NotificationOption> getOptions() {
        return this.options;
    }

    public void setOptions(NotificationOption ... options) {
        this.setOptions(Arrays.asList(options));
    }

    public void setOptions(List<NotificationOption> options) {
        this.options = options;
        this.updateOptions();
    }

    protected void updateOptions() {
        if (this.options != null && this.options.size() > 0) {
            for (final NotificationOption option : this.options) {
                WebButton optionButton = new WebButton("");
                optionButton.setLanguage(option.getLanguageKey(), new Object[0]);
                optionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebNotificationPopup.this.fireOptionSelected(option);
                        if (WebNotificationPopup.this.closeOnOptionSelection) {
                            WebNotificationPopup.this.acceptAndHide();
                        }
                    }
                });
                this.optionsPanel.add((Component)optionButton);
            }
        } else {
            this.optionsPanel.removeAll();
        }
        this.revalidate();
    }

    public void acceptAndHide() {
        this.accepted = true;
        this.hidePopup();
    }

    public boolean isClickToClose() {
        return this.clickToClose;
    }

    public void setClickToClose(boolean clickToClose) {
        this.clickToClose = clickToClose;
    }

    public boolean isCloseOnOptionSelection() {
        return this.closeOnOptionSelection;
    }

    public void setCloseOnOptionSelection(boolean closeOnOptionSelection) {
        this.closeOnOptionSelection = closeOnOptionSelection;
    }

    public long getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(long displayTime) {
        this.displayTime = displayTime;
        if (this.isShowing()) {
            if (displayTime > 0L) {
                this.startDelayedClose();
            } else {
                this.stopDelayedClose();
            }
        }
    }

    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    public void fireOptionSelected(NotificationOption option) {
        for (NotificationListener listener : CollectionUtils.copy(this.listeners)) {
            listener.optionSelected(option);
        }
    }

    public void fireAccepted() {
        for (NotificationListener listener : CollectionUtils.copy(this.listeners)) {
            listener.accepted();
        }
    }

    public void fireClosed() {
        for (NotificationListener listener : CollectionUtils.copy(this.listeners)) {
            listener.closed();
        }
    }
}

