/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.ButtonHotkeyRunnable;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;

public final class HotkeyManager {
    protected static final Object sync = new Object();
    protected static boolean hotkeysEnabled = true;
    protected static boolean transferFocus = false;
    protected static Map<Component, List<HotkeyInfo>> hotkeys = new WeakHashMap<Component, List<HotkeyInfo>>();
    protected static Map<Container, List<HotkeyCondition>> containerConditions = new WeakHashMap<Container, List<HotkeyCondition>>();
    protected static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(HotkeyData.class);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (hotkeysEnabled && event instanceof KeyEvent) {
                        KeyEvent e = (KeyEvent)event;
                        if (e.isConsumed() || e.getID() != 401) {
                            return;
                        }
                        if (!HotkeyManager.hotkeyForEventExists(e)) {
                            return;
                        }
                        HotkeyManager.processHotkeys(e);
                    }
                }
            }, 8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Component, List<HotkeyInfo>> copyHotkeys() {
        Object object = sync;
        synchronized (object) {
            HashMap<Component, List<HotkeyInfo>> copy = new HashMap<Component, List<HotkeyInfo>>(hotkeys.size());
            for (Map.Entry<Component, List<HotkeyInfo>> entry : hotkeys.entrySet()) {
                copy.put(entry.getKey(), CollectionUtils.copy((Collection)entry.getValue()));
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Container, List<HotkeyCondition>> copyContainerConditions() {
        Object object = sync;
        synchronized (object) {
            HashMap<Container, List<HotkeyCondition>> copy = new HashMap<Container, List<HotkeyCondition>>(containerConditions.size());
            for (Map.Entry<Container, List<HotkeyCondition>> entry : containerConditions.entrySet()) {
                copy.put(entry.getKey(), CollectionUtils.copy((Collection)entry.getValue()));
            }
            return copy;
        }
    }

    protected static boolean hotkeyForEventExists(KeyEvent keyEvent) {
        int hotkeyHash = SwingUtils.hotkeyToString(keyEvent).hashCode();
        for (Map.Entry<Component, List<HotkeyInfo>> entry : HotkeyManager.copyHotkeys().entrySet()) {
            for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                if (hotkeyInfo.getHotkeyData().hashCode() != hotkeyHash) continue;
                return true;
            }
        }
        return false;
    }

    protected static void processHotkeys(KeyEvent e) {
        Map<Component, List<HotkeyInfo>> hotkeysCopy = HotkeyManager.copyHotkeys();
        for (Map.Entry<Component, List<HotkeyInfo>> entry : hotkeysCopy.entrySet()) {
            for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                Component forComponent = hotkeyInfo.getForComponent();
                if (forComponent == null) {
                    if (!hotkeyInfo.getHotkeyData().isTriggered(e) || hotkeyInfo.getAction() == null) continue;
                    SwingUtils.invokeLater(hotkeyInfo.getAction(), e);
                    continue;
                }
                Component topComponent = hotkeyInfo.getTopComponent();
                topComponent = topComponent != null ? topComponent : SwingUtils.getWindowAncestor(forComponent);
                if (!SwingUtils.hasFocusOwner(topComponent) || !hotkeyInfo.getHotkeyData().isTriggered(e) || hotkeyInfo.getAction() == null || !HotkeyManager.meetsParentConditions(forComponent)) continue;
                if (transferFocus) {
                    forComponent.requestFocusInWindow();
                }
                SwingUtils.invokeLater(hotkeyInfo.getAction(), e);
            }
        }
    }

    protected static boolean meetsParentConditions(Component forComponent) {
        for (Map.Entry<Container, List<HotkeyCondition>> entry : HotkeyManager.copyContainerConditions().entrySet()) {
            if (!entry.getKey().isAncestorOf(forComponent)) continue;
            for (HotkeyCondition condition : entry.getValue()) {
                if (condition.checkCondition(forComponent)) continue;
                return false;
            }
        }
        return true;
    }

    public static HotkeyInfo registerHotkey(HotkeyData hotkeyData, HotkeyRunnable action) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(true);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setAction(action);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(Component forComponent, HotkeyData hotkeyData, HotkeyRunnable action) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, action);
    }

    public static HotkeyInfo registerHotkey(Component forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, action, hidden);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, Component forComponent, HotkeyData hotkeyData, HotkeyRunnable action) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, false);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, Component forComponent, HotkeyData hotkeyData, HotkeyRunnable action, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, Component forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, action, hidden, null);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, Component forComponent, HotkeyData hotkeyData, HotkeyRunnable action, boolean hidden, TooltipWay tooltipWay) {
        HotkeyInfo hotkeyInfo = new HotkeyInfo();
        hotkeyInfo.setHidden(hidden);
        hotkeyInfo.setTopComponent(topComponent);
        hotkeyInfo.setForComponent(forComponent);
        hotkeyInfo.setHotkeyData(hotkeyData);
        hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
        hotkeyInfo.setAction(action);
        HotkeyManager.cacheHotkey(hotkeyInfo);
        return hotkeyInfo;
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData);
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, hidden);
    }

    public static HotkeyInfo registerHotkey(AbstractButton forComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(null, forComponent, hotkeyData, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, false);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, HotkeyManager.createAction(forComponent), false, tooltipWay);
    }

    public static HotkeyInfo registerHotkey(Component topComponent, AbstractButton forComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, forComponent, hotkeyData, HotkeyManager.createAction(forComponent), hidden, null);
    }

    protected static HotkeyRunnable createAction(AbstractButton forComponent) {
        return new ButtonHotkeyRunnable(forComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComponentHotkeyDisplayWay(Component component, TooltipWay tooltipWay) {
        Object object = sync;
        synchronized (object) {
            for (HotkeyInfo hotkeyInfo : HotkeyManager.getComponentHotkeysCache(component)) {
                hotkeyInfo.setHotkeyDisplayWay(tooltipWay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContainerHotkeyCondition(Container container, HotkeyCondition hotkeyCondition) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> clist = HotkeyManager.getContainerHotkeyConditionsCache(container);
            clist.add(hotkeyCondition);
            containerConditions.put(container, clist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyCondition(Container container, HotkeyCondition hotkeyCondition) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> clist = HotkeyManager.getContainerHotkeyConditionsCache(container);
            clist.remove(hotkeyCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContainerHotkeyConditions(Container container) {
        Object object = sync;
        synchronized (object) {
            containerConditions.remove(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HotkeyCondition> getContainerHotkeyConditions(Container container) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyCondition> list = containerConditions.get(container);
            return list != null ? CollectionUtils.copy(list) : new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<HotkeyCondition> getContainerHotkeyConditionsCache(Container container) {
        Object object = sync;
        synchronized (object) {
            ArrayList<HotkeyCondition> list = containerConditions.get(container);
            return list != null ? list : new ArrayList<HotkeyCondition>();
        }
    }

    public static void unregisterHotkey(HotkeyInfo hotkeyInfo) {
        HotkeyManager.clearHotkeyCache(hotkeyInfo);
    }

    public static void unregisterHotkeys(Component component) {
        HotkeyManager.clearHotkeysCache(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HotkeyInfo> getComponentHotkeys(Component component) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> list = hotkeys.get(component);
            return list != null ? CollectionUtils.copy(list) : new ArrayList();
        }
    }

    public static Map<Component, List<HotkeyInfo>> getAllHotkeys() {
        return hotkeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cacheHotkey(HotkeyInfo hotkeyInfo) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> hlist = HotkeyManager.getComponentHotkeysCache(hotkeyInfo.getForComponent());
            hlist.add(hotkeyInfo);
            hotkeys.put(hotkeyInfo.getForComponent(), hlist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearHotkeyCache(HotkeyInfo hotkeyInfo) {
        Object object = sync;
        synchronized (object) {
            List<HotkeyInfo> hlist = HotkeyManager.getComponentHotkeysCache(hotkeyInfo.getForComponent());
            hlist.remove(hotkeyInfo);
        }
    }

    protected static void clearHotkeysCache(List<HotkeyInfo> hotkeys) {
        for (HotkeyInfo hotkeyInfo : hotkeys) {
            HotkeyManager.clearHotkeyCache(hotkeyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearHotkeysCache(Component component) {
        Object object = sync;
        synchronized (object) {
            hotkeys.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<HotkeyInfo> getComponentHotkeysCache(Component component) {
        Object object = sync;
        synchronized (object) {
            ArrayList<HotkeyInfo> list = hotkeys.get(component);
            return list != null ? list : new ArrayList<HotkeyInfo>();
        }
    }

    public static void showComponentHotkeys() {
        TooltipManager.hideAllTooltips();
        for (Window window : Window.getWindows()) {
            HotkeyManager.showComponentHotkeys(window);
        }
    }

    public static void showComponentHotkeys(Component component) {
        TooltipManager.hideAllTooltips();
        HotkeyManager.showComponentHotkeys(SwingUtils.getWindowAncestor(component));
    }

    protected static void showComponentHotkeys(Window window) {
        LinkedHashSet<Component> shown = new LinkedHashSet<Component>();
        for (Map.Entry<Component, List<HotkeyInfo>> entry : HotkeyManager.copyHotkeys().entrySet()) {
            for (HotkeyInfo hotkeyInfo : entry.getValue()) {
                Component forComponent;
                if (hotkeyInfo.isHidden() || (forComponent = hotkeyInfo.getForComponent()) == null || shown.contains(forComponent) || !forComponent.isVisible() || !forComponent.isShowing() || SwingUtils.getWindowAncestor(forComponent) != window) continue;
                WebLabel tip = new WebLabel(HotkeyManager.getComponentHotkeysString(forComponent));
                tip.setStyleId("custom-tooltip-hotkey-label");
                tip.setBoldFont();
                TooltipManager.showOneTimeTooltip(forComponent, null, tip, hotkeyInfo.getHotkeyDisplayWay());
                shown.add(forComponent);
            }
        }
    }

    public static void installShowAllHotkeysAction(Component topComponent) {
        HotkeyManager.installShowAllHotkeysAction(topComponent, Hotkey.F1);
    }

    public static void installShowAllHotkeysAction(final Component topComponent, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey(topComponent, topComponent, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                HotkeyManager.showComponentHotkeys(topComponent);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComponentHotkeysString(Component component) {
        Object object = sync;
        synchronized (object) {
            return HotkeyManager.getComponentHotkeysString(HotkeyManager.getComponentHotkeysCache(component));
        }
    }

    protected static String getComponentHotkeysString(List<HotkeyInfo> infoList) {
        StringBuilder hotkeys = new StringBuilder("");
        if (infoList != null) {
            for (HotkeyInfo hotkeyInfo : infoList) {
                if (hotkeyInfo.isHidden()) continue;
                hotkeys.append(hotkeyInfo.getHotkeyData().toString());
                if (infoList.indexOf(hotkeyInfo) >= infoList.size() - 1) continue;
                hotkeys.append(", ");
            }
        }
        return hotkeys.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableHotkeys() {
        Object object = sync;
        synchronized (object) {
            hotkeysEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableHotkeys() {
        Object object = sync;
        synchronized (object) {
            hotkeysEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTransferFocus() {
        Object object = sync;
        synchronized (object) {
            return transferFocus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTransferFocus(boolean transferFocus) {
        Object object = sync;
        synchronized (object) {
            HotkeyManager.transferFocus = transferFocus;
        }
    }
}

