/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.focus;

import com.alee.global.GlobalConstants;
import com.alee.log.Log;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class FocusManager {
    private static final Object trackersLock = new Object();
    private static final Map<Component, Map<FocusTracker, Boolean>> trackers = new WeakHashMap<Component, Map<FocusTracker, Boolean>>();
    private static final Object listenersLock = new Object();
    private static final List<GlobalFocusListener> globalFocusListeners = new ArrayList<GlobalFocusListener>(2);
    private static WeakReference<Component> oldFocusOwner;
    private static WeakReference<Component> focusOwner;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof FocusEvent && globalFocusListeners.size() > 0) {
                        FocusEvent focusEvent = (FocusEvent)event;
                        if (focusEvent.getID() == 1005 && focusEvent.getOppositeComponent() == null) {
                            FocusManager.fireGlobalFocusChanged(focusEvent.getComponent(), null);
                        } else if (focusEvent.getID() == 1004) {
                            FocusManager.fireGlobalFocusChanged(focusEvent.getOppositeComponent(), focusEvent.getComponent());
                        }
                    }
                }
            }, 4L);
            FocusManager.registerGlobalFocusListener(new GlobalFocusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusChanged(Component oldFocus, Component newFocus) {
                    oldFocusOwner = new WeakReference<Component>(oldFocus);
                    focusOwner = new WeakReference<Component>(newFocus);
                    if (GlobalConstants.DEBUG) {
                        String oldName = oldFocus != null ? oldFocus.getClass().getName() : null;
                        String newName = newFocus != null ? newFocus.getClass().getName() : null;
                        Log.debug((Object)this, (String)("Focus changed: " + oldName + " --> " + newName), (Object[])new Object[0]);
                    }
                    for (Map.Entry entry : FocusManager.getTrackersCopy().entrySet()) {
                        Component tracked = (Component)entry.getKey();
                        Map componentTrackers = (Map)entry.getValue();
                        for (Map.Entry innerEntry : componentTrackers.entrySet()) {
                            boolean focused;
                            FocusTracker focusTracker = (FocusTracker)innerEntry.getKey();
                            Boolean trackerStateCache = (Boolean)innerEntry.getValue();
                            if (tracked == null || !focusTracker.isTrackingEnabled()) continue;
                            boolean unite = focusTracker.isUniteWithChilds();
                            boolean bl = unite ? SwingUtils.isEqualOrChild(tracked, newFocus) : (focused = tracked == newFocus);
                            if (trackerStateCache != focused) {
                                focusTracker.focusChanged(focused);
                            }
                            Object object = trackersLock;
                            synchronized (object) {
                                Map ct = (Map)trackers.get(tracked);
                                if (ct != null && ct.containsKey(focusTracker)) {
                                    ct.put(focusTracker, focused);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Component, Map<FocusTracker, Boolean>> getTrackersCopy() {
        Object object = trackersLock;
        synchronized (object) {
            HashMap<Component, Map<FocusTracker, Boolean>> copy = new HashMap<Component, Map<FocusTracker, Boolean>>(trackers.size());
            for (Map.Entry<Component, Map<FocusTracker, Boolean>> entry : trackers.entrySet()) {
                Map<FocusTracker, Boolean> trackers = entry.getValue();
                HashMap<FocusTracker, Boolean> trackersCopy = new HashMap<FocusTracker, Boolean>(trackers.size());
                for (Map.Entry<FocusTracker, Boolean> innerEntry : trackers.entrySet()) {
                    trackersCopy.put(innerEntry.getKey(), innerEntry.getValue());
                }
                copy.put(entry.getKey(), trackersCopy);
            }
            return copy;
        }
    }

    public static Component getFocusOwner() {
        return (Component)focusOwner.get();
    }

    public static Component getOldFocusOwner() {
        return (Component)oldFocusOwner.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalFocusListener(GlobalFocusListener listener) {
        Object object = listenersLock;
        synchronized (object) {
            globalFocusListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGlobalFocusListener(GlobalFocusListener listener) {
        Object object = listenersLock;
        synchronized (object) {
            globalFocusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireGlobalFocusChanged(Component oldComponent, Component newComponent) {
        List listeners;
        Object object = listenersLock;
        synchronized (object) {
            listeners = CollectionUtils.copy(globalFocusListeners);
        }
        for (GlobalFocusListener listener : listeners) {
            listener.focusChanged(oldComponent, newComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFocusTracker(Component component, FocusTracker focusTracker) {
        Object object = trackersLock;
        synchronized (object) {
            Map<FocusTracker, Boolean> componentTrackers = trackers.get(component);
            if (componentTrackers == null) {
                componentTrackers = new WeakHashMap<FocusTracker, Boolean>();
                trackers.put(component, componentTrackers);
            }
            componentTrackers.put(focusTracker, focusTracker.isUniteWithChilds() ? SwingUtils.hasFocusOwner(component) : component.isFocusOwner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFocusTracker(FocusTracker focusTracker) {
        Object object = trackersLock;
        synchronized (object) {
            Iterator<Map.Entry<Component, Map<FocusTracker, Boolean>>> iterator = trackers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Component, Map<FocusTracker, Boolean>> entry = iterator.next();
                Map<FocusTracker, Boolean> componentTrackers = entry.getValue();
                componentTrackers.remove(focusTracker);
                if (componentTrackers.size() != 0) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFocusTrackers(Component component) {
        Object object = trackersLock;
        synchronized (object) {
            Map<FocusTracker, Boolean> allTrackers = trackers.get(component);
            if (allTrackers != null && allTrackers.size() > 0) {
                allTrackers.clear();
            }
            trackers.remove(component);
        }
    }

    static {
        initialized = false;
    }
}

