/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag;

import com.alee.log.Log;
import com.alee.managers.drag.DragViewHandler;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public final class DragManager {
    private static Map<DataFlavor, DragViewHandler> viewHandlers;
    private static WebGlassPane glassPane;
    private static Object data;
    private static BufferedImage view;
    private static DragViewHandler dragViewHandler;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            viewHandlers = new HashMap<DataFlavor, DragViewHandler>();
            DragSourceAdapter dsa = new DragSourceAdapter(){

                @Override
                public void dragEnter(DragSourceDragEvent dsde) {
                    DataFlavor[] flavors;
                    Transferable transferable = dsde.getDragSourceContext().getTransferable();
                    for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                        if (!viewHandlers.containsKey(flavor)) continue;
                        try {
                            data = transferable.getTransferData(flavor);
                            dragViewHandler = (DragViewHandler)viewHandlers.get(flavor);
                            view = dragViewHandler.getView(data);
                            glassPane = GlassPaneManager.getGlassPane(dsde.getDragSourceContext().getComponent());
                            glassPane.setPaintedImage(view, this.getLocation(glassPane));
                            break;
                        }
                        catch (Throwable e) {
                            Log.error(DragManager.class, (Throwable)e);
                        }
                    }
                }

                @Override
                public void dragMouseMoved(DragSourceDragEvent dsde) {
                    if (view != null) {
                        WebGlassPane gp = GlassPaneManager.getGlassPane(dsde.getDragSourceContext().getComponent());
                        if (gp != glassPane) {
                            glassPane.clearPaintedImage();
                            glassPane = gp;
                        }
                        gp.setPaintedImage(view, this.getLocation(gp));
                    }
                }

                public Point getLocation(WebGlassPane gp) {
                    Point mp = SwingUtils.getMousePoint(gp);
                    Point vp = dragViewHandler.getViewRelativeLocation(data);
                    return new Point(mp.x + vp.x, mp.y + vp.y);
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent dsde) {
                    if (view != null) {
                        glassPane.clearPaintedImage();
                        glassPane = null;
                        data = null;
                        view = null;
                        dragViewHandler = null;
                    }
                }
            };
            DragSource.getDefaultDragSource().addDragSourceListener(dsa);
            DragSource.getDefaultDragSource().addDragSourceMotionListener(dsa);
        }
    }

    public static void registerViewHandler(DragViewHandler dragViewHandler) {
        viewHandlers.put(dragViewHandler.getObjectFlavor(), dragViewHandler);
    }

    public static void unregisterViewHandler(DragViewHandler dragViewHandler) {
        viewHandlers.remove(dragViewHandler.getObjectFlavor());
    }

    static {
        initialized = false;
    }
}

