/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.NodeState;
import com.alee.laf.tree.TreeStateConverter;
import com.alee.utils.MapUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

@XStreamAlias(value="TreeState")
@XStreamConverter(value=TreeStateConverter.class)
public class TreeState
implements Serializable,
Cloneable {
    protected Map<String, NodeState> states = new LinkedHashMap<String, NodeState>();

    public TreeState() {
    }

    public TreeState(Map<String, NodeState> states) {
        if (states != null) {
            this.setStates(states);
        }
    }

    public Map<String, NodeState> getStates() {
        return this.states;
    }

    public void setStates(Map<String, NodeState> states) {
        this.states = states;
    }

    public void addState(String nodeId, boolean expanded, boolean selected) {
        this.states.put(nodeId, new NodeState(expanded, selected));
    }

    public boolean isExpanded(String nodeId) {
        NodeState state = this.states.get(nodeId);
        return state != null && state.isExpanded();
    }

    public boolean isSelected(String nodeId) {
        NodeState state = this.states.get(nodeId);
        return state != null && state.isSelected();
    }

    public TreeState clone() {
        return new TreeState(MapUtils.cloneLinkedHashMap((LinkedHashMap)((LinkedHashMap)this.states)));
    }
}

