/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class WebTextField
extends JTextField
implements ShapeProvider,
LanguageMethods,
SettingsMethods,
FontMethods<WebTextField>,
SizeMethods<WebTextField> {
    public WebTextField() {
    }

    public WebTextField(boolean drawBorder) {
        this.setDrawBorder(drawBorder);
    }

    public WebTextField(String text) {
        super(text);
    }

    public WebTextField(String text, boolean drawBorder) {
        super(text);
        this.setDrawBorder(drawBorder);
    }

    public WebTextField(int columns) {
        super(columns);
    }

    public WebTextField(int columns, boolean drawBorder) {
        super(columns);
        this.setDrawBorder(drawBorder);
    }

    public WebTextField(String text, int columns) {
        super(text, columns);
    }

    public WebTextField(String text, int columns, boolean drawBorder) {
        super(text, columns);
        this.setDrawBorder(drawBorder);
    }

    public WebTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public WebTextField(Document doc, String text, int columns, boolean drawBorder) {
        super(doc, text, columns);
        this.setDrawBorder(drawBorder);
    }

    public void clear() {
        this.setText("");
    }

    public boolean isDrawBorder() {
        return this.getWebUI().isDrawBorder();
    }

    public void setDrawBorder(boolean drawBorder) {
        this.getWebUI().setDrawBorder(drawBorder);
    }

    public boolean isDrawFocus() {
        return this.getWebUI().isDrawFocus();
    }

    public void setDrawFocus(boolean drawFocus) {
        this.getWebUI().setDrawFocus(drawFocus);
    }

    public JComponent getLeadingComponent() {
        return this.getWebUI().getLeadingComponent();
    }

    public void setLeadingComponent(JComponent leadingComponent) {
        this.getWebUI().setLeadingComponent(leadingComponent);
    }

    public JComponent getTrailingComponent() {
        return this.getWebUI().getTrailingComponent();
    }

    public void setTrailingComponent(JComponent trailingComponent) {
        this.getWebUI().setTrailingComponent(trailingComponent);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public void setFieldMargin(Insets margin) {
        this.getWebUI().setFieldMargin(margin);
    }

    public void setFieldMargin(int top, int left, int bottom, int right) {
        this.setFieldMargin(new Insets(top, left, bottom, right));
    }

    public void setFieldMargin(int spacing) {
        this.setFieldMargin(spacing, spacing, spacing, spacing);
    }

    public Insets getFieldMargin() {
        return this.getWebUI().getFieldMargin();
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public void setRound(int round) {
        this.getWebUI().setRound(round);
    }

    public boolean isDrawShade() {
        return this.getWebUI().isDrawShade();
    }

    public void setDrawShade(boolean drawShade) {
        this.getWebUI().setDrawShade(drawShade);
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public void setShadeWidth(int shadeWidth) {
        this.getWebUI().setShadeWidth(shadeWidth);
    }

    public boolean isDrawBackground() {
        return this.getWebUI().isDrawBackground();
    }

    public void setDrawBackground(boolean drawBackground) {
        this.getWebUI().setDrawBackground(drawBackground);
    }

    public boolean isWebColored() {
        return this.getWebUI().isWebColored();
    }

    public void setWebColored(boolean webColored) {
        this.getWebUI().setWebColored(webColored);
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public void setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
    }

    public String getInputPrompt() {
        return this.getWebUI().getInputPrompt();
    }

    public void setInputPrompt(String inputPrompt) {
        this.getWebUI().setInputPrompt(inputPrompt);
    }

    public Font getInputPromptFont() {
        return this.getWebUI().getInputPromptFont();
    }

    public void setInputPromptFont(Font inputPromptFont) {
        this.getWebUI().setInputPromptFont(inputPromptFont);
    }

    public Color getInputPromptForeground() {
        return this.getWebUI().getInputPromptForeground();
    }

    public void setInputPromptForeground(Color inputPromptForeground) {
        this.getWebUI().setInputPromptForeground(inputPromptForeground);
    }

    public int getInputPromptPosition() {
        return this.getWebUI().getInputPromptPosition();
    }

    public void setInputPromptPosition(int inputPromptPosition) {
        this.getWebUI().setInputPromptPosition(inputPromptPosition);
    }

    public boolean isHideInputPromptOnFocus() {
        return this.getWebUI().isHideInputPromptOnFocus();
    }

    public void setHideInputPromptOnFocus(boolean hideInputPromptOnFocus) {
        this.getWebUI().setHideInputPromptOnFocus(hideInputPromptOnFocus);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebTextFieldUI getWebUI() {
        return (WebTextFieldUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTextFieldUI)) {
            try {
                this.setUI((WebTextFieldUI)ReflectUtils.createInstance((String)WebLookAndFeel.textFieldUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebTextFieldUI());
            }
        } else {
            this.setUI(this.getUI());
        }
        this.invalidate();
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((Component)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((Component)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((Component)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((Component)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((Component)this);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((Component)this, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((Component)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((Component)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((Component)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((Component)this);
    }

    @Override
    public WebTextField setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTextField setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTextField setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTextField setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTextField setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTextField setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTextField setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTextField setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTextField setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTextField changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTextField setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTextField setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTextField setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    public static WebTextField createWebTextField() {
        return WebTextField.createWebTextField(StyleConstants.drawBorder);
    }

    public static WebTextField createWebTextField(boolean drawBorder) {
        return WebTextField.createWebTextField(drawBorder, StyleConstants.bigRound);
    }

    public static WebTextField createWebTextField(boolean drawBorder, int round) {
        return WebTextField.createWebTextField(drawBorder, round, StyleConstants.shadeWidth);
    }

    public static WebTextField createWebTextField(boolean drawBorder, int round, int shadeWidth) {
        WebTextField webTextField = new WebTextField();
        webTextField.setDrawBorder(drawBorder);
        webTextField.setRound(round);
        webTextField.setShadeWidth(shadeWidth);
        return webTextField;
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebTextField setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebTextField setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebTextField setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebTextField setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }
}

