/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.text.WebTextAreaUI;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.FontMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class WebTextArea
extends JTextArea
implements LanguageMethods,
SettingsMethods,
FontMethods<WebTextArea> {
    public WebTextArea() {
    }

    public WebTextArea(String text) {
        super(text);
    }

    public WebTextArea(int rows, int columns) {
        super(rows, columns);
    }

    public WebTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    public WebTextArea(Document doc) {
        super(doc);
    }

    public WebTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
    }

    public void clear() {
        this.setText("");
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public String getInputPrompt() {
        return this.getWebUI().getInputPrompt();
    }

    public void setInputPrompt(String inputPrompt) {
        this.getWebUI().setInputPrompt(inputPrompt);
    }

    public Font getInputPromptFont() {
        return this.getWebUI().getInputPromptFont();
    }

    public void setInputPromptFont(Font inputPromptFont) {
        this.getWebUI().setInputPromptFont(inputPromptFont);
    }

    public Color getInputPromptForeground() {
        return this.getWebUI().getInputPromptForeground();
    }

    public void setInputPromptForeground(Color inputPromptForeground) {
        this.getWebUI().setInputPromptForeground(inputPromptForeground);
    }

    public int getInputPromptHorizontalPosition() {
        return this.getWebUI().getInputPromptHorizontalPosition();
    }

    public void setInputPromptHorizontalPosition(int inputPromptHorizontalPosition) {
        this.getWebUI().setInputPromptHorizontalPosition(inputPromptHorizontalPosition);
    }

    public int getInputPromptVerticalPosition() {
        return this.getWebUI().getInputPromptVerticalPosition();
    }

    public void setInputPromptVerticalPosition(int inputPromptVerticalPosition) {
        this.getWebUI().setInputPromptVerticalPosition(inputPromptVerticalPosition);
    }

    public boolean isHideInputPromptOnFocus() {
        return this.getWebUI().isHideInputPromptOnFocus();
    }

    public void setHideInputPromptOnFocus(boolean hideInputPromptOnFocus) {
        this.getWebUI().setHideInputPromptOnFocus(hideInputPromptOnFocus);
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public void setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
    }

    public WebTextAreaUI getWebUI() {
        return (WebTextAreaUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTextAreaUI)) {
            try {
                this.setUI((WebTextAreaUI)ReflectUtils.createInstance((String)WebLookAndFeel.textAreaUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebTextAreaUI());
            }
        } else {
            this.setUI(this.getUI());
        }
        this.invalidate();
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((Component)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((Component)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((Component)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((Component)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((Component)this);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((Component)this, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((Component)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((Component)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((Component)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((Component)this);
    }

    @Override
    public WebTextArea setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTextArea setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTextArea setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTextArea setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTextArea setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTextArea setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTextArea setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTextArea setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTextArea setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTextArea changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTextArea setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTextArea setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTextArea setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }
}

