/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.text.TextComponentLayout;
import com.alee.laf.text.WebPasswordFieldStyle;
import com.alee.laf.text.WebTextFieldStyle;
import com.alee.managers.language.LM;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class WebPasswordFieldUI
extends BasicPasswordFieldUI
implements ShapeProvider,
SwingConstants,
BorderMethods {
    private boolean drawBorder = WebPasswordFieldStyle.drawBorder;
    private boolean drawFocus = WebPasswordFieldStyle.drawFocus;
    private int round = WebPasswordFieldStyle.round;
    private boolean drawShade = WebPasswordFieldStyle.drawShade;
    private int shadeWidth = WebPasswordFieldStyle.shadeWidth;
    private boolean drawBackground = WebPasswordFieldStyle.drawBackground;
    private boolean webColored = WebPasswordFieldStyle.webColored;
    private Insets fieldMargin = WebPasswordFieldStyle.fieldMargin;
    private String inputPrompt = WebTextFieldStyle.inputPrompt;
    private Font inputPromptFont = WebTextFieldStyle.inputPromptFont;
    private Color inputPromptForeground = WebTextFieldStyle.inputPromptForeground;
    private int inputPromptPosition = WebTextFieldStyle.inputPromptPosition;
    private boolean hideInputPromptOnFocus = WebTextFieldStyle.hideInputPromptOnFocus;
    private Painter painter = WebPasswordFieldStyle.painter;
    private JPasswordField passwordField;
    private JComponent leadingComponent = null;
    private JComponent trailingComponent = null;
    private boolean inputPromptSet = false;
    private FocusListener focusListener;
    private PropertyChangeListener accessibleChangeListener;
    private PropertyChangeListener orientationChangeListener;
    private PropertyChangeListener marginChangeListener;
    private ComponentAdapter componentResizeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebPasswordFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.passwordField = (JPasswordField)c;
        SwingUtils.setOrientation(this.passwordField);
        LookAndFeel.installProperty(this.passwordField, "opaque", Boolean.FALSE);
        this.passwordField.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.passwordField.setFocusable(true);
        this.passwordField.setMargin(WebPasswordFieldStyle.margin);
        this.passwordField.setBackground(Color.WHITE);
        this.passwordField.setSelectionColor(StyleConstants.textSelectionColor);
        this.passwordField.setForeground(Color.BLACK);
        this.passwordField.setSelectedTextColor(Color.BLACK);
        this.passwordField.setCaretColor(Color.GRAY);
        this.passwordField.setLayout(new TextComponentLayout(this.passwordField));
        PainterSupport.installPainter(this.passwordField, this.painter);
        this.updateBorder();
        this.focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                WebPasswordFieldUI.this.passwordField.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                WebPasswordFieldUI.this.passwordField.repaint();
            }
        };
        this.passwordField.addFocusListener(this.focusListener);
        this.accessibleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebPasswordFieldUI.this.updateInnerComponents();
            }
        };
        this.passwordField.addPropertyChangeListener("enabled", this.accessibleChangeListener);
        this.orientationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebPasswordFieldUI.this.updateBorder();
            }
        };
        this.passwordField.addPropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.marginChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebPasswordFieldUI.this.updateBorder();
            }
        };
        this.passwordField.addPropertyChangeListener("margin", this.marginChangeListener);
        this.componentResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebPasswordFieldUI.this.updateBorder();
            }
        };
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.passwordField, this.painter);
        this.passwordField.putClientProperty("HANDLES_ENABLE_STATE", null);
        this.passwordField.removeFocusListener(this.focusListener);
        this.passwordField.removePropertyChangeListener("enabled", this.accessibleChangeListener);
        this.passwordField.removePropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.passwordField.removePropertyChangeListener("margin", this.marginChangeListener);
        this.cleanupLeadingComponent();
        this.cleanupTrailingComponent();
        this.passwordField.setLayout(null);
        this.passwordField = null;
        super.uninstallUI(c);
    }

    @Override
    public Shape provideShape() {
        if (this.drawBorder) {
            return LafUtils.getWebBorderShape(this.passwordField, this.shadeWidth, this.round);
        }
        return SwingUtils.size(this.passwordField);
    }

    private void updateInnerComponents() {
        if (this.leadingComponent != null) {
            this.leadingComponent.setEnabled(this.passwordField.isEnabled());
        }
        if (this.trailingComponent != null) {
            this.trailingComponent.setEnabled(this.passwordField.isEnabled());
        }
    }

    public JComponent getLeadingComponent() {
        return this.leadingComponent;
    }

    public void setLeadingComponent(JComponent leadingComponent) {
        if (this.leadingComponent == leadingComponent) {
            return;
        }
        this.cleanupLeadingComponent();
        if (leadingComponent != null) {
            this.leadingComponent = leadingComponent;
            this.leadingComponent.addComponentListener(this.componentResizeListener);
            this.passwordField.add((Component)leadingComponent, "LEADING");
            this.updateInnerComponents();
        }
        this.passwordField.revalidate();
        this.updateBorder();
    }

    private void cleanupLeadingComponent() {
        if (this.leadingComponent != null) {
            this.leadingComponent.removeComponentListener(this.componentResizeListener);
            this.passwordField.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    public JComponent getTrailingComponent() {
        return this.trailingComponent;
    }

    public void setTrailingComponent(JComponent trailingComponent) {
        if (this.trailingComponent == trailingComponent) {
            return;
        }
        this.cleanupTrailingComponent();
        if (trailingComponent != null) {
            this.trailingComponent = trailingComponent;
            this.trailingComponent.addComponentListener(this.componentResizeListener);
            this.passwordField.add((Component)trailingComponent, "TRAILING");
            this.updateInnerComponents();
        }
        this.passwordField.revalidate();
        this.updateBorder();
    }

    private void cleanupTrailingComponent() {
        if (this.trailingComponent != null) {
            this.trailingComponent.removeComponentListener(this.componentResizeListener);
            this.passwordField.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    public void setFieldMargin(Insets margin) {
        this.fieldMargin = margin;
        this.updateBorder();
    }

    public Insets getFieldMargin() {
        return this.fieldMargin;
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String inputPrompt) {
        this.inputPrompt = inputPrompt;
        this.inputPromptSet = inputPrompt != null && !inputPrompt.trim().equals("");
        this.updateInputPromptView();
    }

    public Font getInputPromptFont() {
        return this.inputPromptFont;
    }

    public void setInputPromptFont(Font inputPromptFont) {
        this.inputPromptFont = inputPromptFont;
        this.updateInputPromptView();
    }

    public Color getInputPromptForeground() {
        return this.inputPromptForeground;
    }

    public void setInputPromptForeground(Color inputPromptForeground) {
        this.inputPromptForeground = inputPromptForeground;
        this.updateInputPromptView();
    }

    public int getInputPromptPosition() {
        return this.inputPromptPosition;
    }

    public void setInputPromptPosition(int inputPromptPosition) {
        this.inputPromptPosition = inputPromptPosition;
        this.updateInputPromptView();
    }

    public boolean isHideInputPromptOnFocus() {
        return this.hideInputPromptOnFocus;
    }

    public void setHideInputPromptOnFocus(boolean hideInputPromptOnFocus) {
        this.hideInputPromptOnFocus = hideInputPromptOnFocus;
        this.updateInputPromptView();
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
        this.updateView();
    }

    public boolean isWebColored() {
        return this.webColored;
    }

    public void setWebColored(boolean webColored) {
        this.webColored = webColored;
        this.updateView();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.updateView();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
        this.updateView();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.passwordField, this.painter);
        this.painter = painter;
        this.getComponent().setOpaque(painter == null || painter.isOpaque(this.passwordField) != false);
        PainterSupport.installPainter(this.passwordField, this.painter);
        this.updateBorder();
    }

    private void updateInputPromptView() {
        if (this.isInputPromptVisible(this.getComponent())) {
            this.updateView();
        }
    }

    private boolean isInputPromptVisible(JTextComponent c) {
        return this.inputPromptSet && c.isEditable() && c.isEnabled() && (!this.hideInputPromptOnFocus || !c.isFocusOwner()) && c.getText().equals("");
    }

    private void updateView() {
        if (this.passwordField != null) {
            this.passwordField.repaint();
        }
    }

    @Override
    public void updateBorder() {
        if (this.passwordField != null) {
            JComponent tc;
            if (SwingUtils.isPreserveBorders(this.passwordField)) {
                return;
            }
            Insets m = this.painter != null ? this.painter.getMargin(this.getComponent()) : (this.drawBorder ? new Insets(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1) : new Insets(0, 0, 0, 0));
            boolean ltr = this.passwordField.getComponentOrientation().isLeftToRight();
            Insets margin = this.passwordField.getMargin();
            if (margin != null) {
                m.top += margin.top;
                m.left = m.left + (ltr ? margin.left : margin.right);
                m.bottom += margin.bottom;
                m.right = m.right + (ltr ? margin.right : margin.left);
            }
            if (this.fieldMargin != null) {
                m.top += this.fieldMargin.top;
                m.left = m.left + (ltr ? this.fieldMargin.left : this.fieldMargin.right);
                m.bottom += this.fieldMargin.bottom;
                m.right = m.right + (ltr ? this.fieldMargin.right : this.fieldMargin.left);
            }
            JComponent lc = ltr ? this.leadingComponent : this.trailingComponent;
            JComponent jComponent = tc = ltr ? this.trailingComponent : this.leadingComponent;
            if (lc != null) {
                m.left += ((Component)lc).getPreferredSize().width;
            }
            if (tc != null) {
                m.right += ((Component)tc).getPreferredSize().width;
            }
            this.passwordField.setBorder(LafUtils.createWebBorder(m));
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent c = this.getComponent();
        Graphics2D g2d = (Graphics2D)g;
        if (c.isOpaque() && (this.painter == null || !this.painter.isOpaque(this.passwordField).booleanValue())) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.painter != null || this.drawBorder) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            if (this.painter != null) {
                this.painter.paint(g2d, SwingUtils.size(c), c);
            } else if (this.drawBorder) {
                Color shadeColor = this.drawShade ? (this.drawFocus && c.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor) : null;
                LafUtils.drawWebStyle(g2d, c, shadeColor, this.shadeWidth, this.round, this.drawBackground, this.webColored);
            }
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        }
        Map hints = SwingUtils.setupTextAntialias(g2d);
        super.paintSafely(g);
        if (this.isInputPromptVisible(c)) {
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            Rectangle b = this.getVisibleEditorRect();
            Shape oc = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)b);
            g2d.setFont(this.inputPromptFont != null ? this.inputPromptFont : c.getFont());
            g2d.setPaint(this.inputPromptForeground != null ? this.inputPromptForeground : c.getForeground());
            String text = LM.get((String)this.inputPrompt);
            FontMetrics fm = g2d.getFontMetrics();
            int x = this.inputPromptPosition == 0 ? b.x + b.width / 2 - fm.stringWidth(text) / 2 : (ltr && this.inputPromptPosition == 10 || !ltr && this.inputPromptPosition == 11 || this.inputPromptPosition == 2 ? b.x : b.x + b.width - fm.stringWidth(text));
            g2d.drawString(text, x, this.getBaseline(c, c.getWidth(), c.getHeight()));
            GraphicsUtils.restoreClip((Graphics)g2d, (Shape)oc);
        }
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        ++ps.width;
        if (this.leadingComponent != null || this.trailingComponent != null) {
            Dimension lps = c.getLayout().preferredLayoutSize(c);
            ps.height = Math.max(ps.height, lps.height);
        }
        if (this.painter != null) {
            ps = SwingUtils.max(ps, this.painter.getPreferredSize(c));
        }
        return ps;
    }
}

