/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.text.WebPasswordFieldUI;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.utils.collection.ValuesTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class TextComponentLayout
extends AbstractLayoutManager {
    public static final String LEADING = "LEADING";
    public static final String TRAILING = "TRAILING";
    private static final Insets emptyInsets = new Insets(0, 0, 0, 0);
    private ValuesTable<Component, String> constraints = new ValuesTable();
    private JTextComponent textComponent;

    public TextComponentLayout(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        String value = (String)constraints;
        if (value == null || !value.equals(LEADING) && !value.equals(TRAILING)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'LEADING' or 'TRAILING' string");
        }
        this.constraints.put((Object)component, (Object)value);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove((Object)component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets b = this.getInsets(parent);
        Dimension l = this.constraints.containsValue((Object)LEADING) ? ((Component)this.constraints.getKey((Object)LEADING)).getPreferredSize() : new Dimension();
        Dimension t = this.constraints.containsValue((Object)TRAILING) ? ((Component)this.constraints.getKey((Object)TRAILING)).getPreferredSize() : new Dimension();
        return new Dimension(b.left + l.width + t.width + b.right, b.top + Math.max(l.height, t.height) + b.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        int w;
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        Insets b = this.getInsets(parent);
        if (this.constraints.containsValue((Object)LEADING)) {
            Component leading = (Component)this.constraints.getKey((Object)LEADING);
            w = leading.getPreferredSize().width;
            if (ltr) {
                leading.setBounds(b.left - w, b.top, w, parent.getHeight() - b.top - b.bottom);
            } else {
                leading.setBounds(parent.getWidth() - b.right, b.top, w, parent.getHeight() - b.top - b.bottom);
            }
        }
        if (this.constraints.containsValue((Object)TRAILING)) {
            Component trailing = (Component)this.constraints.getKey((Object)TRAILING);
            w = trailing.getPreferredSize().width;
            if (ltr) {
                trailing.setBounds(parent.getWidth() - b.right, b.top, w, parent.getHeight() - b.top - b.bottom);
            } else {
                trailing.setBounds(b.left - w, b.top, w, parent.getHeight() - b.top - b.bottom);
            }
        }
    }

    private Insets getInsets(Container parent) {
        Insets b = parent.getInsets();
        Insets fm = this.getFieldMargin();
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        return new Insets(b.top - fm.top, b.left - (ltr ? fm.left : fm.right), b.bottom - fm.bottom, b.right - (ltr ? fm.right : fm.left));
    }

    private Insets getFieldMargin() {
        TextUI ui = this.textComponent.getUI();
        if (ui instanceof WebTextFieldUI) {
            return ((WebTextFieldUI)ui).getFieldMargin();
        }
        if (ui instanceof WebPasswordFieldUI) {
            return ((WebPasswordFieldUI)ui).getFieldMargin();
        }
        return emptyInsets;
    }
}

