/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.table.WebTableCorner;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.editors.WebBooleanEditor;
import com.alee.laf.table.editors.WebGenericEditor;
import com.alee.laf.table.editors.WebNumberEditor;
import com.alee.laf.table.renderers.WebBooleanRenderer;
import com.alee.laf.table.renderers.WebDateRenderer;
import com.alee.laf.table.renderers.WebDoubleRenderer;
import com.alee.laf.table.renderers.WebIconRenderer;
import com.alee.laf.table.renderers.WebNumberRenderer;
import com.alee.laf.table.renderers.WebTableCellRenderer;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class WebTableUI
extends BasicTableUI {
    private AncestorAdapter ancestorAdapter;

    public static ComponentUI createUI(JComponent c) {
        return new WebTableUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.table);
        LookAndFeel.installProperty(this.table, "opaque", Boolean.FALSE);
        this.table.setFillsViewportHeight(false);
        this.table.setBackground(WebTableStyle.background);
        this.table.setForeground(WebTableStyle.foreground);
        this.table.setSelectionBackground(WebTableStyle.selectionBackground);
        this.table.setSelectionForeground(WebTableStyle.selectionForeground);
        this.table.setRowHeight(WebTableStyle.rowHeight);
        this.table.setShowHorizontalLines(WebTableStyle.showHorizontalLines);
        this.table.setShowVerticalLines(WebTableStyle.showVerticalLines);
        this.table.setIntercellSpacing(WebTableStyle.cellsSpacing);
        this.table.setDefaultRenderer(Object.class, new WebTableCellRenderer());
        this.table.setDefaultRenderer(Number.class, new WebNumberRenderer());
        this.table.setDefaultRenderer(Double.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Float.class, new WebDoubleRenderer());
        this.table.setDefaultRenderer(Date.class, new WebDateRenderer());
        this.table.setDefaultRenderer(Icon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(ImageIcon.class, new WebIconRenderer());
        this.table.setDefaultRenderer(Boolean.class, new WebBooleanRenderer());
        this.table.setDefaultEditor(Object.class, new WebGenericEditor());
        this.table.setDefaultEditor(Number.class, new WebNumberEditor());
        this.table.setDefaultEditor(Boolean.class, new WebBooleanEditor());
        this.configureEnclosingScrollPaneUI(this.table);
        this.ancestorAdapter = new AncestorAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                WebTableUI.this.configureEnclosingScrollPaneUI(WebTableUI.this.table);
            }
        };
        this.table.addAncestorListener((AncestorListener)this.ancestorAdapter);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.table.removeAncestorListener((AncestorListener)this.ancestorAdapter);
        super.uninstallUI(c);
    }

    protected void configureEnclosingScrollPaneUI(JTable table) {
        JScrollPane scrollPane = SwingUtils.getScrollPane(table);
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != table) {
                return;
            }
            scrollPane.setCorner("UPPER_LEADING_CORNER", new WebTableCorner(false));
            scrollPane.setCorner("UPPER_TRAILING_CORNER", new WebTableCorner(true));
        }
    }
}

