/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.splitpane.WebSplitPaneStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.BorderMethods;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class WebSplitPaneUI
extends BasicSplitPaneUI
implements BorderMethods {
    protected Insets margin = WebSplitPaneStyle.margin;
    protected Color dragDividerColor = WebSplitPaneStyle.dragDividerColor;
    protected boolean drawDividerBorder = WebSplitPaneStyle.drawDividerBorder;
    protected Color dividerBorderColor = WebSplitPaneStyle.dividerBorderColor;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebSplitPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.splitPane);
        LookAndFeel.installProperty(this.splitPane, "opaque", Boolean.FALSE);
        this.splitPane.setBorder(LafUtils.createWebBorder(0));
        this.splitPane.setDividerSize(6);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebSplitPaneUI.this.updateBorder();
            }
        };
        this.splitPane.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.splitPane.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        super.uninstallUI(c);
    }

    @Override
    public void updateBorder() {
        if (this.splitPane != null) {
            if (SwingUtils.isPreserveBorders(this.splitPane)) {
                return;
            }
            boolean ltr = this.splitPane.getComponentOrientation().isLeftToRight();
            Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
            this.splitPane.setBorder(LafUtils.createWebBorder(m));
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public Color getDragDividerColor() {
        return this.dragDividerColor;
    }

    public void setDragDividerColor(Color dragDividerColor) {
        this.dragDividerColor = dragDividerColor;
    }

    public boolean isDrawDividerBorder() {
        return this.drawDividerBorder;
    }

    public void setDrawDividerBorder(boolean draw) {
        this.drawDividerBorder = draw;
    }

    public Color getDividerBorderColor() {
        return this.dividerBorderColor;
    }

    public void setDividerBorderColor(Color color) {
        this.dividerBorderColor = color;
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this){
            protected final Border border;
            protected final Color color;
            protected final Color[] gradient;
            {
                this.border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
                this.color = new Color(158, 158, 158);
                this.gradient = new Color[]{StyleConstants.transparent, this.color, this.color, StyleConstants.transparent};
            }

            @Override
            public Border getBorder() {
                return this.border;
            }

            @Override
            protected JButton createLeftOneTouchButton() {
                WebButton iconWebButton = WebButton.createIconWebButton(new ImageIcon(WebSplitPaneUI.class.getResource(this.orientation == 1 ? "icons/left.png" : "icons/up.png")), 0, 0, 0, false, true, false);
                iconWebButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                iconWebButton.setCursor(Cursor.getDefaultCursor());
                iconWebButton.setPreferredSize(this.orientation == 1 ? new Dimension(6, 7) : new Dimension(7, 6));
                return iconWebButton;
            }

            @Override
            protected JButton createRightOneTouchButton() {
                WebButton iconWebButton = WebButton.createIconWebButton(new ImageIcon(WebSplitPaneUI.class.getResource(this.orientation == 1 ? "icons/right.png" : "icons/down.png")), 0, 0, 0, false, true, false);
                iconWebButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                iconWebButton.setCursor(Cursor.getDefaultCursor());
                iconWebButton.setPreferredSize(this.orientation == 1 ? new Dimension(6, 7) : new Dimension(7, 6));
                return iconWebButton;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
                if (this.orientation == 1) {
                    int startY = this.getHeight() / 2 - 35;
                    int endY = this.getHeight() / 2 + 35;
                    g2d.setPaint(new LinearGradientPaint(0.0f, startY, 0.0f, endY, new float[]{0.0f, 0.25f, 0.75f, 1.0f}, this.gradient));
                    for (int i = startY; i < endY; i += 5) {
                        g2d.fillRect(this.getWidth() / 2 - 1, i - 1, 2, 2);
                    }
                    if (WebSplitPaneUI.this.drawDividerBorder) {
                        g2d.setPaint(WebSplitPaneUI.this.dividerBorderColor);
                        g2d.drawLine(0, 0, 0, this.getHeight() - 1);
                        g2d.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
                    }
                } else {
                    int startX = this.getWidth() / 2 - 35;
                    int endX = this.getWidth() / 2 + 35;
                    g2d.setPaint(new LinearGradientPaint(startX, 0.0f, endX, 0.0f, new float[]{0.0f, 0.25f, 0.75f, 1.0f}, this.gradient));
                    for (int i = startX; i < endX; i += 5) {
                        g2d.fillRect(i - 1, this.getHeight() / 2 - 1, 2, 2);
                    }
                    if (WebSplitPaneUI.this.drawDividerBorder) {
                        g2d.setPaint(WebSplitPaneUI.this.dividerBorderColor);
                        g2d.drawLine(0, 0, this.getWidth() - 1, 0);
                        g2d.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
                    }
                }
                super.paint(g);
                GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
            }
        };
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics g) {
                if (!WebSplitPaneUI.this.isContinuousLayout() && WebSplitPaneUI.this.getLastDragLocation() != -1) {
                    Dimension size = WebSplitPaneUI.this.splitPane.getSize();
                    g.setColor(WebSplitPaneUI.this.dragDividerColor);
                    if (WebSplitPaneUI.this.getOrientation() == 1) {
                        g.fillRect(0, 0, WebSplitPaneUI.this.dividerSize - 1, size.height - 1);
                    } else {
                        g.fillRect(0, 0, size.width - 1, WebSplitPaneUI.this.dividerSize - 1);
                    }
                }
            }
        };
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
        if (jc == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension size = this.splitPane.getSize();
            g.setColor(this.dragDividerColor);
            if (this.getOrientation() == 1) {
                g.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, size.height - 1);
            } else {
                g.fillRect(0, this.getLastDragLocation(), size.width - 1, this.dividerSize - 1);
            }
        }
    }
}

