/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.separator;

import com.alee.laf.separator.WebSeparatorStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class WebSeparatorUI
extends BasicSeparatorUI {
    private static final float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
    private Color separatorLightUpperColor = WebSeparatorStyle.separatorLightUpperColor;
    private Color separatorLightColor = WebSeparatorStyle.separatorLightColor;
    private Color separatorUpperColor = WebSeparatorStyle.separatorUpperColor;
    private Color separatorColor = WebSeparatorStyle.separatorColor;
    private boolean reversedColors = WebSeparatorStyle.reversedColors;
    private boolean drawLeadingLine = WebSeparatorStyle.drawLeadingLine;
    private boolean drawTrailingLine = WebSeparatorStyle.drawTrailingLine;
    private Insets margin = WebSeparatorStyle.margin;
    private JSeparator separator;

    public static ComponentUI createUI(JComponent c) {
        return new WebSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.separator = (JSeparator)c;
        SwingUtils.setOrientation(this.separator);
        LookAndFeel.installProperty(this.separator, "opaque", Boolean.FALSE);
        this.updateBorder();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.separator = null;
        super.uninstallUI(c);
    }

    private void updateBorder() {
        if (this.separator != null) {
            if (SwingUtils.isPreserveBorders(this.separator)) {
                return;
            }
            boolean ltr = this.separator.getComponentOrientation().isLeftToRight();
            Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
            this.separator.setBorder(LafUtils.createWebBorder(m));
        }
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    public Color getSeparatorUpperColor() {
        return this.separatorUpperColor;
    }

    public void setSeparatorUpperColor(Color separatorUpperColor) {
        this.separatorUpperColor = separatorUpperColor;
    }

    public Color getSeparatorLightColor() {
        return this.separatorLightColor;
    }

    public void setSeparatorLightColor(Color separatorLightColor) {
        this.separatorLightColor = separatorLightColor;
    }

    public Color getSeparatorLightUpperColor() {
        return this.separatorLightUpperColor;
    }

    public void setSeparatorLightUpperColor(Color separatorLightUpperColor) {
        this.separatorLightUpperColor = separatorLightUpperColor;
    }

    public boolean isReversedColors() {
        return this.reversedColors;
    }

    public void setReversedColors(boolean reversedColors) {
        this.reversedColors = reversedColors;
    }

    public boolean isDrawLeadingLine() {
        return this.drawLeadingLine;
    }

    public void setDrawLeadingLine(boolean drawLeadingLine) {
        this.drawLeadingLine = drawLeadingLine;
    }

    public boolean isDrawTrailingLine() {
        return this.drawTrailingLine;
    }

    public void setDrawTrailingLine(boolean drawTrailingLine) {
        this.drawTrailingLine = drawTrailingLine;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean drawSideLines;
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        JSeparator separator = (JSeparator)c;
        Insets insets = c.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = c.getWidth() - insets.left - insets.right;
        int height = c.getHeight() - insets.top - insets.bottom;
        boolean bl = drawSideLines = this.drawLeadingLine || this.drawTrailingLine;
        if (separator.getOrientation() == 1) {
            if (height > 0) {
                if (drawSideLines) {
                    g2d.setPaint(new LinearGradientPaint(x, y, x, y + height, fractions, this.getLightColors()));
                    if (this.drawLeadingLine) {
                        g2d.drawLine(x, y, x, y + height);
                    }
                    if (this.drawTrailingLine) {
                        g2d.drawLine(x + (this.drawLeadingLine ? 2 : 1), y, x + (this.drawLeadingLine ? 2 : 1), y + height);
                    }
                }
                g2d.setPaint(new LinearGradientPaint(x, y, x, y + height, fractions, this.getDarkColors()));
                g2d.drawLine(x + (this.drawLeadingLine ? 1 : 0), y, x + (this.drawLeadingLine ? 1 : 0), y + height);
            }
        } else if (width > 0) {
            if (drawSideLines) {
                g2d.setPaint(new LinearGradientPaint(x, y, x + width, y, fractions, this.getLightColors()));
                if (this.drawLeadingLine) {
                    g2d.drawLine(x, y, x + width, y);
                }
                if (this.drawTrailingLine) {
                    g2d.drawLine(x, y + (this.drawLeadingLine ? 2 : 1), x + width, y + (this.drawLeadingLine ? 2 : 1));
                }
            }
            g2d.setPaint(new LinearGradientPaint(x, y, x + width, y, fractions, this.getDarkColors()));
            g2d.drawLine(x, y + (this.drawLeadingLine ? 1 : 0), x + width, y + (this.drawLeadingLine ? 1 : 0));
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    private Color[] getLightColors() {
        Color[] colorArray;
        if (this.reversedColors) {
            Color[] colorArray2 = new Color[3];
            colorArray2[0] = this.separatorUpperColor;
            colorArray2[1] = this.separatorColor;
            colorArray = colorArray2;
            colorArray2[2] = this.separatorUpperColor;
        } else {
            Color[] colorArray3 = new Color[3];
            colorArray3[0] = this.separatorLightUpperColor;
            colorArray3[1] = Color.WHITE;
            colorArray = colorArray3;
            colorArray3[2] = this.separatorLightUpperColor;
        }
        return colorArray;
    }

    private Color[] getDarkColors() {
        Color[] colorArray;
        if (this.reversedColors) {
            Color[] colorArray2 = new Color[3];
            colorArray2[0] = this.separatorLightUpperColor;
            colorArray2[1] = Color.WHITE;
            colorArray = colorArray2;
            colorArray2[2] = this.separatorLightUpperColor;
        } else {
            Color[] colorArray3 = new Color[3];
            colorArray3[0] = this.separatorUpperColor;
            colorArray3[1] = this.separatorColor;
            colorArray = colorArray3;
            colorArray3[2] = this.separatorUpperColor;
        }
        return colorArray;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        int bonus = 1 + (this.drawLeadingLine ? 1 : 0) + (this.drawTrailingLine ? 1 : 0);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(insets.left + bonus + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + bonus + insets.bottom);
    }
}

