/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.scroll.WebScrollBar;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JScrollPane;

public class WebScrollPane
extends JScrollPane
implements ShapeProvider,
SizeMethods<WebScrollPane>,
LanguageContainerMethods {
    public WebScrollPane(Component view) {
        this(view, true);
    }

    public WebScrollPane(Component view, boolean drawBorder) {
        this(view, drawBorder, true);
    }

    public WebScrollPane(Component view, boolean drawBorder, boolean drawInnerBorder) {
        super(view);
        this.setDrawBorder(drawBorder);
        this.getWebHorizontalScrollBar().setPaintTrack(drawInnerBorder);
        this.getWebVerticalScrollBar().setPaintTrack(drawInnerBorder);
        if (!drawInnerBorder) {
            this.setCorner("LOWER_RIGHT_CORNER", null);
        }
    }

    @Override
    public WebScrollBar createVerticalScrollBar() {
        return new WebScrollBar(1);
    }

    @Override
    public WebScrollBar createHorizontalScrollBar() {
        return new WebScrollBar(0);
    }

    public WebScrollBar getWebVerticalScrollBar() {
        return (WebScrollBar)super.getVerticalScrollBar();
    }

    public WebScrollBar getWebHorizontalScrollBar() {
        return (WebScrollBar)super.getHorizontalScrollBar();
    }

    public boolean isDrawBorder() {
        return this.getWebUI().isDrawBorder();
    }

    public WebScrollPane setDrawBorder(boolean drawBorder) {
        this.getWebUI().setDrawBorder(drawBorder);
        return this;
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public WebScrollPane setRound(int round) {
        this.getWebUI().setRound(round);
        return this;
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public WebScrollPane setShadeWidth(int shadeWidth) {
        this.getWebUI().setShadeWidth(shadeWidth);
        return this;
    }

    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public WebScrollPane setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
        return this;
    }

    public WebScrollPane setMargin(int top, int left, int bottom, int right) {
        return this.setMargin(new Insets(top, left, bottom, right));
    }

    public WebScrollPane setMargin(int spacing) {
        return this.setMargin(spacing, spacing, spacing, spacing);
    }

    public boolean isDrawFocus() {
        return this.getWebUI().isDrawFocus();
    }

    public WebScrollPane setDrawFocus(boolean drawFocus) {
        this.getWebUI().setDrawFocus(drawFocus);
        return this;
    }

    public boolean isDrawBackground() {
        return this.getWebUI().isDrawBackground();
    }

    public WebScrollPane setDrawBackground(boolean drawBackground) {
        this.getWebUI().setDrawBackground(drawBackground);
        return this;
    }

    public Color getBorderColor() {
        return this.getWebUI().getBorderColor();
    }

    public WebScrollPane setBorderColor(Color borderColor) {
        this.getWebUI().setBorderColor(borderColor);
        return this;
    }

    public Color getDarkBorder() {
        return this.getWebUI().getDarkBorder();
    }

    public WebScrollPane setDarkBorder(Color darkBorder) {
        this.getWebUI().setDarkBorder(darkBorder);
        return this;
    }

    public void setPaintButtons(boolean paintButtons) {
        WebScrollBar vsb;
        WebScrollBar hsb = this.getWebHorizontalScrollBar();
        if (hsb != null) {
            hsb.setPaintButtons(paintButtons);
        }
        if ((vsb = this.getWebVerticalScrollBar()) != null) {
            vsb.setPaintButtons(paintButtons);
        }
    }

    public void setScrollBarStyleId(String id) {
        LafUtils.setScrollBarStyleId(this, id);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebScrollPaneUI getWebUI() {
        return (WebScrollPaneUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebScrollPaneUI)) {
            try {
                this.setUI((WebScrollPaneUI)ReflectUtils.createInstance((String)WebLookAndFeel.scrollPaneUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebScrollPaneUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebScrollPane setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebScrollPane setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebScrollPane setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebScrollPane setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer((Container)this, (String)key);
    }

    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer((Container)this);
    }

    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey((Container)this);
    }
}

