/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.laf.button.WebButton;
import com.alee.laf.scroll.AdaptiveScrollBarButtonPainter;
import com.alee.laf.scroll.AdaptiveScrollBarPainter;
import com.alee.laf.scroll.ScrollBarButtonPainter;
import com.alee.laf.scroll.ScrollBarButtonType;
import com.alee.laf.scroll.ScrollBarPainter;
import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.managers.style.StyleManager;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.BorderMethods;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WebScrollBarUI
extends BasicScrollBarUI
implements Styleable,
BorderMethods {
    protected Insets margin = WebScrollBarStyle.margin;
    protected int scrollBarWidth = WebScrollBarStyle.scrollBarWidth;
    protected boolean paintButtons = WebScrollBarStyle.paintButtons;
    protected boolean paintTrack = WebScrollBarStyle.paintTrack;
    protected ScrollBarPainter painter;
    protected ScrollBarButtonPainter decreaseButtonPainter;
    protected ScrollBarButtonPainter increaseButtonPainter;
    protected PropertyChangeListener orientationChangeListener;
    protected String styleId = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.scrollbar);
        SwingUtils.setHandlesEnableStateMark(this.scrollbar);
        StyleManager.applySkin(this.scrollbar);
        this.orientationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebScrollBarUI.this.updateBorder();
            }
        };
        this.scrollbar.addPropertyChangeListener("componentOrientation", this.orientationChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.scrollbar.removePropertyChangeListener("componentOrientation", this.orientationChangeListener);
        StyleManager.removeSkin(this.scrollbar);
        super.uninstallUI(c);
    }

    @Override
    public String getStyleId() {
        return this.styleId;
    }

    @Override
    public void setStyleId(String id) {
        this.styleId = id;
        StyleManager.applySkin(this.scrollbar);
    }

    @Override
    public void updateBorder() {
        LafUtils.updateBorder(this.scrollbar, this.margin, this.painter);
    }

    public boolean isPaintButtons() {
        return this.paintButtons;
    }

    public void setPaintButtons(boolean paintButtons) {
        this.paintButtons = paintButtons;
        if (this.painter != null) {
            this.painter.setPaintButtons(paintButtons);
        }
    }

    public boolean isPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean paintTrack) {
        this.paintTrack = paintTrack;
        if (this.painter != null) {
            this.painter.setPaintTrack(paintTrack);
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public int getScrollBarWidth() {
        return this.scrollBarWidth;
    }

    public void setScrollBarWidth(int scrollBarWidth) {
        this.scrollBarWidth = scrollBarWidth;
        this.updateBorder();
    }

    public Painter getPainter() {
        return LafUtils.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        ScrollBarPainter properPainter = (ScrollBarPainter)LafUtils.getProperPainter(painter, ScrollBarPainter.class, AdaptiveScrollBarPainter.class);
        PainterSupport.uninstallPainter(this.scrollbar, this.painter);
        ScrollBarPainter oldPainter = this.painter;
        this.painter = properPainter;
        this.applyPainterSettings(properPainter);
        PainterSupport.installPainter(this.scrollbar, properPainter);
        LafUtils.firePainterChanged(this.scrollbar, oldPainter, properPainter);
    }

    private void applyPainterSettings(ScrollBarPainter painter) {
        if (painter != null) {
            painter.setPaintButtons(this.paintButtons);
            painter.setPaintTrack(this.paintTrack);
            painter.setDragged(this.isDragging);
            painter.setTrackBounds(this.getTrackBounds());
            painter.setThumbBounds(this.getThumbBounds());
        }
    }

    public Painter getDecreaseButtonPainter() {
        return LafUtils.getAdaptedPainter(this.decreaseButtonPainter);
    }

    public void setDecreaseButtonPainter(Painter painter) {
        ScrollBarButtonPainter properPainter;
        this.decreaseButtonPainter = properPainter = (ScrollBarButtonPainter)LafUtils.getProperPainter(painter, ScrollBarButtonPainter.class, AdaptiveScrollBarButtonPainter.class);
        if (this.decrButton != null) {
            if (properPainter != null) {
                properPainter.setButtonType(ScrollBarButtonType.decrease);
                properPainter.setScrollbar(this.scrollbar);
            }
            ((WebButton)this.decrButton).setPainter(properPainter);
        }
    }

    public Painter getIncreaseButtonPainter() {
        return LafUtils.getAdaptedPainter(this.increaseButtonPainter);
    }

    public void setIncreaseButtonPainter(Painter painter) {
        ScrollBarButtonPainter properPainter;
        this.increaseButtonPainter = properPainter = (ScrollBarButtonPainter)LafUtils.getProperPainter(painter, ScrollBarButtonPainter.class, AdaptiveScrollBarButtonPainter.class);
        if (this.incrButton != null) {
            if (properPainter != null) {
                properPainter.setButtonType(ScrollBarButtonType.increase);
                properPainter.setScrollbar(this.scrollbar);
            }
            ((WebButton)this.incrButton).setPainter(properPainter);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.setDragged(this.isDragging);
            this.painter.setTrackBounds(this.getTrackBounds());
            this.painter.setThumbBounds(this.getThumbBounds());
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
    }

    @Override
    protected void installComponents() {
        WebButton db = new WebButton(this.decreaseButtonPainter){

            @Override
            public Dimension getPreferredSize() {
                return WebScrollBarUI.this.painter != null && WebScrollBarUI.this.paintButtons ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        db.setFocusable(false);
        db.setLeftRightSpacing(0);
        this.decrButton = db;
        this.scrollbar.add(this.decrButton);
        WebButton ib = new WebButton(this.increaseButtonPainter){

            @Override
            public Dimension getPreferredSize() {
                return WebScrollBarUI.this.painter != null && WebScrollBarUI.this.paintButtons ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        ib.setFocusable(false);
        ib.setLeftRightSpacing(0);
        this.incrButton = ib;
        this.scrollbar.add(this.incrButton);
        this.scrollbar.setEnabled(this.scrollbar.isEnabled());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps;
        boolean ver = this.scrollbar.getOrientation() == 1;
        Dimension dimension = ps = ver ? new Dimension(this.scrollBarWidth, 48) : new Dimension(48, this.scrollBarWidth);
        if (this.painter != null && this.paintButtons && this.decrButton != null && this.incrButton != null) {
            Dimension dps = this.decrButton.getPreferredSize();
            Dimension ips = this.incrButton.getPreferredSize();
            if (ver) {
                ps.width = Math.max(ps.width, Math.max(dps.width, ips.width));
            } else {
                ps.height = Math.max(ps.height, Math.max(dps.height, ips.height));
            }
        }
        Insets i = c.getInsets();
        ps.width += i.left + i.right;
        ps.height += i.top + i.bottom;
        if (this.painter != null) {
            ps = SwingUtils.max(ps, this.painter.getPreferredSize(c));
        }
        return ps;
    }
}

