/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.MenuItemChangeListener;
import com.alee.laf.menu.MenuUtils;
import com.alee.laf.menu.WebMenuItemStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.text.View;

public class WebMenuUI
extends BasicMenuUI
implements BorderMethods {
    public static final ImageIcon arrowRightIcon = new ImageIcon(WebMenuUI.class.getResource("icons/arrowRight.png"));
    public static final ImageIcon arrowLeftIcon = new ImageIcon(WebMenuUI.class.getResource("icons/arrowLeft.png"));
    protected int round = WebMenuItemStyle.round;
    protected int shadeWidth = WebMenuItemStyle.shadeWidth;
    protected Insets margin = WebMenuItemStyle.margin;
    protected int sideSpacing = WebMenuItemStyle.sideSpacing;
    protected Color disabledFg = WebMenuItemStyle.disabledFg;
    protected Color selectedTopBg = WebMenuItemStyle.selectedTopBg;
    protected Color selectedBottomBg = WebMenuItemStyle.selectedBottomBg;
    protected int arrowGap = WebMenuItemStyle.itemSidesGap;
    protected boolean alignTextToMenuIcons = WebMenuItemStyle.alignTextToMenuIcons;
    protected int iconAlignment = WebMenuItemStyle.iconAlignment;
    protected Painter painter = WebMenuItemStyle.painter;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseAdapter mouseAdapter;
    protected MenuItemChangeListener buttonModelChangeListener;
    protected boolean mouseover = false;

    public static ComponentUI createUI(JComponent c) {
        return new WebMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.menuItem);
        LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.FALSE);
        this.menuItem.setBackground(this.selectedBottomBg);
        this.menuItem.setIconTextGap(WebMenuItemStyle.iconTextGap);
        PainterSupport.installPainter(this.menuItem, this.painter);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebMenuUI.this.updateBorder();
            }
        };
        this.menuItem.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WebMenuUI.this.mouseover = true;
                WebMenuUI.this.menuItem.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebMenuUI.this.mouseover = false;
                WebMenuUI.this.menuItem.repaint();
            }
        };
        this.menuItem.addMouseListener(this.mouseAdapter);
        this.buttonModelChangeListener = MenuItemChangeListener.install(this.menuItem);
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.menuItem, this.painter);
        this.menuItem.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.menuItem.removeMouseListener(this.mouseAdapter);
        this.mouseAdapter = null;
        MenuItemChangeListener.uninstall(this.buttonModelChangeListener, this.menuItem);
        this.buttonModelChangeListener = null;
        super.uninstallUI(c);
    }

    @Override
    public void updateBorder() {
        if (this.menuItem != null) {
            if (SwingUtils.isPreserveBorders(this.menuItem)) {
                return;
            }
            boolean ltr = this.menuItem.getComponentOrientation().isLeftToRight();
            Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
            if (this.painter != null) {
                Insets pi = this.painter.getMargin(this.menuItem);
                m.top += pi.top;
                m.bottom += pi.bottom;
                m.left = m.left + (ltr ? pi.left : pi.right);
                m.right = m.right + (ltr ? pi.right : pi.left);
            } else {
                m.top += 5;
                m.left = m.left + ((ltr ? 4 : 7) + this.sideSpacing);
                m.bottom += 5;
                m.right = m.right + ((ltr ? 7 : 4) + this.sideSpacing);
            }
            this.menuItem.setBorder(LafUtils.createWebBorder(m));
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public int getSideSpacing() {
        return this.sideSpacing;
    }

    public void setSideSpacing(int sideSpacing) {
        this.sideSpacing = sideSpacing;
        this.updateBorder();
    }

    public Color getDisabledFg() {
        return this.disabledFg;
    }

    public void setDisabledFg(Color foreground) {
        this.disabledFg = foreground;
    }

    public Color getSelectedTopBg() {
        return this.selectedTopBg;
    }

    public void setSelectedTopBg(Color background) {
        this.selectedTopBg = background;
    }

    public Color getSelectedBottomBg() {
        return this.selectedBottomBg;
    }

    public void setSelectedBottomBg(Color background) {
        this.selectedBottomBg = background;
    }

    public int getArrowGap() {
        return this.arrowGap;
    }

    public void setArrowGap(int gap) {
        this.arrowGap = gap;
    }

    public boolean isAlignTextToMenuIcons() {
        return this.alignTextToMenuIcons;
    }

    public void setAlignTextToMenuIcons(boolean align) {
        this.alignTextToMenuIcons = align;
    }

    public int getIconAlignment() {
        return this.iconAlignment;
    }

    public void setIconAlignment(int alignment) {
        this.iconAlignment = alignment;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.menuItem, this.painter);
        this.painter = painter;
        PainterSupport.installPainter(this.menuItem, this.painter);
        this.updateBorder();
    }

    public Paint getNorthCornerFill() {
        return this.selectedTopBg;
    }

    public Paint getSouthCornerFill() {
        return this.selectedBottomBg;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon arrowIcon;
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        JMenu menu = (JMenu)c;
        boolean ltr = menu.getComponentOrientation().isLeftToRight();
        int w = menu.getWidth();
        int h = menu.getHeight();
        Insets bi = menu.getInsets();
        int y = bi.top;
        int ih = h - bi.top - bi.bottom;
        ButtonModel model = menu.getModel();
        boolean selected = menu.isEnabled() && (model.isArmed() || model.isSelected());
        this.paintBackground(g2d, menu, selected, ltr);
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth(menu, this.alignTextToMenuIcons);
        int gap = iconPlaceholderWidth > 0 ? menu.getIconTextGap() : 0;
        int x = ltr ? bi.left : w - bi.right - iconPlaceholderWidth;
        this.paintIcon(g2d, menu, x, y, iconPlaceholderWidth, ih, selected, ltr);
        x += ltr ? iconPlaceholderWidth + gap : -gap;
        String text = menu.getText();
        if (text != null && text.length() > 0) {
            Map hints = SwingUtils.setupTextAntialias(g2d);
            Font oldFont = GraphicsUtils.setupFont((Graphics)g, (Font)menu.getFont());
            FontMetrics fm = menu.getFontMetrics(menu.getFont());
            View html = (View)menu.getClientProperty("html");
            int tw = html != null ? (int)html.getPreferredSpan(0) : fm.stringWidth(text);
            this.paintText(g2d, menu, fm, x -= ltr ? 0 : tw, y, tw, ih, selected, ltr);
            GraphicsUtils.restoreFont((Graphics)g, (Font)oldFont);
            SwingUtils.restoreTextAntialias(g2d, hints);
        }
        if ((arrowIcon = this.getArrowIcon(menu)) != null) {
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(0.4f), (boolean)selected);
            arrowIcon.paintIcon(menu, g2d, ltr ? w - bi.right - arrowIcon.getIconWidth() : bi.left, y + ih / 2 - arrowIcon.getIconHeight() / 2);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (boolean)selected);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintBackground(Graphics2D g2d, JMenu menu, boolean selected, boolean ltr) {
        if (this.painter != null) {
            this.painter.paint(g2d, SwingUtils.size(menu), menu);
        } else if (menu.getParent() instanceof JPopupMenu) {
            if (selected) {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectedTopBg, 0.0f, menu.getHeight(), this.selectedBottomBg));
                g2d.fillRect(0, 0, menu.getWidth(), menu.getHeight());
            }
        } else if (menu.isEnabled() && (selected || this.mouseover)) {
            LafUtils.drawWebStyle(g2d, (JComponent)menu, StyleConstants.shadeColor, this.shadeWidth, this.round, menu.isEnabled(), !selected && this.mouseover, selected ? StyleConstants.averageBorderColor : StyleConstants.borderColor);
        }
    }

    protected void paintIcon(Graphics2D g2d, JMenu menu, int x, int y, int w, int h, boolean selected, boolean ltr) {
        Icon icon;
        Icon icon2 = icon = menu.isEnabled() ? menu.getIcon() : menu.getDisabledIcon();
        if (icon != null) {
            boolean center;
            boolean left = ltr ? this.iconAlignment == 2 || this.iconAlignment == 10 : this.iconAlignment == 4 || this.iconAlignment == 11;
            boolean bl = center = this.iconAlignment == 0;
            int iconX = left ? x : (center ? x + w / 2 - icon.getIconWidth() / 2 : x + w - icon.getIconWidth());
            icon.paintIcon(menu, g2d, iconX, y + h / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintText(Graphics2D g2d, JMenu menu, FontMetrics fm, int x, int y, int w, int h, boolean selected, boolean ltr) {
        g2d.setPaint(menu.isEnabled() ? menu.getForeground() : this.disabledFg);
        View html = (View)menu.getClientProperty("html");
        if (html != null) {
            html.paint(g2d, new Rectangle(x, y, w, h));
        } else {
            int mnem = WebLookAndFeel.isMnemonicHidden() ? -1 : menu.getDisplayedMnemonicIndex();
            SwingUtils.drawStringUnderlineCharAt(g2d, menu.getText(), mnem, x, y + h / 2 + LafUtils.getTextCenterShearY(fm));
        }
    }

    protected Icon getArrowIcon(JMenu menu) {
        if (menu.getParent() instanceof JPopupMenu) {
            boolean ltr = menu.getComponentOrientation().isLeftToRight();
            if (menu.isEnabled()) {
                return ltr ? arrowRightIcon : arrowLeftIcon;
            }
            return ltr ? ImageUtils.getDisabledCopy((String)"Menu.arrowRightIcon", (ImageIcon)arrowRightIcon) : ImageUtils.getDisabledCopy((String)"Menu.arrowLeftIcon", (ImageIcon)arrowLeftIcon);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int textHeight;
        int textWidth;
        JMenu menu = (JMenu)c;
        Insets bi = menu.getInsets();
        FontMetrics fm = menu.getFontMetrics(menu.getFont());
        FontMetrics afm = menu.getFontMetrics(this.acceleratorFont);
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth(menu, this.alignTextToMenuIcons);
        View html = (View)menu.getClientProperty("html");
        if (html != null) {
            textWidth = (int)html.getPreferredSpan(0);
            textHeight = (int)html.getPreferredSpan(1);
        } else {
            String text = menu.getText();
            textWidth = text != null && text.length() > 0 ? fm.stringWidth(text) : 0;
            textHeight = fm.getHeight();
        }
        int gap = textWidth > 0 && iconPlaceholderWidth > 0 ? menu.getIconTextGap() : 0;
        Icon subMenuArrowIcon = this.getArrowIcon(menu);
        int arrowWidth = subMenuArrowIcon != null ? this.arrowGap + subMenuArrowIcon.getIconWidth() : 0;
        int iconHeight = menu.getIcon() != null ? menu.getIcon().getIconHeight() : 0;
        int contentHeight = MathUtils.max((int[])new int[]{iconHeight, textHeight, afm.getHeight()});
        return new Dimension(bi.left + iconPlaceholderWidth + gap + textWidth + arrowWidth + bi.right, bi.top + contentHeight + bi.bottom);
    }
}

