/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.MenuItemChangeListener;
import com.alee.laf.menu.MenuUtils;
import com.alee.laf.menu.WebMenuItemStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;

public class WebMenuItemUI
extends BasicMenuItemUI
implements BorderMethods {
    protected Insets margin = WebMenuItemStyle.margin;
    protected int sideSpacing = WebMenuItemStyle.sideSpacing;
    protected Color disabledFg = WebMenuItemStyle.disabledFg;
    protected Color selectedTopBg = WebMenuItemStyle.selectedTopBg;
    protected Color selectedBottomBg = WebMenuItemStyle.selectedBottomBg;
    protected Color acceleratorBg = WebMenuItemStyle.acceleratorBg;
    protected Color acceleratorFg = WebMenuItemStyle.acceleratorFg;
    protected Color acceleratorDisabledFg = WebMenuItemStyle.acceleratorDisabledFg;
    protected int acceleratorGap = WebMenuItemStyle.itemSidesGap;
    protected boolean alignTextToMenuIcons = WebMenuItemStyle.alignTextToMenuIcons;
    protected int iconAlignment = WebMenuItemStyle.iconAlignment;
    protected Painter painter = WebMenuItemStyle.painter;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuItemChangeListener buttonModelChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.menuItem);
        LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.FALSE);
        this.menuItem.setIconTextGap(WebMenuItemStyle.iconTextGap);
        PainterSupport.installPainter(this.menuItem, this.painter);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebMenuItemUI.this.updateBorder();
            }
        };
        this.menuItem.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.buttonModelChangeListener = MenuItemChangeListener.install(this.menuItem);
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.menuItem, this.painter);
        this.menuItem.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.propertyChangeListener = null;
        MenuItemChangeListener.uninstall(this.buttonModelChangeListener, this.menuItem);
        this.buttonModelChangeListener = null;
        super.uninstallUI(c);
    }

    @Override
    public void updateBorder() {
        if (this.menuItem != null) {
            if (SwingUtils.isPreserveBorders(this.menuItem)) {
                return;
            }
            boolean ltr = this.menuItem.getComponentOrientation().isLeftToRight();
            Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
            if (this.painter != null) {
                Insets pi = this.painter.getMargin(this.menuItem);
                m.top += pi.top;
                m.bottom += pi.bottom;
                m.left = m.left + (ltr ? pi.left : pi.right);
                m.right = m.right + (ltr ? pi.right : pi.left);
            } else {
                m.top += 5;
                m.left = m.left + ((ltr ? 4 : 7) + this.sideSpacing);
                m.bottom += 5;
                m.right = m.right + ((ltr ? 7 : 4) + this.sideSpacing);
            }
            this.menuItem.setBorder(LafUtils.createWebBorder(m));
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public int getSideSpacing() {
        return this.sideSpacing;
    }

    public void setSideSpacing(int sideSpacing) {
        this.sideSpacing = sideSpacing;
        this.updateBorder();
    }

    public Color getDisabledFg() {
        return this.disabledFg;
    }

    public void setDisabledFg(Color foreground) {
        this.disabledFg = foreground;
    }

    public Color getSelectedTopBg() {
        return this.selectedTopBg;
    }

    public void setSelectedTopBg(Color background) {
        this.selectedTopBg = background;
    }

    public Color getSelectedBottomBg() {
        return this.selectedBottomBg;
    }

    public void setSelectedBottomBg(Color background) {
        this.selectedBottomBg = background;
    }

    public Color getAcceleratorBg() {
        return this.acceleratorBg;
    }

    public void setAcceleratorBg(Color background) {
        this.acceleratorBg = background;
    }

    public Color getAcceleratorFg() {
        return this.acceleratorFg;
    }

    public void setAcceleratorFg(Color foreground) {
        this.acceleratorFg = foreground;
    }

    public Color getAcceleratorDisabledFg() {
        return this.acceleratorDisabledFg;
    }

    public void setAcceleratorDisabledFg(Color foreground) {
        this.acceleratorDisabledFg = foreground;
    }

    public int getAcceleratorGap() {
        return this.acceleratorGap;
    }

    public void setAcceleratorGap(int gap) {
        this.acceleratorGap = gap;
    }

    public boolean isAlignTextToMenuIcons() {
        return this.alignTextToMenuIcons;
    }

    public void setAlignTextToMenuIcons(boolean align) {
        this.alignTextToMenuIcons = align;
    }

    public int getIconAlignment() {
        return this.iconAlignment;
    }

    public void setIconAlignment(int alignment) {
        this.iconAlignment = alignment;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.menuItem, this.painter);
        this.painter = painter;
        PainterSupport.installPainter(this.menuItem, this.painter);
        this.updateBorder();
    }

    public Paint getNorthCornerFill() {
        return this.selectedTopBg;
    }

    public Paint getSouthCornerFill() {
        return this.selectedBottomBg;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean hasAccelerator;
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        JMenuItem menuItem = (JMenuItem)c;
        boolean ltr = menuItem.getComponentOrientation().isLeftToRight();
        int w = menuItem.getWidth();
        int h = menuItem.getHeight();
        Insets bi = menuItem.getInsets();
        int y = bi.top;
        int ih = h - bi.top - bi.bottom;
        ButtonModel model = menuItem.getModel();
        boolean selected = menuItem.isEnabled() && model.isArmed();
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth(menuItem, this.alignTextToMenuIcons);
        int gap = iconPlaceholderWidth > 0 ? menuItem.getIconTextGap() : 0;
        int x = ltr ? bi.left : w - bi.right - iconPlaceholderWidth;
        this.paintBackground(g2d, menuItem, x, y, iconPlaceholderWidth, ih, selected, ltr);
        this.paintIcon(g2d, menuItem, x, y, iconPlaceholderWidth, ih, selected, ltr);
        x += ltr ? iconPlaceholderWidth + gap : -gap;
        String text = menuItem.getText();
        boolean hasText = text != null && text.length() > 0;
        String accText = MenuUtils.getAcceleratorText(menuItem);
        boolean bl = hasAccelerator = accText != null;
        if (hasText || hasAccelerator) {
            Map hints = SwingUtils.setupTextAntialias(g2d);
            Font oldFont = GraphicsUtils.setupFont((Graphics)g, (Font)menuItem.getFont());
            if (hasText) {
                FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
                View html = (View)menuItem.getClientProperty("html");
                int tw = html != null ? (int)html.getPreferredSpan(0) : fm.stringWidth(text);
                this.paintText(g2d, menuItem, fm, x -= ltr ? 0 : tw, y, tw, ih, selected, ltr);
            }
            if (hasAccelerator) {
                FontMetrics afm = menuItem.getFontMetrics(this.acceleratorFont);
                int aw = afm.stringWidth(accText);
                x = ltr ? w - bi.right - aw : bi.left;
                this.paintAcceleratorText(g2d, menuItem, accText, afm, x, y, aw, ih, selected, ltr);
            }
            GraphicsUtils.restoreFont((Graphics)g, (Font)oldFont);
            SwingUtils.restoreTextAntialias(g2d, hints);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintBackground(Graphics2D g2d, JMenuItem menuItem, int x, int y, int w, int h, boolean selected, boolean ltr) {
        if (this.painter != null) {
            this.painter.paint(g2d, SwingUtils.size(menuItem), menuItem);
        } else if (selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectedTopBg, 0.0f, menuItem.getHeight(), this.selectedBottomBg));
            g2d.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        }
    }

    protected void paintIcon(Graphics2D g2d, JMenuItem menuItem, int x, int y, int w, int h, boolean selected, boolean ltr) {
        Icon icon;
        boolean enabled = menuItem.isEnabled();
        Icon icon2 = menuItem.isSelected() && menuItem.getSelectedIcon() != null ? (enabled ? menuItem.getSelectedIcon() : menuItem.getDisabledSelectedIcon()) : (icon = enabled ? menuItem.getIcon() : menuItem.getDisabledIcon());
        if (icon != null) {
            boolean center;
            boolean left = ltr ? this.iconAlignment == 2 || this.iconAlignment == 10 : this.iconAlignment == 4 || this.iconAlignment == 11;
            boolean bl = center = this.iconAlignment == 0;
            int iconX = left ? x : (center ? x + w / 2 - icon.getIconWidth() / 2 : x + w - icon.getIconWidth());
            icon.paintIcon(menuItem, g2d, iconX, y + h / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintText(Graphics2D g2d, JMenuItem menuItem, FontMetrics fm, int x, int y, int w, int h, boolean selected, boolean ltr) {
        g2d.setPaint(menuItem.isEnabled() ? menuItem.getForeground() : this.disabledFg);
        View html = (View)menuItem.getClientProperty("html");
        if (html != null) {
            html.paint(g2d, new Rectangle(x, y, w, h));
        } else {
            int mnem = WebLookAndFeel.isMnemonicHidden() ? -1 : menuItem.getDisplayedMnemonicIndex();
            SwingUtils.drawStringUnderlineCharAt(g2d, menuItem.getText(), mnem, x, y + h / 2 + LafUtils.getTextCenterShearY(fm));
        }
    }

    protected void paintAcceleratorText(Graphics2D g2d, JMenuItem menuItem, String accText, FontMetrics fm, int x, int y, int w, int h, boolean selected, boolean ltr) {
        if (selected && this.acceleratorBg != null) {
            int th = fm.getHeight();
            g2d.setPaint(this.acceleratorBg);
            g2d.fillRoundRect(x - 3, y + h / 2 - th / 2, w + 6, th, 4, 4);
        }
        g2d.setPaint(menuItem.isEnabled() ? this.acceleratorFg : this.acceleratorDisabledFg);
        g2d.drawString(accText, x, y + h / 2 + LafUtils.getTextCenterShearY(fm));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int textHeight;
        int textWidth;
        JMenuItem menuItem = (JMenuItem)c;
        Insets bi = menuItem.getInsets();
        FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
        FontMetrics afm = menuItem.getFontMetrics(this.acceleratorFont);
        int iconPlaceholderWidth = MenuUtils.getIconPlaceholderWidth(menuItem, this.alignTextToMenuIcons);
        View html = (View)menuItem.getClientProperty("html");
        if (html != null) {
            textWidth = (int)html.getPreferredSpan(0);
            textHeight = (int)html.getPreferredSpan(1);
        } else {
            String text = menuItem.getText();
            textWidth = text != null && text.length() > 0 ? fm.stringWidth(text) : 0;
            textHeight = fm.getHeight();
        }
        int gap = textWidth > 0 && iconPlaceholderWidth > 0 ? menuItem.getIconTextGap() : 0;
        String accelerationText = MenuUtils.getAcceleratorText(menuItem);
        int accWidth = accelerationText != null ? this.acceleratorGap + afm.stringWidth(accelerationText) : 0;
        int iconHeight = menuItem.getIcon() != null ? menuItem.getIcon().getIconHeight() : 0;
        int contentHeight = MathUtils.max((int[])new int[]{iconHeight, textHeight, afm.getHeight()});
        return new Dimension(bi.left + iconPlaceholderWidth + gap + textWidth + accWidth + bi.right, bi.top + contentHeight + bi.bottom);
    }
}

