/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.extended.painter.Painter;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.managers.style.skin.web.PopupStyle;
import com.alee.managers.style.skin.web.WebPopupMenuPainter;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MenuItemChangeListener
implements ChangeListener {
    protected JMenuItem menuItem;

    public static MenuItemChangeListener install(final JMenuItem menuItem) {
        final MenuItemChangeListener listener = new MenuItemChangeListener(menuItem);
        menuItem.getModel().addChangeListener(listener);
        menuItem.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((ButtonModel)evt.getOldValue()).removeChangeListener(listener);
                menuItem.getModel().addChangeListener(listener);
            }
        });
        return listener;
    }

    public static void uninstall(MenuItemChangeListener listener, JMenuItem menuItem) {
        menuItem.getModel().removeChangeListener(listener);
    }

    public MenuItemChangeListener(JMenuItem menuItem) {
        this.menuItem = menuItem;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        WebPopupMenuPainter webPainter;
        WebPopupMenuUI ui;
        Painter painter;
        JPopupMenu popupMenu;
        Container parent = this.menuItem.getParent();
        if (parent instanceof JPopupMenu && (popupMenu = (JPopupMenu)parent).getUI() instanceof WebPopupMenuUI && (painter = (ui = (WebPopupMenuUI)popupMenu.getUI()).getPainter()) instanceof WebPopupMenuPainter && (webPainter = (WebPopupMenuPainter)painter).getPopupStyle() == PopupStyle.dropdown) {
            int zOrder = popupMenu.getComponentZOrder(this.menuItem);
            if (webPainter.getCornerSide() == 1 && zOrder == 0) {
                popupMenu.repaint(0, 0, popupMenu.getWidth(), this.menuItem.getBounds().y);
            } else if (webPainter.getCornerSide() == 5 && zOrder == popupMenu.getComponentCount() - 1) {
                Rectangle itemBounds = this.menuItem.getBounds();
                int y = itemBounds.y + itemBounds.height;
                popupMenu.repaint(0, y, popupMenu.getWidth(), popupMenu.getHeight() - y);
            }
        }
    }
}

