/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.filechooser.FileApproveText;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.laf.filechooser.WebFileChooserStyle;
import com.alee.laf.filechooser.WebFileChooserUI;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.swing.Customizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class WebFileChooser
extends JFileChooser
implements LanguageMethods,
LanguageContainerMethods {
    protected List<? extends Image> customIcons = null;

    public WebFileChooser() {
        super(WebFileChooserStyle.defaultDirectory);
    }

    public WebFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public WebFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public WebFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public WebFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public WebFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        if (this.customIcons != null) {
            dialog.setIconImages(this.customIcons);
        }
        return dialog;
    }

    public Image getDialogIcon() {
        return this.customIcons != null && this.customIcons.size() > 0 ? this.customIcons.get(0) : null;
    }

    public List<? extends Image> getDialogIcons() {
        return this.customIcons;
    }

    public void setDialogIcon(ImageIcon icon) {
        this.setDialogImage(icon.getImage());
    }

    public void setDialogImage(Image icon) {
        this.setDialogImages(Arrays.asList(icon));
    }

    public void setDialogIcons(List<? extends ImageIcon> customIcons) {
        this.setDialogImages(ImageUtils.toImagesList(customIcons));
    }

    public void setDialogImages(List<? extends Image> customIcons) {
        this.customIcons = customIcons;
        Window window = SwingUtils.getWindowAncestor(this);
        if (window != null && window instanceof JDialog) {
            window.setIconImages(customIcons);
        }
    }

    public void setDialogTitleKey(String dialogTitle) {
        this.setLanguage(dialogTitle, new Object[0]);
    }

    public void setCurrentDirectory(String directoryPath) {
        this.setCurrentDirectory(new File(directoryPath));
    }

    public void setSelectedFile(String filePath) {
        this.setSelectedFile(new File(filePath));
    }

    public WebFileChooserPanel getFileChooserPanel() {
        return this.getWebUI().getFileChooserPanel();
    }

    public List<AbstractFileFilter> getAvailableFilters() {
        return this.getWebUI().getAvailableFilters();
    }

    public AbstractFileFilter getActiveFileFilter() {
        return this.getWebUI().getActiveFileFilter();
    }

    public boolean isGenerateThumbnails() {
        return this.getWebUI().isGenerateThumbnails();
    }

    public void setGenerateThumbnails(boolean generate) {
        this.getWebUI().setGenerateThumbnails(generate);
    }

    public void setApproveButtonText(FileApproveText approveText) {
        this.getWebUI().setApproveButtonText(approveText);
    }

    public void setApproveButtonLanguage(String key) {
        this.getWebUI().setApproveButtonLanguage(key);
    }

    public WebFileChooserUI getWebUI() {
        return (WebFileChooserUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebFileChooserUI)) {
            try {
                this.setUI((WebFileChooserUI)ReflectUtils.createInstance((String)WebLookAndFeel.fileChooserUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebFileChooserUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((Component)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((Component)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((Component)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((Component)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((Component)this);
    }

    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer((Container)this, (String)key);
    }

    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer((Container)this);
    }

    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey((Container)this);
    }

    public static File showOpenDialog() {
        return WebFileChooser.showOpenDialog(null, null, null);
    }

    public static File showOpenDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(null, null, customizer);
    }

    public static File showOpenDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(parent, null, customizer);
    }

    public static File showOpenDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(null, currentDirectory, customizer);
    }

    public static File showOpenDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showOpenDialog(parent, currentDirectory, null);
    }

    public static File showOpenDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(false);
        if (customizer != null) {
            customizer.customize((Object)fileChooser);
        }
        if (fileChooser.showOpenDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static List<File> showMultiOpenDialog() {
        return WebFileChooser.showMultiOpenDialog(null, null, null);
    }

    public static List<File> showMultiOpenDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(null, null, customizer);
    }

    public static List<File> showMultiOpenDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(parent, null, customizer);
    }

    public static List<File> showMultiOpenDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(null, currentDirectory, customizer);
    }

    public static List<File> showMultiOpenDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showMultiOpenDialog(parent, currentDirectory, null);
    }

    public static List<File> showMultiOpenDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        if (customizer != null) {
            customizer.customize((Object)fileChooser);
        }
        if (fileChooser.showOpenDialog(parent) == 0) {
            return CollectionUtils.toList((Object[])fileChooser.getSelectedFiles());
        }
        return null;
    }

    public static File showSaveDialog() {
        return WebFileChooser.showSaveDialog(null, null, null);
    }

    public static File showSaveDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(null, null, customizer);
    }

    public static File showSaveDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(parent, null, customizer);
    }

    public static File showSaveDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(null, currentDirectory, customizer);
    }

    public static File showSaveDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showSaveDialog(parent, currentDirectory, null);
    }

    public static File showSaveDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        if (customizer != null) {
            customizer.customize((Object)fileChooser);
        }
        if (fileChooser.showSaveDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

