/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.WebComboBoxCellRenderer;
import com.alee.laf.combobox.WebComboBoxStyle;
import com.alee.laf.list.WebListUI;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import com.alee.utils.swing.RendererListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WebComboBoxUI
extends BasicComboBoxUI
implements ShapeProvider,
BorderMethods {
    protected static ListCellRenderer DEFAULT_RENDERER;
    private ImageIcon expandIcon = WebComboBoxStyle.expandIcon;
    private ImageIcon collapseIcon = WebComboBoxStyle.collapseIcon;
    private int iconSpacing = WebComboBoxStyle.iconSpacing;
    private boolean drawBorder = WebComboBoxStyle.drawBorder;
    private int round = WebComboBoxStyle.round;
    private int shadeWidth = WebComboBoxStyle.shadeWidth;
    private boolean drawFocus = WebComboBoxStyle.drawFocus;
    private boolean mouseWheelScrollingEnabled = WebComboBoxStyle.mouseWheelScrollingEnabled;
    private boolean useFirstValueAsPrototype = false;
    private WebButton arrow = null;
    private MouseWheelListener mouseWheelListener = null;
    private RendererListener rendererListener = null;
    private PropertyChangeListener rendererChangeListener = null;
    private PropertyChangeListener enabledStateListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        final JComboBox comboBox = (JComboBox)c;
        SwingUtils.setOrientation(comboBox);
        comboBox.setFocusable(true);
        LookAndFeel.installProperty(comboBox, "opaque", Boolean.FALSE);
        this.updateBorder();
        if (!(comboBox.getRenderer() instanceof WebComboBoxCellRenderer)) {
            comboBox.setRenderer(new WebComboBoxCellRenderer());
        }
        this.mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int index;
                int newIndex;
                if (WebComboBoxUI.this.mouseWheelScrollingEnabled && comboBox.isEnabled() && SwingUtils.hasFocusOwner(comboBox) && (newIndex = Math.min(Math.max(0, (index = comboBox.getSelectedIndex()) + e.getWheelRotation()), comboBox.getModel().getSize() - 1)) != index) {
                    comboBox.setSelectedIndex(newIndex);
                }
            }
        };
        comboBox.addMouseWheelListener(this.mouseWheelListener);
        this.rendererListener = new RendererListener(){

            @Override
            public void repaint() {
                comboBox.repaint();
                WebComboBoxUI.this.listBox.repaint();
            }

            @Override
            public void revalidate() {
                WebComboBoxUI.this.isMinimumSizeDirty = true;
                comboBox.revalidate();
                WebComboBoxUI.this.listBox.revalidate();
            }
        };
        this.installRendererListener(comboBox.getRenderer());
        this.rendererChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                WebComboBoxUI.this.uninstallRendererListener(e.getOldValue());
                WebComboBoxUI.this.installRendererListener(e.getNewValue());
            }
        };
        comboBox.addPropertyChangeListener("renderer", this.rendererChangeListener);
        this.enabledStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebComboBoxUI.this.listBox.setEnabled(comboBox.isEnabled());
            }
        };
        comboBox.addPropertyChangeListener("enabled", this.enabledStateListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.comboBox.removePropertyChangeListener("enabled", this.enabledStateListener);
        this.comboBox.removePropertyChangeListener("renderer", this.rendererChangeListener);
        this.uninstallRendererListener(this.comboBox.getRenderer());
        this.rendererListener = null;
        c.removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        this.arrow = null;
        super.uninstallUI(c);
    }

    @Override
    public void updateBorder() {
        if (SwingUtils.isPreserveBorders(this.comboBox)) {
            return;
        }
        Insets m = new Insets(0, 0, 0, 0);
        if (this.drawBorder) {
            m.top += this.shadeWidth + 1;
            m.left += this.shadeWidth + 1;
            m.bottom += this.shadeWidth + 1;
            m.right += this.shadeWidth + 1;
        }
        this.comboBox.setBorder(LafUtils.createWebBorder(m));
    }

    protected void installRendererListener(Object renderer) {
        if (renderer != null && renderer instanceof WebComboBoxCellRenderer) {
            ((WebComboBoxCellRenderer)renderer).addRendererListener(this.rendererListener);
        }
    }

    protected void uninstallRendererListener(Object renderer) {
        if (renderer != null && renderer instanceof WebComboBoxCellRenderer) {
            ((WebComboBoxCellRenderer)renderer).removeRendererListener(this.rendererListener);
        }
    }

    @Override
    protected void installComponents() {
        this.comboBox.setLayout(this.createLayoutManager());
        this.arrowButton = this.createArrowButton();
        this.comboBox.add((Component)this.arrowButton, "1,0");
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add((Component)this.currentValuePane, "0,0");
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor editor = super.createEditor();
        Component e = editor.getEditorComponent();
        e.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                WebComboBoxUI.this.comboBox.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebComboBoxUI.this.comboBox.repaint();
            }
        });
        if (e instanceof JComponent) {
            ((JComponent)e).setOpaque(false);
        }
        if (e instanceof JTextField) {
            JTextField textField = (JTextField)e;
            WebTextFieldUI textFieldUI = new WebTextFieldUI();
            textFieldUI.setDrawBorder(false);
            textField.setUI(textFieldUI);
            textField.setMargin(new Insets(0, 1, 0, 1));
        }
        return editor;
    }

    @Override
    protected JButton createArrowButton() {
        this.arrow = new WebButton();
        this.arrow.setUndecorated(true);
        this.arrow.setDrawFocus(false);
        this.arrow.setMoveIconOnPress(false);
        this.arrow.setName("ComboBox.arrowButton");
        this.arrow.setIcon(this.expandIcon);
        this.arrow.setLeftRightSpacing(this.iconSpacing);
        return this.arrow;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        if (this.arrowButton != null) {
            this.arrowButton.setFocusable(false);
        }
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            @Override
            protected JScrollPane createScroller() {
                ScrollPaneUI scrollPaneUI;
                JScrollPane scroll = super.createScroller();
                if (WebLookAndFeel.isInstalled()) {
                    scroll.setOpaque(false);
                    scroll.getViewport().setOpaque(false);
                }
                if ((scrollPaneUI = scroll.getUI()) instanceof WebScrollPaneUI) {
                    WebScrollPaneUI webScrollPaneUI = (WebScrollPaneUI)scrollPaneUI;
                    webScrollPaneUI.setDrawBorder(false);
                    ScrollBarUI scrollBarUI = scroll.getVerticalScrollBar().getUI();
                    if (scrollBarUI instanceof WebScrollBarUI) {
                        WebScrollBarUI webScrollBarUI = (WebScrollBarUI)scrollBarUI;
                        webScrollBarUI.setMargin(WebComboBoxStyle.scrollBarMargin);
                        webScrollBarUI.setPaintButtons(WebComboBoxStyle.scrollBarButtonsVisible);
                        webScrollBarUI.setPaintTrack(WebComboBoxStyle.scrollBarTrackVisible);
                    }
                }
                LafUtils.setScrollBarStyleId(scroll, "combo-box");
                return scroll;
            }

            protected JList createList() {
                JList<Object> list = super.createList();
                ListUI listUI = list.getUI();
                if (listUI instanceof WebListUI) {
                    WebListUI webListUI = (WebListUI)listUI;
                    webListUI.setHighlightRolloverCell(false);
                    webListUI.setDecorateSelection(false);
                }
                return list;
            }

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        WebComboBoxUI.this.arrow.setIcon(WebComboBoxUI.this.collapseIcon);
                        comboBox.repaint();
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        WebComboBoxUI.this.arrow.setIcon(WebComboBoxUI.this.expandIcon);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                        WebComboBoxUI.this.arrow.setIcon(WebComboBoxUI.this.expandIcon);
                    }
                });
            }

            @Override
            public void show() {
                this.comboBox.firePopupMenuWillBecomeVisible();
                this.setListSelection(this.comboBox.getSelectedIndex());
                Point location = this.getPopupLocation();
                this.show(this.comboBox, location.x, location.y);
            }

            private void setListSelection(int selectedIndex) {
                if (selectedIndex == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectedIndex(selectedIndex);
                    this.list.ensureIndexIsVisible(selectedIndex);
                }
            }

            private Point getPopupLocation() {
                Dimension comboSize = this.comboBox.getSize();
                comboSize.setSize(comboSize.width - 2, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, comboSize.width, comboSize.height);
                Dimension scrollSize = popupBounds.getSize();
                this.scroller.setMaximumSize(scrollSize);
                this.scroller.setPreferredSize(scrollSize);
                this.scroller.setMinimumSize(scrollSize);
                this.list.revalidate();
                return popupBounds.getLocation();
            }
        };
    }

    public boolean isComboboxCellEditor() {
        if (this.comboBox != null) {
            Object cellEditor = this.comboBox.getClientProperty("JComboBox.isTableCellEditor");
            return cellEditor != null && (Boolean)cellEditor != false;
        }
        return false;
    }

    @Override
    public Shape provideShape() {
        if (this.drawBorder) {
            return LafUtils.getWebBorderShape(this.comboBox, this.shadeWidth, this.round);
        }
        return SwingUtils.size(this.comboBox);
    }

    public void setEditorColumns(int columns) {
        if (this.editor instanceof JTextField) {
            ((JTextField)this.editor).setColumns(columns);
        }
    }

    public boolean isUseFirstValueAsPrototype() {
        return this.useFirstValueAsPrototype;
    }

    public void setUseFirstValueAsPrototype(boolean use) {
        this.useFirstValueAsPrototype = use;
        this.isMinimumSizeDirty = true;
        this.comboBox.revalidate();
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(ImageIcon expandIcon) {
        this.expandIcon = expandIcon;
        if (this.arrow != null && !this.isPopupVisible(this.comboBox)) {
            this.arrow.setIcon(expandIcon);
        }
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(ImageIcon collapseIcon) {
        this.collapseIcon = collapseIcon;
        if (this.arrow != null && this.isPopupVisible(this.comboBox)) {
            this.arrow.setIcon(collapseIcon);
        }
    }

    public int getIconSpacing() {
        return this.iconSpacing;
    }

    public void setIconSpacing(int iconSpacing) {
        this.iconSpacing = iconSpacing;
        if (this.arrow != null) {
            this.arrow.setLeftRightSpacing(iconSpacing);
        }
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public boolean isMouseWheelScrollingEnabled() {
        return this.mouseWheelScrollingEnabled;
    }

    public void setMouseWheelScrollingEnabled(boolean enabled) {
        this.mouseWheelScrollingEnabled = enabled;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        Rectangle r = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g, r, this.hasFocus);
        if (!this.comboBox.isEditable()) {
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.drawBorder) {
            this.comboBox.setBackground(StyleConstants.selectedBgColor);
            LafUtils.drawWebStyle(g2d, this.comboBox, this.drawFocus && SwingUtils.hasFocusOwner(this.comboBox) ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, true, !this.isPopupVisible(this.comboBox));
        } else {
            boolean pressed = this.isPopupVisible(this.comboBox);
            Rectangle cb = SwingUtils.size(this.comboBox);
            g2d.setPaint(new GradientPaint(0.0f, this.shadeWidth, pressed ? StyleConstants.topSelectedBgColor : StyleConstants.topBgColor, 0.0f, this.comboBox.getHeight() - this.shadeWidth, pressed ? StyleConstants.bottomSelectedBgColor : StyleConstants.bottomBgColor));
            g2d.fillRect(cb.x, cb.y, cb.width, cb.height);
        }
        if (this.comboBox.isEditable()) {
            boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
            Insets insets = this.comboBox.getInsets();
            int lx = ltr ? this.comboBox.getWidth() - insets.right - this.arrow.getWidth() - 1 : insets.left + this.arrow.getWidth();
            g2d.setPaint(this.comboBox.isEnabled() ? StyleConstants.borderColor : StyleConstants.disabledBorderColor);
            g2d.drawLine(lx, insets.top + 1, lx, this.comboBox.getHeight() - insets.bottom - 2);
        }
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new WebComboBoxLayout();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        int buttonWidth = this.arrowButton.getPreferredSize().width;
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right + buttonWidth;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    @Override
    protected Dimension getDisplaySize() {
        Object prototypeValue;
        Dimension result = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        if ((prototypeValue = this.comboBox.getPrototypeDisplayValue()) != null) {
            result = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel model = this.comboBox.getModel();
            int modelSize = model.getSize();
            if (modelSize > 0) {
                if (this.useFirstValueAsPrototype) {
                    Object value = model.getElementAt(0);
                    Component c = renderer.getListCellRendererComponent(this.listBox, value, -1, false, false);
                    Dimension d = this.getSizeForComponent(c);
                    result.width = Math.max(result.width, d.width);
                    result.height = Math.max(result.height, d.height);
                } else {
                    for (int i = 0; i < modelSize; ++i) {
                        Object value = model.getElementAt(i);
                        Component c = renderer.getListCellRendererComponent(this.listBox, value, -1, false, false);
                        Dimension d = this.getSizeForComponent(c);
                        result.width = Math.max(result.width, d.width);
                        result.height = Math.max(result.height, d.height);
                    }
                }
            } else {
                result = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    result.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            Dimension d = this.editor.getPreferredSize();
            result.width = Math.max(result.width, d.width);
            result.height = Math.max(result.height, d.height);
        }
        return result;
    }

    @Override
    protected Dimension getDefaultSize() {
        return this.getSizeForComponent(WebComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false));
    }

    protected static ListCellRenderer getDefaultListCellRenderer() {
        if (DEFAULT_RENDERER == null) {
            DEFAULT_RENDERER = new WebComboBoxCellRenderer();
        }
        return DEFAULT_RENDERER;
    }

    @Override
    protected Dimension getSizeForComponent(Component c) {
        this.currentValuePane.add(c);
        c.setFont(this.comboBox.getFont());
        Dimension d = c.getPreferredSize();
        this.currentValuePane.remove(c);
        return d;
    }

    protected class WebComboBoxLayout
    extends AbstractLayoutManager {
        protected WebComboBoxLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            if (WebComboBoxUI.this.arrowButton != null) {
                Insets insets = WebComboBoxUI.this.getInsets();
                int buttonHeight = height - (insets.top + insets.bottom);
                int buttonWidth = ((WebComboBoxUI)WebComboBoxUI.this).arrowButton.getPreferredSize().width;
                if (cb.getComponentOrientation().isLeftToRight()) {
                    WebComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    WebComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (WebComboBoxUI.this.editor != null) {
                WebComboBoxUI.this.editor.setBounds(WebComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

