/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.checkbox;

import com.alee.extended.checkbox.CheckState;
import com.alee.laf.checkbox.CheckIcon;
import com.alee.laf.checkbox.WebCheckBoxUI;
import com.alee.utils.ImageUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class SimpleCheckIcon
extends CheckIcon {
    public static List<ImageIcon> CHECK_STATES = new ArrayList<ImageIcon>();
    public static List<ImageIcon> DISABLED_CHECK_STATES = new ArrayList<ImageIcon>();
    protected int step = -1;

    @Override
    public void doStep() {
        this.step = this.nextState == CheckState.checked ? this.step + 1 : this.step - 1;
    }

    @Override
    public void resetStep() {
        this.step = this.state == CheckState.checked ? 3 : -1;
    }

    @Override
    public boolean isTransitionCompleted() {
        return this.nextState == CheckState.unchecked && this.step == -1 || this.nextState == CheckState.checked && this.step == 3;
    }

    @Override
    public void finishTransition() {
        this.state = this.nextState;
        this.nextState = null;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics2D g2d, int x, int y, int w, int h) {
        if (this.step > -1) {
            ImageIcon icon = this.enabled ? CHECK_STATES.get(this.step) : DISABLED_CHECK_STATES.get(this.step);
            g2d.drawImage(icon.getImage(), x + w / 2 - this.getIconWidth() / 2, y + h / 2 - this.getIconHeight() / 2, null);
        }
    }

    static {
        for (int i = 1; i <= 4; ++i) {
            ImageIcon icon = new ImageIcon(WebCheckBoxUI.class.getResource("icons/c" + i + ".png"));
            CHECK_STATES.add(icon);
            DISABLED_CHECK_STATES.add(ImageUtils.getDisabledCopy((String)("WebCheckBox.disabled.check." + i), (ImageIcon)icon));
        }
    }
}

