/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.global.StyleConstants;
import com.alee.laf.rootpane.WebDialog;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;

public class WebFadeDialog
extends WebDialog
implements ActionListener,
WindowFocusListener,
WindowListener {
    private float maximumOpacity = 0.9f;
    private float minimumOpacity = 0.3f;
    private int minimumOpacityDistance = 200;
    private float opacity = 1.0f;
    private WebTimer updater = new WebTimer("WebFadeDialog.updater", StyleConstants.fastAnimationDelay, (ActionListener)this);

    public WebFadeDialog() {
        this.addWindowFocusListener(this);
        this.addWindowListener(this);
    }

    public float getMaximumOpacity() {
        return this.maximumOpacity;
    }

    public void setMaximumOpacity(float maximumOpacity) {
        this.maximumOpacity = maximumOpacity;
    }

    public float getMinimumOpacity() {
        return this.minimumOpacity;
    }

    public void setMinimumOpacity(float minimumOpacity) {
        this.minimumOpacity = minimumOpacity;
    }

    public int getMinimumOpacityDistance() {
        return this.minimumOpacityDistance;
    }

    public void setMinimumOpacityDistance(int minimumOpacityDistance) {
        this.minimumOpacityDistance = minimumOpacityDistance;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.updater.stop();
        this.opacity = this.maximumOpacity;
        this.updateOpacity();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.isShowing()) {
            this.updater.start();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.updater.stop();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        float newOpacity;
        if (!this.isActive()) {
            Point mp = MouseInfo.getPointerInfo().getLocation();
            Rectangle bounds = this.getBounds();
            if (bounds.contains(mp)) {
                newOpacity = this.maximumOpacity;
            } else {
                int distance = mp.y < bounds.y ? (mp.x < bounds.x ? this.minimumOpacityDistance - MathUtils.sqrt((double)(MathUtils.sqr((int)(bounds.y - mp.y)) + MathUtils.sqr((int)(bounds.x - mp.x)))) : (mp.x > bounds.x + bounds.width ? this.minimumOpacityDistance - MathUtils.sqrt((double)(MathUtils.sqr((int)(bounds.y - mp.y)) + MathUtils.sqr((int)(mp.x - bounds.x - bounds.width)))) : this.minimumOpacityDistance - (bounds.y - mp.y))) : (mp.y > bounds.y && mp.y < bounds.y + bounds.height ? (mp.x < bounds.x ? this.minimumOpacityDistance - (bounds.x - mp.x) : this.minimumOpacityDistance - (mp.x - bounds.x - bounds.width)) : (mp.x < bounds.x ? this.minimumOpacityDistance - MathUtils.sqrt((double)(MathUtils.sqr((int)(mp.y - bounds.y - bounds.height)) + MathUtils.sqr((int)(bounds.x - mp.x)))) : (mp.x > bounds.x + bounds.width ? this.minimumOpacityDistance - MathUtils.sqrt((double)(MathUtils.sqr((int)(mp.y - bounds.y - bounds.height)) + MathUtils.sqr((int)(mp.x - bounds.x - bounds.width)))) : this.minimumOpacityDistance - (mp.y - bounds.y - bounds.height))));
                newOpacity = this.minimumOpacity + (this.maximumOpacity - this.minimumOpacity) * ((float)Math.max(0, distance) / (float)this.minimumOpacityDistance);
            }
        } else {
            newOpacity = this.maximumOpacity;
        }
        if (newOpacity != this.opacity) {
            this.opacity = newOpacity;
            this.updateOpacity();
        }
    }

    private void updateOpacity() {
        this.setWindowOpacity(this.opacity);
    }
}

