/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.WebAsyncTreeCellRenderer;
import com.alee.laf.tree.WebTreeElement;
import com.alee.utils.FileUtils;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public class WebFileTreeCellRenderer
extends WebAsyncTreeCellRenderer {
    @Override
    public WebTreeElement getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        FileTreeNode node = (FileTreeNode)value;
        File file = node.getFile();
        if (!node.isLoading()) {
            ImageIcon icon = file != null ? FileUtils.getFileIcon((File)file, (boolean)false) : null;
            this.setIcon(node.isFailed() ? WebFileTreeCellRenderer.getFailedStateIcon(icon) : icon);
        }
        if (node.getName() != null) {
            this.setText(node.getName());
        } else if (file != null) {
            String name = FileUtils.getDisplayFileName((File)file);
            if (name != null && !name.trim().equals("")) {
                this.setText(name);
            } else {
                name = file.getName();
                if (!name.trim().equals("")) {
                    this.setText(name != null ? name : "");
                } else {
                    this.setText(FileUtils.getFileDescription((File)file, null).getDescription());
                }
            }
        }
        return this;
    }
}

