/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.checkbox.CheckState;
import com.alee.extended.tree.CheckBoxTreeCellRenderer;
import com.alee.extended.tree.CheckStateChange;
import com.alee.extended.tree.CheckStateChangeListener;
import com.alee.extended.tree.DefaultTreeCheckingModel;
import com.alee.extended.tree.TreeCheckingModel;
import com.alee.extended.tree.WebCheckBoxTreeCellRenderer;
import com.alee.extended.tree.WebCheckBoxTreeStyle;
import com.alee.laf.tree.WebTree;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.StateProvider;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebCheckBoxTree<E extends DefaultMutableTreeNode>
extends WebTree<E> {
    protected Boolean recursiveChecking = WebCheckBoxTreeStyle.recursiveChecking;
    protected Integer checkBoxRendererGap = WebCheckBoxTreeStyle.checkBoxRendererGap;
    protected Boolean checkBoxVisible = WebCheckBoxTreeStyle.checkBoxVisible;
    protected Boolean checkingEnabled = WebCheckBoxTreeStyle.checkingEnabled;
    protected Boolean checkMixedOnToggle = WebCheckBoxTreeStyle.checkMixedOnToggle;
    protected TreeCheckingModel<E> checkingModel;
    protected CheckBoxTreeCellRenderer checkBoxCellRenderer;
    protected TreeCellRenderer actualCellRenderer;
    protected StateProvider<E> enabledStateProvider;
    protected StateProvider<E> visibleStateProvider;
    protected Handler handler;
    protected List<CheckStateChangeListener<E>> checkStateChangeListeners = new ArrayList<CheckStateChangeListener<E>>(1);

    public WebCheckBoxTree() {
    }

    public WebCheckBoxTree(Object[] value) {
        super(value);
    }

    public WebCheckBoxTree(Vector<?> value) {
        super(value);
    }

    public WebCheckBoxTree(Hashtable<?, ?> value) {
        super(value);
    }

    public WebCheckBoxTree(E root) {
        super(root);
    }

    public WebCheckBoxTree(E root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public WebCheckBoxTree(TreeModel newModel) {
        super(newModel);
    }

    @Override
    protected void init() {
        this.checkingModel = this.createDefaultCheckingModel(this);
        this.handler = new Handler();
        this.addMouseListener(this.handler);
        this.addKeyListener(this.handler);
    }

    public CheckBoxTreeCellRenderer getCheckBoxCellRenderer() {
        return this.checkBoxCellRenderer;
    }

    public TreeCellRenderer getActualRenderer() {
        return this.actualCellRenderer;
    }

    @Override
    public void setCellRenderer(TreeCellRenderer renderer) {
        this.actualCellRenderer = renderer;
        if (this.checkBoxCellRenderer == null) {
            this.checkBoxCellRenderer = this.createCheckBoxTreeCellRenderer();
            this.checkBoxCellRenderer.setCheckBoxRendererGap(this.getCheckBoxRendererGap());
        }
        super.setCellRenderer(this.checkBoxCellRenderer);
    }

    public void setCheckBoxTreeCellRenderer(CheckBoxTreeCellRenderer renderer) {
        this.checkBoxCellRenderer = renderer;
        this.checkBoxCellRenderer.setCheckBoxRendererGap(this.getCheckBoxRendererGap());
        super.setCellRenderer(this.checkBoxCellRenderer);
    }

    protected WebCheckBoxTreeCellRenderer createCheckBoxTreeCellRenderer() {
        return new WebCheckBoxTreeCellRenderer(this);
    }

    public int getCheckBoxRendererGap() {
        return this.checkBoxRendererGap != null ? this.checkBoxRendererGap : WebCheckBoxTreeStyle.checkBoxRendererGap;
    }

    public void setCheckBoxRendererGap(int gap) {
        this.checkBoxRendererGap = gap;
    }

    public CheckState getCheckState(E node) {
        return this.checkingModel != null ? this.checkingModel.getCheckState(node) : CheckState.unchecked;
    }

    public boolean isUnchecked(E node) {
        return this.checkingModel != null && this.checkingModel.getCheckState(node) == CheckState.unchecked;
    }

    public boolean isChecked(E node) {
        return this.checkingModel != null && this.checkingModel.getCheckState(node) == CheckState.checked;
    }

    public boolean isMixed(E node) {
        return this.checkingModel != null && this.checkingModel.getCheckState(node) == CheckState.mixed;
    }

    public List<E> getCheckedNodes() {
        return this.getCheckedNodes(true);
    }

    public List<E> getCheckedNodes(boolean optimize) {
        return this.checkingModel != null ? this.checkingModel.getCheckedNodes(optimize) : new ArrayList(0);
    }

    public List<E> getMixedNodes() {
        return this.checkingModel != null ? this.checkingModel.getMixedNodes() : new ArrayList(0);
    }

    public void setChecked(Collection<E> nodes, boolean checked) {
        if (this.checkingModel != null) {
            this.checkingModel.setChecked(nodes, checked);
        }
    }

    public void setChecked(E node, boolean checked) {
        if (this.checkingModel != null) {
            this.checkingModel.setChecked(node, checked);
        }
    }

    public void invertCheck(E node) {
        if (this.checkingModel != null) {
            this.checkingModel.invertCheck(node);
        }
    }

    public void invertCheck(List<E> nodes) {
        if (this.checkingModel != null) {
            this.checkingModel.invertCheck(nodes);
        }
    }

    public void uncheckAll() {
        if (this.checkingModel != null) {
            this.checkingModel.uncheckAll();
        }
    }

    public void checkAll() {
        if (this.checkingModel != null) {
            this.checkingModel.checkAll();
        }
    }

    public TreeCheckingModel<E> getCheckingModel() {
        return this.checkingModel;
    }

    public void setCheckingModel(TreeCheckingModel<E> checkingModel) {
        for (CheckStateChangeListener<E> listener : this.checkStateChangeListeners) {
            this.checkingModel.removeCheckStateChangeListener(listener);
        }
        this.checkingModel = checkingModel;
        this.updateAllVisibleNodes();
        for (CheckStateChangeListener<E> listener : this.checkStateChangeListeners) {
            checkingModel.addCheckStateChangeListener(listener);
        }
    }

    protected TreeCheckingModel<E> createDefaultCheckingModel(WebCheckBoxTree<E> checkBoxTree) {
        return new DefaultTreeCheckingModel<E>(checkBoxTree);
    }

    public boolean isCheckBoxEnabled(E node) {
        return this.enabledStateProvider == null || this.enabledStateProvider.provide(node);
    }

    public void setCheckBoxEnabledStateProvider(StateProvider<E> provider) {
        this.enabledStateProvider = provider;
    }

    public boolean isCheckBoxVisible(E node) {
        return this.visibleStateProvider == null || this.visibleStateProvider.provide(node);
    }

    public void setCheckBoxVisibleStateProvider(StateProvider<E> provider) {
        this.visibleStateProvider = provider;
    }

    public boolean isRecursiveCheckingEnabled() {
        return this.recursiveChecking != null ? this.recursiveChecking : true;
    }

    public void setRecursiveChecking(boolean recursive) {
        boolean modified = this.recursiveChecking != recursive;
        this.recursiveChecking = recursive;
        if (modified && this.checkingModel != null) {
            this.checkingModel.checkingModeChanged(this.recursiveChecking);
        }
    }

    public boolean isCheckBoxVisible() {
        return this.checkBoxVisible != null ? this.checkBoxVisible : WebCheckBoxTreeStyle.checkBoxVisible;
    }

    public void setCheckBoxVisible(boolean visible) {
        this.checkBoxVisible = visible;
        this.updateAllVisibleNodes();
    }

    public boolean isCheckingEnabled() {
        return this.checkingEnabled != null ? this.checkingEnabled : WebCheckBoxTreeStyle.checkingEnabled;
    }

    public void setCheckingEnabled(boolean enabled) {
        this.checkingEnabled = enabled;
        this.repaint();
    }

    public boolean isCheckMixedOnToggle() {
        return this.checkMixedOnToggle != null ? this.checkMixedOnToggle : WebCheckBoxTreeStyle.checkMixedOnToggle;
    }

    public void setCheckMixedOnToggle(boolean checkMixedOnToggle) {
        this.checkMixedOnToggle = checkMixedOnToggle;
    }

    public Rectangle getCheckBoxBounds(E node) {
        return this.getCheckBoxBounds(this.getPathForNode(node));
    }

    public Rectangle getCheckBoxBounds(TreePath treePath) {
        if (this.checkBoxCellRenderer != null) {
            int checkBoxWidth = this.checkBoxCellRenderer.getCheckBoxWidth();
            Rectangle pathBounds = this.getPathBounds(treePath);
            if (this.getComponentOrientation().isLeftToRight()) {
                pathBounds.width = checkBoxWidth;
            } else {
                pathBounds.x += pathBounds.width - checkBoxWidth;
                pathBounds.width = checkBoxWidth;
            }
            return pathBounds;
        }
        return null;
    }

    public boolean isCheckingByUserEnabled() {
        return this.isEnabled() && this.isCheckBoxVisible() && this.isCheckingEnabled();
    }

    public void addCheckStateChangeListener(CheckStateChangeListener<E> listener) {
        this.checkStateChangeListeners.add(listener);
        if (this.checkingModel != null) {
            this.checkingModel.addCheckStateChangeListener(listener);
        }
    }

    public void removeCheckStateChangeListener(CheckStateChangeListener listener) {
        this.checkStateChangeListeners.remove(listener);
        if (this.checkingModel != null) {
            this.checkingModel.removeCheckStateChangeListener(listener);
        }
    }

    public void fireCheckStateChanged(List<CheckStateChange<E>> stateChanges) {
        for (CheckStateChangeListener listener : CollectionUtils.copy(this.checkStateChangeListeners)) {
            listener.checkStateChanged(stateChanges);
        }
    }

    protected class Handler
    implements MouseListener,
    KeyListener {
        protected Handler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (WebCheckBoxTree.this.isCheckingByUserEnabled() && Hotkey.SPACE.isTriggered(e)) {
                List nodes = WebCheckBoxTree.this.getSelectedNodes();
                Iterator nodesIterator = nodes.iterator();
                while (nodesIterator.hasNext()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodesIterator.next();
                    if (WebCheckBoxTree.this.isCheckBoxVisible(node) && WebCheckBoxTree.this.isCheckBoxEnabled(node)) continue;
                    nodesIterator.remove();
                }
                if (nodes.size() > 0) {
                    WebCheckBoxTree.this.invertCheck(nodes);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle checkBoxBounds;
            Object node;
            if (WebCheckBoxTree.this.isCheckingByUserEnabled() && SwingUtils.isLeftMouseButton(e) && (node = WebCheckBoxTree.this.getNodeForLocation(e.getPoint())) != null && WebCheckBoxTree.this.isCheckBoxVisible(node) && WebCheckBoxTree.this.isCheckBoxEnabled(node) && (checkBoxBounds = WebCheckBoxTree.this.getCheckBoxBounds(node)).contains(e.getPoint())) {
                WebCheckBoxTree.this.invertCheck(node);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

