/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AbstractTreeDataProvider;
import com.alee.extended.tree.ChildsListener;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeNodeComparator;
import com.alee.extended.tree.WebFileTreeStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.compare.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileTreeDataProvider
extends AbstractTreeDataProvider<FileTreeNode> {
    protected List<File> rootFiles;

    public FileTreeDataProvider(File ... rootFiles) {
        this.rootFiles = CollectionUtils.copy((Object[])rootFiles);
        this.comparator = new FileTreeNodeComparator();
        this.filter = WebFileTreeStyle.filter;
    }

    public FileTreeDataProvider(List<File> rootFiles) {
        this.rootFiles = rootFiles;
        this.comparator = new FileTreeNodeComparator();
        this.filter = WebFileTreeStyle.filter;
    }

    public FileTreeDataProvider(Filter<FileTreeNode> filter, File ... rootFiles) {
        this.rootFiles = CollectionUtils.copy((Object[])rootFiles);
        this.comparator = new FileTreeNodeComparator();
        this.filter = filter;
    }

    public FileTreeDataProvider(Filter<FileTreeNode> filter, List<File> rootFiles) {
        this.rootFiles = rootFiles;
        this.comparator = new FileTreeNodeComparator();
        this.filter = filter;
    }

    @Override
    public FileTreeNode getRoot() {
        return this.rootFiles.size() == 1 ? new FileTreeNode(this.rootFiles.get(0)) : new FileTreeNode(null);
    }

    @Override
    public void loadChilds(FileTreeNode parent, ChildsListener<FileTreeNode> listener) {
        try {
            listener.childsLoadCompleted(parent.getFile() == null ? this.getRootChilds() : this.getFileChilds(parent));
        }
        catch (Throwable cause) {
            listener.childsLoadFailed(cause);
        }
    }

    protected List<FileTreeNode> getRootChilds() {
        ArrayList<FileTreeNode> childs = new ArrayList<FileTreeNode>(this.rootFiles.size());
        for (File rootFile : this.rootFiles) {
            childs.add(new FileTreeNode(rootFile));
        }
        return childs;
    }

    public List<FileTreeNode> getFileChilds(FileTreeNode node) {
        File[] childsList = node.getFile().listFiles();
        if (childsList == null || childsList.length == 0) {
            return new ArrayList<FileTreeNode>(0);
        }
        ArrayList<FileTreeNode> childs = new ArrayList<FileTreeNode>(childsList.length);
        for (File f : childsList) {
            childs.add(new FileTreeNode(f));
        }
        return childs;
    }

    @Override
    public Filter<FileTreeNode> getChildsFilter(FileTreeNode node) {
        return node.getFile() == null ? null : super.getChildsFilter(node);
    }

    @Override
    public boolean isLeaf(FileTreeNode node) {
        return node.getFile() != null && !FileUtils.isDirectory((File)node.getFile());
    }
}

