/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.laf.tree.UniqueNode;
import com.alee.utils.compare.Filter;
import com.alee.utils.text.DefaultTextProvider;
import com.alee.utils.text.TextProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;

public class AsyncTreeNodesFilter<E extends AsyncUniqueNode>
implements Filter<E> {
    protected TextProvider<E> textProvider;
    protected Map<String, Boolean> acceptStatesCache = new HashMap<String, Boolean>();
    protected boolean matchCase = false;
    protected boolean useSpaceAsSeparator = false;
    protected boolean searchFromStart = false;
    protected String searchText = "";

    public TextProvider<E> getTextProvider() {
        return this.textProvider;
    }

    public void setTextProvider(TextProvider<E> textProvider) {
        this.textProvider = textProvider != null ? textProvider : new DefaultTextProvider();
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public void setMatchCase(boolean matchCase) {
        this.matchCase = matchCase;
    }

    public boolean isUseSpaceAsSeparator() {
        return this.useSpaceAsSeparator;
    }

    public void setUseSpaceAsSeparator(boolean useSpaceAsSeparator) {
        this.useSpaceAsSeparator = useSpaceAsSeparator;
    }

    public boolean isSearchFromStart() {
        return this.searchFromStart;
    }

    public void setSearchFromStart(boolean searchFromStart) {
        this.searchFromStart = searchFromStart;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void clearCache() {
        this.acceptStatesCache.clear();
    }

    public void clearCache(E node) {
        this.clearCache(((UniqueNode)node).getId());
    }

    public void clearCache(String nodeId) {
        this.acceptStatesCache.remove(nodeId);
    }

    public boolean accept(E node) {
        String searchRequest = this.matchCase ? this.searchText : this.searchText.toLowerCase();
        return searchRequest.equals("") || this.acceptIncludingChilds(node, searchRequest);
    }

    protected boolean acceptIncludingChilds(E node, String searchRequest) {
        if (this.acceptNode(node, searchRequest)) {
            return true;
        }
        for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
            if (!this.acceptIncludingChilds(((AsyncUniqueNode)node).getChildAt(i), searchRequest)) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptNode(E node, String searchRequest) {
        Boolean accept = this.acceptStatesCache.get(((UniqueNode)node).getId());
        if (accept == null) {
            accept = this.acceptNodeImpl(node, searchRequest);
            this.acceptStatesCache.put(((UniqueNode)node).getId(), accept);
        }
        return accept;
    }

    protected boolean acceptNodeImpl(E node, String searchRequest) {
        String nodeText;
        String string = nodeText = this.matchCase ? this.textProvider.provide(node) : this.textProvider.provide(node).toLowerCase();
        if (this.useSpaceAsSeparator) {
            StringTokenizer tokenizer = new StringTokenizer(searchRequest, " ", false);
            while (tokenizer.hasMoreTokens()) {
                if (!this.accept(nodeText, tokenizer.nextToken(), this.searchFromStart)) continue;
                return true;
            }
            return false;
        }
        return this.accept(nodeText, searchRequest, this.searchFromStart);
    }

    protected boolean accept(String nodeText, String searchRequest, boolean searchFromStart) {
        return searchFromStart ? nodeText.startsWith(searchRequest) : nodeText.contains(searchRequest);
    }
}

