/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncNodeState;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeModelAdapter;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncTreeQueue;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.ChildsListener;
import com.alee.extended.tree.NodeImageObserver;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.DoubleMap;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class AsyncTreeModel<E extends AsyncUniqueNode>
extends WebTreeModel<E> {
    protected static final String ROOT_CACHE = "root";
    protected final Object modelListenersLock = new Object();
    protected final List<AsyncTreeModelListener> asyncTreeModelListeners = new ArrayList<AsyncTreeModelListener>(1);
    protected WebAsyncTree<E> tree;
    protected boolean asyncLoading = true;
    protected AsyncTreeDataProvider<E> dataProvider;
    protected E rootNode = null;
    protected final Object cacheLock = new Object();
    protected final Map<String, Boolean> nodeCached = new HashMap<String, Boolean>();
    protected final Map<String, List<E>> rawNodeChildsCache = new HashMap<String, List<E>>();
    protected final DoubleMap<String, E> nodeById = new DoubleMap();
    protected final Object busyLock = new Object();

    public AsyncTreeModel(WebAsyncTree<E> tree, AsyncTreeDataProvider<E> dataProvider) {
        super(null);
        this.tree = tree;
        this.dataProvider = dataProvider;
    }

    public boolean isAsyncLoading() {
        return this.asyncLoading;
    }

    public void setAsyncLoading(boolean asyncLoading) {
        this.asyncLoading = asyncLoading;
    }

    public AsyncTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.cacheNodeById(this.rootNode);
            this.registerObserver(this.rootNode);
        }
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.dataProvider.isLeaf((AsyncUniqueNode)node);
    }

    @Override
    public int getChildCount(Object parent) {
        AsyncUniqueNode node = (AsyncUniqueNode)parent;
        if (this.isLeaf(node)) {
            return 0;
        }
        if (this.areChildsLoaded(node)) {
            return super.getChildCount(parent);
        }
        return this.loadChildsCount(node);
    }

    public E getChild(Object parent, int index) {
        AsyncUniqueNode node = (AsyncUniqueNode)parent;
        if (this.areChildsLoaded(node)) {
            return (E)((AsyncUniqueNode)super.getChild(parent, index));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areChildsLoaded(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            Boolean cached = this.nodeCached.get(((UniqueNode)node).getId());
            return cached != null && cached != false;
        }
    }

    @Override
    public void reload(TreeNode node) {
        this.tree.cancelEditing();
        this.clearNodeChildsCache((AsyncUniqueNode)node, false);
        super.reload(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildsCache(E node, boolean clearNode) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (clearNode) {
                this.nodeById.remove((Object)((UniqueNode)node).getId());
            }
            this.nodeCached.remove(((UniqueNode)node).getId());
            List<E> childs = this.rawNodeChildsCache.remove(((UniqueNode)node).getId());
            if (childs != null) {
                for (AsyncUniqueNode child : childs) {
                    this.clearNodeChildsCache(child, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildsCache(List<E> nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (AsyncUniqueNode node : nodes) {
                this.clearNodeChildsCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildsCache(E[] nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (E node : nodes) {
                this.clearNodeChildsCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodeById(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.nodeById.put((Object)((UniqueNode)node).getId(), node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodesById(List<E> nodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (AsyncUniqueNode node : nodes) {
                this.nodeById.put((Object)node.getId(), (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadChildsCount(E parent) {
        Object object = this.busyLock;
        synchronized (object) {
            if (((AsyncUniqueNode)parent).isLoading()) {
                return 0;
            }
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loading);
            this.nodeChanged((TreeNode)parent);
        }
        this.fireChildsLoadStarted(parent);
        int childCount = ((DefaultMutableTreeNode)parent).getChildCount();
        if (childCount > 0) {
            int[] indices = new int[childCount];
            Object[] childs = new Object[childCount];
            for (int i = childCount - 1; i >= 0; --i) {
                indices[i] = i;
                childs[i] = ((AsyncUniqueNode)parent).getChildAt(i);
                ((DefaultMutableTreeNode)parent).remove(i);
            }
            this.nodesWereRemoved((TreeNode)parent, indices, childs);
        }
        if (this.asyncLoading) {
            AsyncTreeQueue.execute(this.tree, new Runnable((AsyncUniqueNode)parent){
                final /* synthetic */ AsyncUniqueNode val$parent;
                {
                    this.val$parent = asyncUniqueNode;
                }

                @Override
                public void run() {
                    AsyncTreeModel.this.dataProvider.loadChilds(this.val$parent, new ChildsListener<E>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void childsLoadCompleted(List<E> childs) {
                            Object object = AsyncTreeModel.this.cacheLock;
                            synchronized (object) {
                                AsyncTreeModel.this.rawNodeChildsCache.put(val$parent.getId(), childs);
                                AsyncTreeModel.this.cacheNodesById(childs);
                            }
                            final List<AsyncUniqueNode> realChilds = AsyncTreeModel.this.filterAndSort(val$parent, childs);
                            Object object2 = AsyncTreeModel.this.cacheLock;
                            synchronized (object2) {
                                AsyncTreeModel.this.nodeCached.put(val$parent.getId(), true);
                            }
                            SwingUtils.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (realChilds != null && realChilds.size() > 0) {
                                        AsyncTreeModel.this.insertNodesIntoImpl(realChilds, val$parent, 0);
                                    }
                                    Object object = AsyncTreeModel.this.busyLock;
                                    synchronized (object) {
                                        val$parent.setState(AsyncNodeState.loaded);
                                        AsyncTreeModel.this.nodeChanged(val$parent);
                                    }
                                    AsyncTreeModel.this.fireChildsLoadCompleted(val$parent, realChilds);
                                }
                            });
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void childsLoadFailed(final Throwable cause) {
                            Object object = AsyncTreeModel.this.cacheLock;
                            synchronized (object) {
                                AsyncTreeModel.this.rawNodeChildsCache.put(val$parent.getId(), new ArrayList(0));
                                AsyncTreeModel.this.nodeCached.put(val$parent.getId(), true);
                            }
                            SwingUtils.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = AsyncTreeModel.this.busyLock;
                                    synchronized (object) {
                                        val$parent.setState(AsyncNodeState.failed);
                                        val$parent.setFailureCause(cause);
                                        AsyncTreeModel.this.nodeChanged(val$parent);
                                    }
                                    AsyncTreeModel.this.fireChildsLoadFailed(val$parent, cause);
                                }
                            });
                        }
                    });
                }
            });
            return 0;
        }
        this.dataProvider.loadChilds(parent, new ChildsListener<E>((AsyncUniqueNode)parent){
            final /* synthetic */ AsyncUniqueNode val$parent;
            {
                this.val$parent = asyncUniqueNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void childsLoadCompleted(List<E> childs) {
                Object object = AsyncTreeModel.this.cacheLock;
                synchronized (object) {
                    AsyncTreeModel.this.rawNodeChildsCache.put(this.val$parent.getId(), childs);
                    AsyncTreeModel.this.cacheNodesById(childs);
                }
                List<AsyncUniqueNode> realChilds = AsyncTreeModel.this.filterAndSort(this.val$parent, childs);
                Object object2 = AsyncTreeModel.this.cacheLock;
                synchronized (object2) {
                    AsyncTreeModel.this.nodeCached.put(this.val$parent.getId(), true);
                }
                if (realChilds != null && realChilds.size() > 0) {
                    AsyncTreeModel.this.insertNodesIntoImpl(realChilds, this.val$parent, 0);
                }
                object2 = AsyncTreeModel.this.busyLock;
                synchronized (object2) {
                    this.val$parent.setState(AsyncNodeState.loaded);
                    AsyncTreeModel.this.nodeChanged(this.val$parent);
                }
                AsyncTreeModel.this.fireChildsLoadCompleted(this.val$parent, realChilds);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void childsLoadFailed(Throwable cause) {
                Object object = AsyncTreeModel.this.cacheLock;
                synchronized (object) {
                    AsyncTreeModel.this.rawNodeChildsCache.put(this.val$parent.getId(), new ArrayList(0));
                    AsyncTreeModel.this.nodeCached.put(this.val$parent.getId(), true);
                }
                object = AsyncTreeModel.this.busyLock;
                synchronized (object) {
                    this.val$parent.setState(AsyncNodeState.failed);
                    this.val$parent.setFailureCause(cause);
                    AsyncTreeModel.this.nodeChanged(this.val$parent);
                }
                AsyncTreeModel.this.fireChildsLoadFailed(this.val$parent, cause);
            }
        });
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildNodes(E parent, final List<E> childs) {
        Object object = this.busyLock;
        synchronized (object) {
            if (((AsyncUniqueNode)parent).isLoading()) {
                return;
            }
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loading);
            this.nodeChanged((TreeNode)parent);
        }
        object = this.cacheLock;
        synchronized (object) {
            this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            this.cacheNodesById(childs);
        }
        final List<E> realChilds = this.filterAndSort(parent, childs);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
        }
        SwingUtils.invokeLater(new Runnable((AsyncUniqueNode)parent){
            final /* synthetic */ AsyncUniqueNode val$parent;
            {
                this.val$parent = asyncUniqueNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (realChilds != null && realChilds.size() > 0) {
                    AsyncTreeModel.this.clearNodeChildsCache(childs, false);
                    AsyncTreeModel.this.insertNodesIntoImpl(realChilds, this.val$parent, 0);
                }
                Object object = AsyncTreeModel.this.busyLock;
                synchronized (object) {
                    this.val$parent.setState(AsyncNodeState.loaded);
                    AsyncTreeModel.this.nodeChanged(this.val$parent);
                }
                AsyncTreeModel.this.fireChildsLoadCompleted(this.val$parent, realChilds);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNodes(E parent, List<E> childs) {
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChilds = this.rawNodeChildsCache.get(((UniqueNode)parent).getId());
            if (cachedChilds == null) {
                cachedChilds = new ArrayList(childs.size());
                this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), cachedChilds);
            }
            cachedChilds.addAll(childs);
            this.cacheNodesById(childs);
        }
        this.clearNodeChildsCache(childs, false);
        this.insertNodesIntoImpl(childs, parent, ((DefaultMutableTreeNode)parent).getChildCount());
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        if (node == null) {
            return;
        }
        AsyncUniqueNode childNode = (AsyncUniqueNode)node;
        AsyncUniqueNode parentNode = childNode.getParent();
        if (parentNode == null || !parentNode.isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> childs = this.rawNodeChildsCache.get(parentNode.getId());
            if (childs != null) {
                childs.remove(childNode);
            }
        }
        this.clearNodeChildsCache(childNode, true);
        super.removeNodeFromParent(node);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        AsyncUniqueNode childNode = (AsyncUniqueNode)newChild;
        AsyncUniqueNode parentNode = (AsyncUniqueNode)parent;
        if (!parentNode.isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<AsyncUniqueNode> childs = this.rawNodeChildsCache.get(parentNode.getId());
            if (childs == null) {
                childs = new ArrayList(1);
                this.rawNodeChildsCache.put(parentNode.getId(), childs);
            }
            childs.add(childNode);
        }
        this.clearNodeChildsCache(childNode, false);
        super.insertNodeInto(newChild, parent, index);
        this.registerObserver(childNode);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(List<E> children, E parent, int index) {
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> childs = this.rawNodeChildsCache.get(((UniqueNode)parent).getId());
            if (childs == null) {
                childs = new ArrayList(1);
                this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            }
            childs.addAll(index, children);
        }
        this.clearNodeChildsCache(children, false);
        this.insertNodesIntoImpl(children, parent, index);
        this.updateSortingAndFiltering(parent);
    }

    protected void insertNodesIntoImpl(List<E> children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
        this.registerObservers(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(E[] children, E parent, int index) {
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> childs = this.rawNodeChildsCache.get(((UniqueNode)parent).getId());
            if (childs == null) {
                childs = new ArrayList(1);
                this.rawNodeChildsCache.put(((UniqueNode)parent).getId(), childs);
            }
            for (int i = children.length - 1; i >= 0; --i) {
                childs.add(index, children[i]);
            }
        }
        this.clearNodeChildsCache((E)children, false);
        super.insertNodesInto(children, parent, index);
        this.registerObservers((AsyncUniqueNode[])children);
        this.updateSortingAndFiltering(parent);
    }

    public void updateSortingAndFiltering() {
        this.updateSortingAndFiltering(this.getRoot(), true);
    }

    public void updateSortingAndFiltering(E parentNode) {
        this.updateSortingAndFiltering(parentNode, false);
    }

    public void updateSortingAndFiltering(E parentNode, boolean recursively) {
        if (parentNode != null) {
            if (((AsyncUniqueNode)parentNode).isLoaded() && this.rawNodeChildsCache.containsKey(((UniqueNode)parentNode).getId())) {
                this.performSortingAndFiltering(parentNode, recursively);
            } else if (((AsyncUniqueNode)parentNode).isLoading()) {
                this.addAsyncTreeModelListener(new AsyncTreeModelAdapter((AsyncUniqueNode)parentNode, recursively){
                    final /* synthetic */ AsyncUniqueNode val$parentNode;
                    final /* synthetic */ boolean val$recursively;
                    {
                        this.val$parentNode = asyncUniqueNode;
                        this.val$recursively = bl;
                    }

                    @Override
                    public void childsLoadCompleted(AsyncUniqueNode parent, List childs) {
                        if (this.val$parentNode.getId().equals(parent.getId())) {
                            AsyncTreeModel.this.removeAsyncTreeModelListener(this);
                            AsyncTreeModel.this.performSortingAndFiltering(this.val$parentNode, this.val$recursively);
                        }
                    }

                    @Override
                    public void childsLoadFailed(AsyncUniqueNode parent, Throwable cause) {
                        if (this.val$parentNode.getId().equals(parent.getId())) {
                            AsyncTreeModel.this.removeAsyncTreeModelListener(this);
                        }
                    }
                });
            }
        }
    }

    protected void performSortingAndFiltering(E parentNode, boolean recursively) {
        TreeState treeState = this.tree.getTreeState();
        if (recursively) {
            this.performSortingAndFilteringRecursivelyImpl(parentNode);
        } else {
            this.performSortingAndFilteringImpl(parentNode);
        }
        this.nodeStructureChanged((TreeNode)parentNode);
        this.tree.setTreeState(treeState);
    }

    protected void performSortingAndFilteringRecursivelyImpl(E parentNode) {
        this.performSortingAndFilteringImpl(parentNode);
        for (int i = 0; i < ((DefaultMutableTreeNode)parentNode).getChildCount(); ++i) {
            this.performSortingAndFilteringRecursivelyImpl(((AsyncUniqueNode)parentNode).getChildAt(i));
        }
    }

    protected void performSortingAndFilteringImpl(E parentNode) {
        List<E> childs = this.rawNodeChildsCache.get(((UniqueNode)parentNode).getId());
        if (childs != null) {
            ((DefaultMutableTreeNode)parentNode).removeAllChildren();
            List<E> realChilds = this.filterAndSort(parentNode, childs);
            for (AsyncUniqueNode child : realChilds) {
                ((DefaultMutableTreeNode)parentNode).add(child);
            }
        }
    }

    protected List<E> filterAndSort(E parentNode, List<E> childs) {
        if (childs == null || childs.size() == 0) {
            return new ArrayList(0);
        }
        Filter<E> filter = this.dataProvider.getChildsFilter(parentNode);
        Comparator<E> comparator = this.dataProvider.getChildsComparator(parentNode);
        if (filter != null) {
            List filtered = CollectionUtils.filter(childs, filter);
            if (comparator != null) {
                Collections.sort(filtered, comparator);
            }
            return filtered;
        }
        if (comparator != null) {
            childs = CollectionUtils.copy(childs);
            Collections.sort(childs, comparator);
        }
        return childs;
    }

    public E findNode(String nodeId) {
        return (E)((AsyncUniqueNode)this.nodeById.get((Object)nodeId));
    }

    public DoubleMap<String, E> getNodesCache() {
        return MapUtils.copyDoubleMap(this.nodeById);
    }

    protected void registerObservers(List<E> nodes) {
        for (AsyncUniqueNode newChild : nodes) {
            this.registerObserver(newChild);
        }
    }

    protected void registerObservers(E[] nodes) {
        for (E newChild : nodes) {
            this.registerObserver(newChild);
        }
    }

    protected void registerObserver(E node) {
        ImageIcon loaderIcon = ((AsyncUniqueNode)node).getLoaderIcon();
        if (loaderIcon != null) {
            loaderIcon.setImageObserver(new NodeImageObserver(this.tree, (AsyncUniqueNode)node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncTreeModelListener> getAsyncTreeModelListeners() {
        Object object = this.modelListenersLock;
        synchronized (object) {
            return CollectionUtils.copy(this.asyncTreeModelListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncTreeModelListener(AsyncTreeModelListener listener) {
        Object object = this.modelListenersLock;
        synchronized (object) {
            this.asyncTreeModelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAsyncTreeModelListener(AsyncTreeModelListener listener) {
        Object object = this.modelListenersLock;
        synchronized (object) {
            this.asyncTreeModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildsLoadStarted(E parent) {
        List listeners;
        Object object = this.modelListenersLock;
        synchronized (object) {
            listeners = CollectionUtils.copy(this.asyncTreeModelListeners);
        }
        for (AsyncTreeModelListener listener : listeners) {
            listener.childsLoadStarted(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildsLoadCompleted(E parent, List<E> childs) {
        List listeners;
        Object object = this.modelListenersLock;
        synchronized (object) {
            listeners = CollectionUtils.copy(this.asyncTreeModelListeners);
        }
        for (AsyncTreeModelListener listener : listeners) {
            listener.childsLoadCompleted(parent, childs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildsLoadFailed(E parent, Throwable cause) {
        List listeners;
        Object object = this.modelListenersLock;
        synchronized (object) {
            listeners = CollectionUtils.copy(this.asyncTreeModelListeners);
        }
        for (AsyncTreeModelListener listener : listeners) {
            listener.childsLoadFailed(parent, cause);
        }
    }
}

