/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.blocks;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.blocks.BlockType;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class BlocksTransitionEffect
extends DefaultTransitionEffect {
    private static final String BLOCK_TYPE = "BLOCK_TYPE";
    private static final String BLOCK_FADE = "BLOCK_FADE";
    private static final String BLOCK_SIZE = "BLOCK_SIZE";
    private static final String BLOCK_SPEED = "BLOCK_SPEED";
    private static final String BLOCK_AMOUNT = "BLOCK_AMOUNT";
    private int size;
    private int speed;
    private int blocksAmount;
    private boolean fade;
    private BlockType type;
    private Direction direction;
    private int[][] progress;
    private Shape clip;
    private List<Point> allPoints;
    private WebTimer randomizer;

    public BlockType getType() {
        return this.get(BLOCK_TYPE, BlockType.random);
    }

    public void setType(BlockType type) {
        this.put(BLOCK_TYPE, (Object)type);
    }

    public boolean isFade() {
        return this.get(BLOCK_FADE, true);
    }

    public void setFade(boolean transparent) {
        this.put(BLOCK_FADE, transparent);
    }

    public int getSize() {
        return this.get(BLOCK_SIZE, 80);
    }

    public void setSize(int size) {
        this.put(BLOCK_SIZE, size);
    }

    public int getSpeed() {
        return this.get(BLOCK_SPEED, 4);
    }

    public void setSpeed(int speed) {
        this.put(BLOCK_SPEED, speed);
    }

    public int getBlocksAmount() {
        return this.get(BLOCK_AMOUNT, 5);
    }

    public void setBlocksAmount(int blocksAmount) {
        this.put(BLOCK_AMOUNT, blocksAmount);
    }

    @Override
    public void prepareAnimation(final ImageTransition imageTransition) {
        int j;
        int i;
        this.size = this.getSize();
        this.speed = this.getSpeed();
        this.blocksAmount = this.getBlocksAmount();
        this.fade = this.isFade();
        this.direction = TransitionUtils.getActualValue(this.getDirection());
        this.type = TransitionUtils.getActualValue(this.getType());
        int h = imageTransition.getHeight();
        h = h % this.size == 0 ? h : h / this.size * this.size + this.size;
        int w = imageTransition.getWidth();
        w = w % this.size == 0 ? w : w / this.size * this.size + this.size;
        int cols = w / this.size;
        int rows = h / this.size;
        this.progress = new int[cols][rows];
        for (i = 0; i < cols; ++i) {
            for (j = 0; j < rows; ++j) {
                this.progress[i][j] = 0;
            }
        }
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            this.progress[0][0] = this.speed;
        } else {
            this.progress[cols - 1][rows - 1] = this.speed;
        }
        if (!this.fade) {
            this.clip = this.getBlocksProgressShape(this.progress);
        }
        if (this.type.equals((Object)BlockType.randomize)) {
            this.allPoints = new ArrayList<Point>();
            for (i = 0; i < cols; ++i) {
                for (j = 0; j < rows; ++j) {
                    this.allPoints.add(new Point(i, j));
                }
            }
            if (this.randomizer != null) {
                this.randomizer.stop();
            }
            this.randomizer = new WebTimer("BlocksTransitionEffect.randomizer", 50L);
            this.randomizer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < BlocksTransitionEffect.this.blocksAmount; ++i) {
                        if (BlocksTransitionEffect.this.allPoints.size() > 0) {
                            int index = MathUtils.random((int)BlocksTransitionEffect.this.allPoints.size());
                            Point toAdd = (Point)BlocksTransitionEffect.this.allPoints.remove(index);
                            int[] nArray = BlocksTransitionEffect.this.progress[toAdd.x];
                            int n = toAdd.y;
                            nArray[n] = nArray[n] + BlocksTransitionEffect.this.speed;
                            imageTransition.repaint();
                            continue;
                        }
                        BlocksTransitionEffect.this.randomizer.stop();
                    }
                }
            });
            this.randomizer.start();
        }
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        boolean allMax = true;
        int cols = this.progress.length;
        int rows = this.progress[0].length;
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                if (this.progress[i][j] >= this.size) continue;
                if (this.progress[i][j] > 0) {
                    int[] nArray = this.progress[i];
                    int n = j;
                    nArray[n] = nArray[n] + this.speed;
                } else if (this.type.equals((Object)BlockType.cascade) && this.canStartGrow(i, j, this.progress)) {
                    int[] nArray = this.progress[i];
                    int n = j;
                    nArray[n] = nArray[n] + this.speed;
                }
                if (!allMax || this.progress[i][j] >= this.size) continue;
                allMax = false;
            }
        }
        if (!this.fade) {
            this.clip = this.getBlocksProgressShape(this.progress);
        }
        if (!allMax) {
            imageTransition.repaint();
            return false;
        }
        this.clip = null;
        if (this.randomizer != null) {
            this.randomizer.stop();
        }
        return true;
    }

    private Shape getBlocksProgressShape(int[][] blocksProgress) {
        GeneralPath gp = new GeneralPath(0);
        for (int i = 0; i < blocksProgress.length; ++i) {
            for (int j = 0; j < blocksProgress[0].length; ++j) {
                gp.append(new Rectangle(i * this.size, j * this.size, blocksProgress[i][j], blocksProgress[i][j]), false);
            }
        }
        return gp;
    }

    private boolean canStartGrow(int i, int j, int[][] blocksProgress) {
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            return i > 0 && (float)blocksProgress[i - 1][j] > (float)this.size / 6.0f || j > 0 && (float)blocksProgress[i][j - 1] > (float)this.size / 6.0f || i > 1 && (float)blocksProgress[i - 2][j] > (float)this.size * 2.0f / 6.0f || j > 1 && (float)blocksProgress[i][j - 2] > (float)this.size * 2.0f / 6.0f || i > 2 && (float)blocksProgress[i - 3][j] > (float)this.size * 3.0f / 6.0f || j > 2 && (float)blocksProgress[i][j - 3] > (float)this.size * 3.0f / 6.0f || i > 3 && (float)blocksProgress[i - 4][j] > (float)this.size * 4.0f / 6.0f || j > 3 && (float)blocksProgress[i][j - 4] > (float)this.size * 4.0f / 6.0f || i > 4 && (float)blocksProgress[i - 5][j] > (float)this.size * 5.0f / 6.0f || j > 4 && (float)blocksProgress[i][j - 5] > (float)this.size * 5.0f / 6.0f;
        }
        return i < blocksProgress.length - 1 && (float)blocksProgress[i + 1][j] > (float)this.size / 6.0f || j < blocksProgress[0].length - 1 && (float)blocksProgress[i][j + 1] > (float)this.size / 6.0f || i < blocksProgress.length - 2 && (float)blocksProgress[i + 2][j] > (float)this.size * 2.0f / 6.0f || j < blocksProgress[0].length - 2 && (float)blocksProgress[i][j + 2] > (float)this.size * 2.0f / 6.0f || i < blocksProgress.length - 3 && (float)blocksProgress[i + 3][j] > (float)this.size * 3.0f / 6.0f || j < blocksProgress[0].length - 3 && (float)blocksProgress[i][j + 3] > (float)this.size * 3.0f / 6.0f || i < blocksProgress.length - 4 && (float)blocksProgress[i + 4][j] > (float)this.size * 4.0f / 6.0f || j < blocksProgress[0].length - 4 && (float)blocksProgress[i][j + 4] > (float)this.size * 4.0f / 6.0f || i < blocksProgress.length - 5 && (float)blocksProgress[i + 5][j] > (float)this.size * 5.0f / 6.0f || j < blocksProgress[0].length - 5 && (float)blocksProgress[i][j + 5] > (float)this.size * 5.0f / 6.0f;
    }

    @Override
    public void paint(Graphics2D g2d, ImageTransition transition) {
        int width = transition.getWidth();
        int height = transition.getHeight();
        g2d.drawImage(transition.getCurrentImage(), 0, 0, width, height, null);
        if (this.fade) {
            int cols = this.progress.length;
            int rows = this.progress[0].length;
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    int block = this.progress[i][j];
                    if (block <= 0) continue;
                    int dx1 = i * this.size;
                    int dy1 = j * this.size;
                    int w = Math.min(width - dx1, this.size);
                    int h = Math.min(height - dy1, this.size);
                    int dx2 = dx1 + w;
                    int dy2 = dy1 + h;
                    Composite old = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf((float)block / (float)this.size), (block < this.size ? 1 : 0) != 0);
                    g2d.drawImage(transition.getOtherImage(), dx1, dy1, dx2, dy2, dx1, dy1, dx2, dy2, null);
                    GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)old, (block < this.size ? 1 : 0) != 0);
                }
            }
        } else {
            Shape old = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)this.clip);
            g2d.drawImage(transition.getOtherImage(), 0, 0, width, height, null);
            GraphicsUtils.restoreClip((Graphics)g2d, (Shape)old);
        }
    }
}

