/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Customizer;
import java.awt.Component;

public final class SplitData<T extends DocumentData>
implements StructureData<T> {
    protected final WebSplitPane splitPane;
    protected int orientation;
    protected StructureData first;
    protected StructureData last;

    public SplitData(WebDocumentPane<T> documentPane, int orientation, StructureData first, StructureData last) {
        this.orientation = orientation;
        this.first = first;
        this.last = last;
        this.splitPane = this.createSplit(orientation, first, last);
        this.updateSplitPaneCustomizer(documentPane);
    }

    protected WebSplitPane createSplit(int orientation, StructureData first, StructureData last) {
        WebSplitPane splitPane = new WebSplitPane(orientation, first.getComponent(), last.getComponent());
        splitPane.putClientProperty("document.pane.data", this);
        splitPane.setContinuousLayout(true);
        splitPane.setDrawDividerBorder(true);
        splitPane.setDividerSize(8);
        splitPane.setResizeWeight(0.5);
        return splitPane;
    }

    protected void changeSplitOrientation() {
        this.orientation = this.orientation == 1 ? 0 : 1;
        this.splitPane.setOrientation(this.orientation);
    }

    protected void updateSplitPaneCustomizer(WebDocumentPane<T> documentPane) {
        Customizer<WebSplitPane> customizer = documentPane.getSplitPaneCustomizer();
        if (customizer != null) {
            customizer.customize((Object)this.splitPane);
        }
    }

    @Override
    public Component getComponent() {
        return this.getSplitPane();
    }

    @Override
    public PaneData<T> findClosestPane() {
        return this.getFirst().findClosestPane();
    }

    public WebDocumentPane getDocumentPane() {
        return SwingUtils.getFirstParent(this.splitPane, WebDocumentPane.class);
    }

    public WebSplitPane getSplitPane() {
        return this.splitPane;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public StructureData getFirst() {
        return this.first;
    }

    public void setFirst(StructureData first) {
        this.first = first;
        this.splitPane.setLeftComponent(first.getComponent());
    }

    public StructureData getLast() {
        return this.last;
    }

    public void setLast(StructureData last) {
        this.last = last;
        this.splitPane.setRightComponent(last.getComponent());
    }

    public void replace(StructureData element, StructureData replacement) {
        if (this.first == element) {
            this.first = replacement;
            this.splitPane.setLeftComponent(replacement.getComponent());
        }
        if (this.last == element) {
            this.last = replacement;
            this.splitPane.setRightComponent(replacement.getComponent());
        }
    }
}

