/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentDragHandler;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.LM;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Customizer;
import com.alee.utils.swing.menu.PopupMenuGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public final class PaneData<T extends DocumentData>
implements StructureData<T>,
SwingConstants {
    private static final ImageIcon closeTabIcon = new ImageIcon(PaneData.class.getResource("icons/close.png"));
    private static final ImageIcon closeTabRolloverIcon = new ImageIcon(PaneData.class.getResource("icons/close-rollover.png"));
    protected final WebTabbedPane tabbedPane;
    protected final DefaultFocusTracker focusTracker;
    protected List<T> data = new ArrayList<T>();

    public PaneData(WebDocumentPane<T> documentPane) {
        this.tabbedPane = new WebTabbedPane(TabbedPaneStyle.attached);
        this.tabbedPane.putClientProperty("document.pane.data", this);
        this.updateTabbedPaneCustomizer(documentPane);
        HotkeyManager.registerHotkey((Component)this.tabbedPane, this.tabbedPane, Hotkey.CTRL_W, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                PaneData.this.closeSelected();
            }
        });
        DocumentDragHandler.install(this);
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtils.isMiddleMouseButton(e)) {
                    Object document;
                    int index;
                    if (PaneData.this.getDocumentPane().isCloseable() && (index = PaneData.this.tabbedPane.getTabAt(e.getPoint())) != -1 && ((DocumentData)(document = PaneData.this.get(index))).isCloseable()) {
                        PaneData.this.close(document);
                    }
                } else if (SwingUtils.isPopupTrigger(e)) {
                    WebDocumentPane documentPane = PaneData.this.getDocumentPane();
                    if (!documentPane.isTabMenuEnabled()) {
                        return;
                    }
                    final int index = PaneData.this.tabbedPane.getTabAt(e.getPoint());
                    if (index == -1) {
                        return;
                    }
                    Object document = PaneData.this.get(index);
                    boolean csb = documentPane.isCloseable() && ((DocumentData)document).isCloseable();
                    boolean spb = PaneData.this.data.size() > 1 && documentPane.isSplitEnabled();
                    boolean spl = PaneData.this.tabbedPane.getParent() instanceof WebSplitPane;
                    PopupMenuGenerator pmg = new PopupMenuGenerator("document-pane-menu");
                    pmg.setIconSettings(PaneData.class, "icons/menu/", ".png");
                    pmg.setLanguagePrefix("weblaf.ex.docpane");
                    pmg.addItem("close", "close", Hotkey.CTRL_W, csb, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.close(PaneData.this.get(index));
                        }
                    });
                    pmg.addSeparator();
                    pmg.addItem("left", "left", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 2);
                        }
                    });
                    pmg.addItem("right", "right", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 4);
                        }
                    });
                    pmg.addItem("top", "top", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 1);
                        }
                    });
                    pmg.addItem("bottom", "bottom", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 3);
                        }
                    });
                    pmg.addSeparator();
                    pmg.addItem("rotate", "rotate", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.rotate();
                        }
                    });
                    pmg.addItem("unsplit", "unsplit", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.merge();
                        }
                    });
                    pmg.addItem("unsplit", "unsplitall", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.mergeAll();
                        }
                    });
                    WebPopupMenu menu = pmg.getPopupMenu();
                    Dimension mps = menu.getPreferredSize();
                    Rectangle bounds = PaneData.this.tabbedPane.getBoundsAt(index);
                    menu.show(PaneData.this.tabbedPane, bounds.x + bounds.width / 2 - mps.width / 2, bounds.y + bounds.height - menu.getShadeWidth() + 5);
                }
            }
        });
        this.focusTracker = new DefaultFocusTracker(true){

            @Override
            public void focusChanged(boolean focused) {
                if (focused) {
                    PaneData.this.activate();
                }
            }
        };
        FocusManager.addFocusTracker(this.tabbedPane, this.focusTracker);
    }

    protected void updateTabbedPaneCustomizer(WebDocumentPane<T> documentPane) {
        Customizer<WebTabbedPane> customizer = documentPane.getTabbedPaneCustomizer();
        if (customizer != null) {
            customizer.customize((Object)this.tabbedPane);
        }
    }

    @Override
    public Component getComponent() {
        return this.getTabbedPane();
    }

    @Override
    public PaneData<T> findClosestPane() {
        return this;
    }

    public WebDocumentPane getDocumentPane() {
        return SwingUtils.getFirstParent(this.tabbedPane, WebDocumentPane.class);
    }

    public WebTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public List<T> getData() {
        return this.data;
    }

    public int count() {
        return this.data.size();
    }

    public boolean contains(T document) {
        return this.contains(((DocumentData)document).getId());
    }

    public boolean contains(String documentId) {
        for (DocumentData document : this.data) {
            if (!document.getId().equals(documentId)) continue;
            return true;
        }
        return false;
    }

    public void add(T document) {
        this.add(document, -1);
    }

    public void add(T document, int index) {
        int i = index != -1 ? index : this.tabbedPane.getTabCount();
        this.data.add(i, document);
        this.tabbedPane.insertTab("", ((DocumentData)document).getIcon(), ((DocumentData)document).getComponent(), null, i);
        this.tabbedPane.setBackgroundAt(i, ((DocumentData)document).getBackground());
        this.tabbedPane.setTabComponentAt(i, this.createTabComponent(document));
    }

    protected JComponent createTabComponent(T document) {
        WebPanel tabPanel = new WebPanel(new BorderLayout(2, 0));
        tabPanel.setOpaque(false);
        String title = ((DocumentData)document).getTitle();
        if (title != null) {
            if (LM.contains((String)title)) {
                tabPanel.add((Component)WebLabel.createTranslatedLabel(((DocumentData)document).getIcon(), title), (Object)"Center");
            } else {
                tabPanel.add((Component)new WebLabel(title, ((DocumentData)document).getIcon()), (Object)"Center");
            }
        } else {
            tabPanel.add((Component)new WebLabel(((DocumentData)document).getIcon()), (Object)"Center");
        }
        if (this.getDocumentPane().isCloseable() && ((DocumentData)document).isCloseable()) {
            WebButton closeButton = new WebButton((Icon)closeTabIcon, (Icon)closeTabRolloverIcon);
            closeButton.setUndecorated(true);
            closeButton.setFocusable(false);
            closeButton.addActionListener(new ActionListener((DocumentData)document){
                final /* synthetic */ DocumentData val$document;
                {
                    this.val$document = documentData;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneData.this.close(this.val$document);
                }
            });
            tabPanel.add((Component)closeButton, (Object)"After");
        }
        return tabPanel;
    }

    public void open(T document) {
        this.add(document);
        this.getDocumentPane().fireDocumentOpened(document, this, this.indexOf(document));
    }

    public T get(int index) {
        return (T)((DocumentData)this.data.get(index));
    }

    public T get(String id) {
        for (DocumentData document : this.data) {
            if (!document.getId().equals(id)) continue;
            return (T)document;
        }
        return null;
    }

    public T getSelected() {
        int index = this.tabbedPane.getSelectedIndex();
        return (T)(index != -1 ? (DocumentData)this.data.get(index) : null);
    }

    public void setSelected(String id) {
        this.setSelected(this.indexOf(id));
    }

    public void setSelected(T document) {
        this.setSelected(this.indexOf(document));
    }

    public void setSelected(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public int indexOf(String id) {
        return this.indexOf(this.get(id));
    }

    public int indexOf(T document) {
        return this.data.indexOf(document);
    }

    public boolean remove(int index) {
        return this.remove(this.get(index));
    }

    public boolean remove(String id) {
        return this.remove(this.get(id));
    }

    public boolean remove(T document) {
        int index;
        if (document != null && (index = this.indexOf(document)) != -1) {
            this.tabbedPane.remove(index);
            this.data.remove(document);
            return true;
        }
        return false;
    }

    public void closeAll() {
        for (DocumentData document : CollectionUtils.copy(this.data)) {
            this.close(document);
        }
    }

    public boolean close(int index) {
        return this.close(this.get(index));
    }

    public boolean close(String id) {
        return this.close(this.get(id));
    }

    public boolean close(T document) {
        if (document != null) {
            int index;
            WebDocumentPane documentPane = this.getDocumentPane();
            if (documentPane.fireDocumentClosing(document, this, index = this.indexOf(document))) {
                boolean removed = this.remove(document);
                this.mergeIfEmpty();
                documentPane.fireDocumentClosed(document, this, index);
                return removed;
            }
            return false;
        }
        return false;
    }

    public void closeSelected() {
        T selected = this.getSelected();
        if (selected != null) {
            this.close(selected);
        }
    }

    public void activate() {
        WebDocumentPane pane = this.getDocumentPane();
        if (pane != null) {
            pane.activate(this);
        }
    }

    public void split(T document, int direction) {
        WebDocumentPane pane = this.getDocumentPane();
        if (pane != null) {
            pane.split(this, document, direction);
        }
    }

    public void mergeIfEmpty() {
        if (this.count() == 0) {
            this.merge();
        }
    }

    public void rotate() {
        Container parent = this.tabbedPane.getParent();
        if (parent instanceof WebSplitPane) {
            SplitData splitData = WebDocumentPane.getData((WebSplitPane)parent);
            splitData.changeSplitOrientation();
        }
    }

    public void merge() {
        WebDocumentPane documentPane = this.getDocumentPane();
        if (documentPane != null) {
            documentPane.merge(this);
        }
    }

    public void mergeAll() {
        WebDocumentPane pane = this.getDocumentPane();
        if (pane != null) {
            pane.merge(pane.getStructureRoot());
        }
    }
}

