/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.AccordionLayout;
import com.alee.extended.panel.AccordionListener;
import com.alee.extended.panel.AccordionStyle;
import com.alee.extended.panel.CollapsiblePaneAdapter;
import com.alee.extended.panel.CollapsiblePaneListener;
import com.alee.extended.panel.WebAccordionStyle;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.panel.WebPanelStyle;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;

public class WebAccordion
extends WebPanel
implements SwingConstants,
SettingsMethods {
    protected boolean animate = WebAccordionStyle.animate;
    protected AccordionStyle accordionStyle = WebAccordionStyle.accordionStyle;
    protected int orientation = WebAccordionStyle.orientation;
    protected ImageIcon expandIcon = WebAccordionStyle.expandIcon;
    protected ImageIcon collapseIcon = WebAccordionStyle.collapseIcon;
    protected boolean fillSpace = WebAccordionStyle.fillSpace;
    protected boolean multiplySelectionAllowed = WebAccordionStyle.multiplySelectionAllowed;
    protected int gap = WebAccordionStyle.gap;
    protected List<AccordionListener> listeners = new ArrayList<AccordionListener>(1);
    protected List<WebCollapsiblePane> panes = new ArrayList<WebCollapsiblePane>();
    protected List<CollapsiblePaneListener> stateListeners = new ArrayList<CollapsiblePaneListener>();
    protected WebCollapsiblePane lastExpanded = null;

    public WebAccordion() {
        this.initializeDefaultSettings(WebAccordionStyle.accordionStyle);
    }

    public WebAccordion(AccordionStyle style) {
        this.initializeDefaultSettings(style);
    }

    protected void initializeDefaultSettings(AccordionStyle style) {
        this.setPaintFocus(true);
        this.setWebColoredBackground(false);
        this.setLayout(new AccordionLayout(this));
        this.setAccordionStyle(style);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
        this.updatePanesAnimation();
    }

    protected void updatePanesAnimation() {
        for (WebCollapsiblePane pane : this.panes) {
            pane.setAnimate(this.animate);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.updatePanesBorderStyling();
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(ImageIcon expandIcon) {
        this.expandIcon = expandIcon;
        this.updatePaneIcons();
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(ImageIcon collapseIcon) {
        this.collapseIcon = collapseIcon;
        this.updatePaneIcons();
    }

    protected void updatePaneIcons() {
        for (WebCollapsiblePane pane : this.panes) {
            pane.setExpandIcon(this.expandIcon);
            pane.setCollapseIcon(this.collapseIcon);
        }
    }

    public AccordionStyle getAccordionStyle() {
        return this.accordionStyle;
    }

    public void setAccordionStyle(AccordionStyle accordionStyle) {
        this.accordionStyle = accordionStyle;
        this.updatePanesBorderStyling();
    }

    public boolean isFillSpace() {
        return this.fillSpace;
    }

    public void setFillSpace(boolean fillSpace) {
        this.fillSpace = fillSpace;
        this.revalidate();
    }

    public boolean isMultiplySelectionAllowed() {
        return this.multiplySelectionAllowed;
    }

    public void setMultiplySelectionAllowed(boolean multiplySelectionAllowed) {
        this.multiplySelectionAllowed = multiplySelectionAllowed;
        this.updateSelections(-1, true);
    }

    protected void updateSelections(int index, boolean collapse) {
        boolean changed = false;
        if (collapse) {
            if (!this.multiplySelectionAllowed) {
                for (int i = 0; i < this.panes.size(); ++i) {
                    WebCollapsiblePane pane = this.panes.get(i);
                    if (index == -1 && pane.isExpanded()) {
                        index = i;
                    }
                    if (index == -1 || i == index || !pane.isExpanded()) continue;
                    changed = true;
                    pane.setExpanded(false);
                }
            }
        } else if (this.getSelectionCount() == 0) {
            this.lastExpanded.setExpanded(true);
        }
        if (index != -1 || changed) {
            this.fireSelectionChanged();
        }
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
        this.revalidate();
    }

    public WebCollapsiblePane addPane(String title, Component content) {
        return this.addPane(this.panes.size(), title, content);
    }

    public WebCollapsiblePane addPane(int index, String title, Component content) {
        return this.addPane(index, new WebCollapsiblePane(title, content));
    }

    public WebCollapsiblePane addPane(Icon icon, String title, Component content) {
        return this.addPane(this.panes.size(), icon, title, content);
    }

    public WebCollapsiblePane addPane(int index, Icon icon, String title, Component content) {
        return this.addPane(index, new WebCollapsiblePane(icon, title, content));
    }

    public WebCollapsiblePane addPane(Component title, Component content) {
        return this.addPane(this.panes.size(), title, content);
    }

    public WebCollapsiblePane addPane(int index, Component title, Component content) {
        WebCollapsiblePane pane = new WebCollapsiblePane("", content);
        pane.setTitleComponent(title);
        return this.addPane(index, pane);
    }

    protected WebCollapsiblePane addPane(int index, final WebCollapsiblePane pane) {
        pane.setAnimate(this.animate);
        pane.setExpandIcon(this.expandIcon);
        pane.setCollapseIcon(this.collapseIcon);
        if (!this.multiplySelectionAllowed && this.isAnySelected()) {
            pane.setExpanded(false, false);
        }
        pane.setStateChangeHandler(new DataProvider<Boolean>(){

            public Boolean provide() {
                if (!pane.isExpanded()) {
                    return true;
                }
                if (!WebAccordion.this.fillSpace) {
                    return true;
                }
                int selectionCount = WebAccordion.this.getSelectionCount();
                if (selectionCount > 1) {
                    return true;
                }
                return selectionCount == 1 && WebAccordion.this.lastExpanded != null && WebAccordion.this.lastExpanded != pane;
            }
        });
        CollapsiblePaneAdapter cpl = new CollapsiblePaneAdapter(){

            @Override
            public void expanding(WebCollapsiblePane pane) {
                WebAccordion.this.updateSelections(WebAccordion.this.panes.indexOf(pane), true);
            }

            @Override
            public void collapsing(WebCollapsiblePane pane) {
                if (WebAccordion.this.multiplySelectionAllowed || WebAccordion.this.getSelectionCount() == 0) {
                    WebAccordion.this.updateSelections(WebAccordion.this.panes.indexOf(pane), false);
                }
                WebAccordion.this.lastExpanded = pane;
            }
        };
        pane.addCollapsiblePaneListener(cpl);
        this.stateListeners.add(cpl);
        this.add(index, pane);
        this.panes.add(index, pane);
        this.updatePanesBorderStyling();
        this.fireSelectionChanged();
        return pane;
    }

    public void removePane(int index) {
        this.removePane(this.panes.get(index));
    }

    protected void removePane(WebCollapsiblePane pane) {
        int index = this.panes.indexOf(pane);
        if (index == -1) {
            return;
        }
        pane.setStateChangeHandler(null);
        pane.removeCollapsiblePaneListener(this.stateListeners.get(index));
        this.stateListeners.remove(index);
        this.remove(pane);
        this.panes.remove(index);
        if (pane == this.lastExpanded) {
            this.lastExpanded = null;
        }
        this.updatePanesBorderStyling();
    }

    public List<WebCollapsiblePane> getPanes() {
        return CollectionUtils.copy(this.panes);
    }

    public List<WebCollapsiblePane> getActualPanesList() {
        return this.panes;
    }

    public WebCollapsiblePane getPane(int index) {
        return this.panes.get(index);
    }

    protected void updatePanesBorderStyling() {
        boolean united = this.accordionStyle.equals((Object)AccordionStyle.united);
        boolean separated = this.accordionStyle.equals((Object)AccordionStyle.separated);
        boolean hor = this.orientation == 0;
        this.setUndecorated(!united);
        for (int i = 0; i < this.panes.size(); ++i) {
            WebCollapsiblePane pane = this.panes.get(i);
            pane.setTitlePanePostion(hor ? 2 : 1);
            if (separated) {
                pane.setShadeWidth(WebPanelStyle.shadeWidth);
                pane.setPaintSides(separated, separated, separated, separated);
                continue;
            }
            pane.setShadeWidth(0);
            pane.setPaintSides(!hor && i > 0, hor && i > 0, false, false);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isAnySelected() {
        for (WebCollapsiblePane pane : this.panes) {
            if (!pane.isExpanded()) continue;
            return true;
        }
        return false;
    }

    public int getFirstSelectedIndex() {
        for (WebCollapsiblePane pane : this.panes) {
            if (!pane.isExpanded()) continue;
            return this.panes.indexOf(pane);
        }
        return -1;
    }

    public int getSelectionCount() {
        int count = 0;
        for (WebCollapsiblePane pane : this.panes) {
            if (!pane.isExpanded()) continue;
            ++count;
        }
        return count;
    }

    public Icon getIconAt(int index) {
        return this.panes.get(index).getIcon();
    }

    public void setIconAt(int index, Icon icon) {
        this.panes.get(index).setIcon(icon);
    }

    public String getTitleAt(int index) {
        return this.panes.get(index).getTitle();
    }

    public void setTitleAt(int index, String title) {
        this.panes.get(index).setTitle(title);
    }

    public Component getTitleComponentAt(int index) {
        return this.panes.get(index).getTitleComponent();
    }

    public void setTitleComponentAt(int index, Component titleComponent) {
        this.panes.get(index).setTitleComponent(titleComponent);
    }

    public Component getContentAt(int index) {
        return this.panes.get(index).getContent();
    }

    public void setContentAt(int index, Component content) {
        this.panes.get(index).setContent(content);
    }

    public Insets getContentMarginAt(int index) {
        return this.panes.get(index).getContentMargin();
    }

    public void setContentMarginAt(int index, Insets margin) {
        this.panes.get(index).setContentMargin(margin);
    }

    public void setContentMarginAt(int index, int top, int left, int bottom, int right) {
        this.setContentMarginAt(index, new Insets(top, left, bottom, right));
    }

    public void setContentMarginAt(int index, int margin) {
        this.setContentMarginAt(index, margin, margin, margin, margin);
    }

    public List<WebCollapsiblePane> getSelectedPanes() {
        ArrayList<WebCollapsiblePane> selectedPanes = new ArrayList<WebCollapsiblePane>();
        for (WebCollapsiblePane pane : this.panes) {
            if (!pane.isExpanded()) continue;
            selectedPanes.add(pane);
        }
        return selectedPanes;
    }

    public void setSelectedPanes(List<WebCollapsiblePane> selectedPanes) {
        for (WebCollapsiblePane pane : this.panes) {
            pane.setExpanded(selectedPanes != null && selectedPanes.contains(pane));
        }
    }

    public List<Integer> getSelectedIndices() {
        ArrayList<Integer> selectedPanes = new ArrayList<Integer>();
        for (int i = 0; i < this.panes.size(); ++i) {
            if (!this.panes.get(i).isExpanded()) continue;
            selectedPanes.add(i);
        }
        return selectedPanes;
    }

    public void setSelectedIndices(List<Integer> indices) {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).setExpanded(indices != null && indices.contains(i));
        }
    }

    public List<AccordionListener> getAccordionListeners() {
        return CollectionUtils.copy(this.listeners);
    }

    public void setAccordionListeners(List<AccordionListener> listeners) {
        this.listeners = listeners;
    }

    public void addAccordionListener(AccordionListener listener) {
        this.listeners.add(listener);
    }

    public void removeAccordionListener(AccordionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectionChanged() {
        for (AccordionListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged();
        }
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((Component)this, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((Component)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((Component)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((Component)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((Component)this);
    }
}

