/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.TextureType;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class TexturePainter<E extends JComponent>
extends AbstractPainter<E> {
    protected TexturePaint paint = null;
    protected TextureType textureType = null;

    public TexturePainter(ImageIcon icon) {
        this(icon.getImage());
    }

    public TexturePainter(Image image) {
        this(ImageUtils.getBufferedImage((Image)image));
    }

    public TexturePainter(BufferedImage image) {
        this.updatePainter(image);
    }

    public TexturePainter(TextureType textureType) {
        this.setTextureType(textureType);
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public void setTextureType(TextureType textureType) {
        this.textureType = textureType;
        this.updatePainter(textureType == null ? null : textureType.getTexture());
    }

    public BufferedImage getImage() {
        return this.paint != null ? this.paint.getImage() : null;
    }

    public void setImage(BufferedImage image) {
        this.updatePainter(image);
    }

    protected void updatePainter(BufferedImage image) {
        this.paint = image != null ? new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight())) : null;
        this.repaint();
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.paint != null) {
            Rectangle r = ((JComponent)c).getVisibleRect().intersection(bounds);
            if (r.width > 0 && r.height > 0) {
                Object old = GraphicsUtils.setupImageQuality((Graphics2D)g2d);
                g2d.setPaint(this.paint);
                g2d.fillRect(r.x, r.y, r.width, r.height);
                GraphicsUtils.restoreImageQuality((Graphics2D)g2d, (Object)old);
            }
        }
    }
}

