/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.ninepatch;

import com.alee.extended.layout.TableLayout;
import com.alee.extended.ninepatch.NinePatchInfo;
import com.alee.extended.ninepatch.ZoomChangeListener;
import com.alee.global.StyleConstants;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.swing.MouseEventType;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NinePatchEditor
extends JComponent
implements SizeMethods<NinePatchEditor> {
    public static final Color STRETCH_GUIDELINES_COLOR = new Color(60, 150, 0);
    public static final Color STRETCH_COLOR = new Color(80, 150, 0, 100);
    public static final Color CONTENT_GUIDELINES_COLOR = new Color(80, 80, 80, 200);
    public static final Color CONTENT_COLOR = new Color(90, 90, 255, 100);
    public static final Color METRICS_BORDER = new Color(191, 191, 191);
    public static final Color METRICS_TOP = Color.WHITE;
    public static final Color METRICS_BOTTOM = new Color(229, 233, 238);
    public static final int RULER_LENGTH = 20;
    public static final int ADDITIONAL_SPACE = 80;
    public static final int SNAP = 3;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 32;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private final List<ZoomChangeListener> zoomChangeListeners = new ArrayList<ZoomChangeListener>(1);
    private final List<NinePatchInfo> history = new ArrayList<NinePatchInfo>();
    private int historyState = -1;
    private BufferedImage ninePatchImage = null;
    private NinePatchIcon ninePatchIcon = null;
    private boolean showGuideSpacing = true;
    private boolean showRuler = true;
    private boolean fillStretchAreas = true;
    private boolean fillContentArea = true;
    private boolean showRulerCursorPosition = true;
    private boolean showAreaCursorPosition = false;
    private int zoom = 5;
    private final WebScrollPane view;
    private boolean changed = false;
    private boolean someDragged = false;

    public NinePatchEditor() {
        SwingUtils.setOrientation(this);
        this.setFocusable(true);
        this.setLayout(new TableLayout(new double[][]{{20.0, -2.0, -1.0}, {20.0, -2.0, -1.0}}));
        this.setFont(new JLabel().getFont().deriveFont(10.0f));
        this.view = new WebScrollPane(this, false);
        NinePatchEditorMouseAdapter npema = new NinePatchEditorMouseAdapter();
        this.addMouseListener(npema);
        this.addMouseMotionListener(npema);
        this.addMouseWheelListener(npema);
    }

    public WebScrollPane getView() {
        return this.view;
    }

    public boolean isSomeDragged() {
        return this.someDragged;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = Math.max(1, Math.min(zoom, 32));
        this.revalidate();
        this.repaint();
        this.fireZoomChanged();
    }

    public boolean isFillStretchAreas() {
        return this.fillStretchAreas;
    }

    public void setFillStretchAreas(boolean fillStretchAreas) {
        this.fillStretchAreas = fillStretchAreas;
        this.repaint();
    }

    public boolean isFillContentArea() {
        return this.fillContentArea;
    }

    public void setFillContentArea(boolean fillContentArea) {
        this.fillContentArea = fillContentArea;
        this.repaint();
    }

    public boolean isShowRulerCursorPosition() {
        return this.showRulerCursorPosition;
    }

    public void setShowRulerCursorPosition(boolean showRulerCursorPosition) {
        this.showRulerCursorPosition = showRulerCursorPosition;
        this.repaint();
    }

    public boolean isShowAreaCursorPosition() {
        return this.showAreaCursorPosition;
    }

    public void setShowAreaCursorPosition(boolean showAreaCursorPosition) {
        this.showAreaCursorPosition = showAreaCursorPosition;
        this.repaint();
    }

    public boolean isShowGuideSpacing() {
        return this.showGuideSpacing;
    }

    public void setShowGuideSpacing(boolean showGuideSpacing) {
        this.showGuideSpacing = showGuideSpacing;
        this.repaint();
    }

    public boolean isShowRuler() {
        return this.showRuler;
    }

    public void setShowRuler(boolean showRuler) {
        this.showRuler = showRuler;
        this.repaint();
    }

    public BufferedImage getRawImage() {
        return this.ninePatchIcon != null ? this.ninePatchIcon.getRawImage() : null;
    }

    public BufferedImage getNinePatchImage() {
        if (this.ninePatchIcon != null) {
            this.assembleImage();
            return this.ninePatchImage;
        }
        return null;
    }

    public void setNinePatchImage(BufferedImage ninePatchImage) {
        if (this.isSomeDragged()) {
            return;
        }
        this.disassembleImage(ninePatchImage);
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.clearHistory();
        this.saveHistoryState();
        this.changed = false;
        this.fireStateChanged();
    }

    public void setNinePatchIcon(NinePatchIcon ninePatchIcon) {
        if (this.isSomeDragged()) {
            return;
        }
        this.ninePatchIcon = ninePatchIcon;
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.clearHistory();
        this.saveHistoryState();
        this.changed = false;
        this.fireStateChanged();
    }

    public void setNinePatchInfo(NinePatchInfo ninePatchInfo) {
        if (this.ninePatchIcon == null || ninePatchInfo == null || this.isSomeDragged() || this.getNinePatchInfo().equals(ninePatchInfo)) {
            return;
        }
        this.ninePatchIcon.setVerticalStretch(ninePatchInfo.getVerticalStretch());
        this.verifyVerticalStretchAreas();
        this.ninePatchIcon.setHorizontalStretch(ninePatchInfo.getHorizontalStretch());
        this.verifyHorizontalStretchAreas();
        this.ninePatchIcon.setMargin(ninePatchInfo.getMargin());
        this.verifyMargin();
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.saveHistoryState();
    }

    public NinePatchInfo getNinePatchInfo() {
        if (this.ninePatchIcon == null) {
            return null;
        }
        NinePatchInfo ninePatchInfo = new NinePatchInfo();
        ninePatchInfo.setImageSize(this.ninePatchIcon.getRealImageSize());
        ninePatchInfo.setHorizontalStretch(this.ninePatchIcon.getHorizontalStretch());
        ninePatchInfo.setVerticalStretch(this.ninePatchIcon.getVerticalStretch());
        ninePatchInfo.setMargin(this.ninePatchIcon.getMargin());
        return ninePatchInfo;
    }

    public NinePatchIcon getNinePatchIcon() {
        return this.ninePatchIcon;
    }

    public void undo() {
        if (!this.isSomeDragged() && this.historyState > 0) {
            --this.historyState;
            this.restoreHistoryState(this.history.get(this.historyState));
        }
    }

    public void redo() {
        if (!this.isSomeDragged() && this.historyState < this.history.size() - 1) {
            ++this.historyState;
            this.restoreHistoryState(this.history.get(this.historyState));
        }
    }

    private void restoreHistoryState(NinePatchInfo state) {
        if (!state.getImageSize().equals(this.ninePatchIcon.getRealImageSize())) {
            return;
        }
        this.ninePatchIcon.setMargin(SwingUtils.copy(state.getMargin()));
        this.ninePatchIcon.setHorizontalStretch(CollectionUtils.clone(state.getHorizontalStretch()));
        this.ninePatchIcon.setVerticalStretch(CollectionUtils.clone(state.getVerticalStretch()));
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.fireStateChanged();
        this.changed = this.historyState > 0;
    }

    private void saveHistoryState() {
        if (this.ninePatchIcon != null) {
            for (int i = this.history.size() - 1; i > this.historyState; --i) {
                this.history.remove(i);
            }
            NinePatchInfo info = new NinePatchInfo();
            info.setImageSize(this.ninePatchIcon.getRealImageSize());
            info.setMargin(SwingUtils.copy(this.ninePatchIcon.getMargin()));
            info.setHorizontalStretch(CollectionUtils.clone(this.ninePatchIcon.getHorizontalStretch()));
            info.setVerticalStretch(CollectionUtils.clone(this.ninePatchIcon.getVerticalStretch()));
            this.history.add(info);
            this.historyState = this.history.size() - 1;
            this.changed = true;
        }
    }

    private void clearHistory() {
        this.history.clear();
        this.historyState = -1;
    }

    private void validateIcon() {
    }

    private int getSnap() {
        return Math.max(3, this.zoom / 2);
    }

    private void verifyHorizontalStretchAreas() {
        boolean[] filled = this.getHorizontalFilledPixels();
        this.ninePatchIcon.setHorizontalStretch(NinePatchUtils.parseStretchIntervals(filled));
    }

    private boolean[] getHorizontalFilledPixels() {
        boolean[] filled = new boolean[this.getRawImage().getWidth()];
        for (NinePatchInterval npi : this.ninePatchIcon.getHorizontalStretch()) {
            for (int i = npi.getStart(); i <= npi.getEnd(); ++i) {
                if (npi.isPixel() || i >= filled.length) continue;
                filled[i] = true;
            }
        }
        return filled;
    }

    private void verifyVerticalStretchAreas() {
        boolean[] filled = this.getVerticalFilledPixels();
        this.ninePatchIcon.setVerticalStretch(NinePatchUtils.parseStretchIntervals(filled));
    }

    private boolean[] getVerticalFilledPixels() {
        boolean[] filled = new boolean[this.getRawImage().getHeight()];
        for (NinePatchInterval npi : this.ninePatchIcon.getVerticalStretch()) {
            for (int i = npi.getStart(); i <= npi.getEnd(); ++i) {
                if (npi.isPixel() || i >= filled.length) continue;
                filled[i] = true;
            }
        }
        return filled;
    }

    private void verifyMargin() {
        int maxHmargin;
        Insets margin = this.ninePatchIcon.getMargin();
        int maxVmargin = this.getRawImage().getHeight() - 1;
        if (margin.top > maxVmargin) {
            margin.top = maxVmargin;
        }
        if (margin.bottom + margin.top > maxVmargin) {
            margin.bottom = maxVmargin - margin.top;
        }
        if (margin.left > (maxHmargin = this.getRawImage().getWidth() - 1)) {
            margin.left = maxHmargin;
        }
        if (margin.right + margin.left > maxHmargin) {
            margin.right = maxHmargin - margin.left;
        }
    }

    private void disassembleImage(BufferedImage ninePatchImage) {
        try {
            this.ninePatchIcon = new NinePatchIcon(ninePatchImage);
            this.ninePatchImage = ninePatchImage;
        }
        catch (IllegalArgumentException e) {
            BufferedImage fixedImage = ImageUtils.createCompatibleImage((int)(ninePatchImage.getWidth() + 2), (int)(ninePatchImage.getHeight() + 2), (int)3);
            Graphics2D g2d = fixedImage.createGraphics();
            g2d.drawImage((Image)ninePatchImage, 1, 1, null);
            g2d.setPaint(Color.BLACK);
            g2d.drawLine(1, 0, fixedImage.getWidth() - 2, 0);
            g2d.drawLine(0, 1, 0, fixedImage.getHeight() - 2);
            g2d.dispose();
            this.ninePatchIcon = new NinePatchIcon(fixedImage);
            this.ninePatchImage = fixedImage;
        }
    }

    private void assembleImage() {
        int i;
        BufferedImage rawImage = this.getRawImage();
        this.ninePatchImage = ImageUtils.createCompatibleImage((int)(rawImage.getWidth() + 2), (int)(rawImage.getHeight() + 2), (int)3);
        Graphics2D g2d = this.ninePatchImage.createGraphics();
        g2d.drawImage((Image)rawImage, 1, 1, null);
        g2d.dispose();
        int rgb = Color.BLACK.getRGB();
        boolean[] hf = this.getHorizontalFilledPixels();
        for (int i2 = 0; i2 < rawImage.getWidth(); ++i2) {
            if (!hf[i2]) continue;
            this.ninePatchImage.setRGB(i2 + 1, 0, rgb);
        }
        boolean[] vf = this.getVerticalFilledPixels();
        for (int i3 = 0; i3 < rawImage.getHeight(); ++i3) {
            if (!vf[i3]) continue;
            this.ninePatchImage.setRGB(0, i3 + 1, rgb);
        }
        Insets margin = this.ninePatchIcon.getMargin();
        for (i = margin.left; i < rawImage.getWidth() - margin.right; ++i) {
            this.ninePatchImage.setRGB(i + 1, this.ninePatchImage.getHeight() - 1, rgb);
        }
        for (i = margin.top; i < rawImage.getHeight() - margin.bottom; ++i) {
            this.ninePatchImage.setRGB(this.ninePatchImage.getWidth() - 1, i + 1, rgb);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.ninePatchIcon != null) {
            Graphics2D g2d = (Graphics2D)g;
            FontMetrics fm = g2d.getFontMetrics();
            BufferedImage image = this.getRawImage();
            int cw = this.getWidth();
            int ch = this.getHeight();
            int iw = image.getWidth() * this.zoom;
            int ih = image.getHeight() * this.zoom;
            Insets margin = this.ninePatchIcon.getMargin();
            int imageStartX = (cw + (this.showRuler ? 20 : 0)) / 2 - iw / 2;
            int imageStartY = (ch + (this.showRuler ? 20 : 0)) / 2 - ih / 2;
            Stroke stroke = g2d.getStroke();
            LafUtils.drawAlphaLayer(g2d, imageStartX, imageStartY, iw, ih);
            g2d.setPaint(Color.DARK_GRAY);
            g2d.drawRect(imageStartX, imageStartY, iw, ih);
            g.drawImage(image, imageStartX, imageStartY, iw, ih, null);
            g2d.setStroke(StyleConstants.guidelinesStroke);
            for (NinePatchInterval npi : this.ninePatchIcon.getHorizontalStretch()) {
                if (npi.isPixel()) continue;
                if (this.fillStretchAreas) {
                    g2d.setPaint(STRETCH_COLOR);
                    g2d.fillRect(imageStartX + npi.getStart() * this.zoom, imageStartY, (npi.getEnd() - npi.getStart() + 1) * this.zoom, ih);
                }
                g2d.setPaint(STRETCH_GUIDELINES_COLOR);
                g2d.drawLine(imageStartX + npi.getStart() * this.zoom, 0, imageStartX + npi.getStart() * this.zoom, imageStartY + ih - 1);
                g2d.drawLine(imageStartX + (npi.getEnd() + 1) * this.zoom, 0, imageStartX + (npi.getEnd() + 1) * this.zoom, imageStartY + ih - 1);
                g2d.setPaint(Color.BLACK);
                g2d.fillRect(imageStartX + npi.getStart() * this.zoom + 1, imageStartY - this.zoom, (npi.getEnd() - npi.getStart() + 1) * this.zoom - 1, this.zoom);
            }
            for (NinePatchInterval npi : this.ninePatchIcon.getVerticalStretch()) {
                if (npi.isPixel()) continue;
                if (this.fillStretchAreas) {
                    g2d.setPaint(STRETCH_COLOR);
                    g2d.fillRect(imageStartX, imageStartY + npi.getStart() * this.zoom, iw, (npi.getEnd() - npi.getStart() + 1) * this.zoom);
                }
                g2d.setPaint(STRETCH_GUIDELINES_COLOR);
                g2d.drawLine(0, imageStartY + npi.getStart() * this.zoom, imageStartX + iw - 1, imageStartY + npi.getStart() * this.zoom);
                g2d.drawLine(0, imageStartY + (npi.getEnd() + 1) * this.zoom, imageStartX + iw - 1, imageStartY + (npi.getEnd() + 1) * this.zoom);
                g2d.setPaint(Color.BLACK);
                g2d.fillRect(imageStartX - this.zoom, imageStartY + npi.getStart() * this.zoom + 1, this.zoom, (npi.getEnd() - npi.getStart() + 1) * this.zoom - 1);
            }
            int csx = this.getContentStartX(imageStartX, margin);
            int cex = this.getContentEndX(imageStartX, iw, margin);
            int csy = this.getContentStartY(imageStartY, margin);
            int cey = this.getContentEndY(imageStartY, ih, margin);
            if (this.fillContentArea) {
                g2d.setPaint(CONTENT_COLOR);
                g2d.fillRect(csx + 1, csy + 1, iw - (margin.left + margin.right) * this.zoom - 1, ih - (margin.top + margin.bottom) * this.zoom - 1);
            }
            g2d.setPaint(CONTENT_GUIDELINES_COLOR);
            g2d.drawLine(csx, imageStartY, csx, ch);
            g2d.drawLine(cex, imageStartY, cex, ch);
            g2d.drawLine(imageStartX, csy, cw, csy);
            g2d.drawLine(imageStartX, cey, cw, cey);
            g2d.setPaint(Color.BLACK);
            g2d.fillRect(imageStartX + iw + 1, csy + 1, this.zoom, cey - csy - 1);
            g2d.fillRect(csx + 1, imageStartY + ih + 1, cex - csx - 1, this.zoom);
            g2d.setStroke(stroke);
            if (this.showGuideSpacing) {
                g2d.setPaint(Color.BLACK);
                List<Integer> horizontalGuides = this.getHorizontalGuides();
                for (int i = 0; i < horizontalGuides.size() - 1; ++i) {
                    Integer guide = horizontalGuides.get(i);
                    Integer nextGuide = horizontalGuides.get(i + 1);
                    Integer x1 = imageStartX + guide * this.zoom;
                    Integer x2 = imageStartX + nextGuide * this.zoom;
                    int y1 = imageStartY - this.zoom - 10;
                    int y2 = imageStartY - this.zoom - 7;
                    g2d.drawLine(x1, y1, x2, y1);
                    g2d.drawLine(x1, y1, x1, y2);
                    g2d.drawLine(x2, y1, x2, y2);
                    String px = "" + (nextGuide - guide);
                    g2d.drawString(px, (x1 + x2) / 2 + LafUtils.getTextCenterShearX(fm, px), imageStartY - this.zoom - 15);
                }
                List<Integer> verticalGuides = this.getVerticalGuides();
                for (int i = 0; i < verticalGuides.size() - 1; ++i) {
                    Integer guide = verticalGuides.get(i);
                    Integer nextGuide = verticalGuides.get(i + 1);
                    Integer y1 = imageStartY + guide * this.zoom;
                    Integer y2 = imageStartY + nextGuide * this.zoom;
                    int x1 = imageStartX - this.zoom - 10;
                    int x2 = imageStartX - this.zoom - 7;
                    g2d.drawLine(x1, y1, x1, y2);
                    g2d.drawLine(x1, y1, x2, y1);
                    g2d.drawLine(x1, y2, x2, y2);
                    String px = "" + (nextGuide - guide);
                    g2d.drawString(px, x1 - fm.stringWidth(px) - 5, (y1 + y2) / 2 + LafUtils.getTextCenterShearY(fm));
                }
            }
            if (this.showRuler) {
                this.drawRuler(g2d, new Point(imageStartX - 1, imageStartY - 1), imageStartX, imageStartY);
            }
        }
    }

    private void drawRuler(Graphics2D g2d, Point zp, int imageStartX, int imageStartY) {
        String number;
        int i;
        int j;
        Rectangle vr = this.getVisibleRect();
        int minorTick = this.getMinorTicks();
        int majorTick = this.getMajorTicks();
        int ppu = this.zoom;
        g2d.setPaint(new GradientPaint(vr.x, vr.y, METRICS_TOP, vr.x, vr.y + 20, METRICS_BOTTOM));
        g2d.fillRect(vr.x, vr.y, vr.width, 20);
        g2d.setPaint(new GradientPaint(vr.x, vr.y, METRICS_TOP, vr.x + 20, vr.y, METRICS_BOTTOM));
        g2d.fillRect(vr.x, vr.y, 20, vr.height);
        if (this.showRulerCursorPosition || this.showAreaCursorPosition) {
            Point mouse = SwingUtils.getMousePoint(this);
            if (mouse.x > vr.x + 20 && mouse.x < vr.x + vr.width && mouse.y > vr.y + 20 && mouse.y < vr.y + vr.height) {
                int px = (mouse.x - imageStartX) / this.zoom - (mouse.x >= imageStartX ? 0 : 1);
                int py = (mouse.y - imageStartY) / this.zoom - (mouse.y >= imageStartY ? 0 : 1);
                Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(0.5f));
                if (this.showRulerCursorPosition) {
                    g2d.setPaint(Color.RED);
                    g2d.fillRect(imageStartX + px * this.zoom, vr.y, this.zoom, 20);
                    g2d.fillRect(vr.x, imageStartY + py * this.zoom, 20, this.zoom);
                }
                if (this.showAreaCursorPosition) {
                    Shape oldClip = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)new Rectangle(vr.x + 20, vr.y + 20, vr.width - 20, vr.height - 20), (boolean)this.showAreaCursorPosition);
                    g2d.setPaint(Color.RED);
                    g2d.fillRect(imageStartX + px * this.zoom, vr.y, this.zoom, vr.height);
                    g2d.fillRect(vr.x, imageStartY + py * this.zoom, vr.width, this.zoom);
                    GraphicsUtils.restoreClip((Graphics)g2d, (Shape)oldClip);
                }
                GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc);
            }
        }
        g2d.setPaint(Color.BLACK);
        for (j = i = vr.x + (zp.x - vr.x) % minorTick; j <= vr.x + vr.width; j += minorTick) {
            g2d.drawLine(j, vr.y + 20 - 6, j, vr.y + 20);
        }
        for (j = i = vr.x + (zp.x - vr.x) % majorTick; j <= vr.x + vr.width; j += majorTick) {
            g2d.drawLine(j, vr.y + 20 - 15, j, vr.y + 20);
            number = "" + (j - zp.x) / ppu;
            g2d.drawString(number, j + 2, vr.y + 20 - 10);
        }
        g2d.setPaint(Color.BLACK);
        g2d.drawLine(vr.x + 20, vr.y + 20, vr.x + vr.width, vr.y + 20);
        for (j = i = vr.y + (zp.y - vr.y) % minorTick; j <= vr.y + vr.height; j += minorTick) {
            g2d.drawLine(vr.x + 20 - 6, j, vr.x + 20, j);
        }
        for (j = i = vr.y + (zp.y - vr.y) % majorTick; j <= vr.y + vr.height; j += majorTick) {
            g2d.drawLine(vr.x + 20 - 15, j, vr.x + 20, j);
            number = "" + (j - zp.y) / ppu;
            g2d.rotate(Math.toRadians(-90.0));
            g2d.drawString(number, 1 - j - this.getFontMetrics(this.getFont()).stringWidth(number) - 2, vr.x + 20 - 10);
            g2d.rotate(Math.toRadians(90.0));
        }
        g2d.setPaint(Color.BLACK);
        g2d.drawLine(vr.x + 20, vr.y + 20, vr.x + 20, vr.y + vr.height);
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(vr.x, vr.y, 20, 20);
        String unitsName = this.zoom + "x";
        Point ts = LafUtils.getTextCenterShear(g2d.getFontMetrics(), unitsName);
        g2d.setPaint(Color.DARK_GRAY);
        g2d.drawString(unitsName, vr.x + 10 + ts.x, vr.y + 10 + ts.y);
        g2d.setPaint(Color.BLACK);
        g2d.drawLine(vr.x + 20, vr.y, vr.x + 20, vr.y + 20);
        g2d.drawLine(vr.x, vr.y + 20, vr.x + 20, vr.y + 20);
    }

    private int getMajorTicks() {
        switch (this.zoom) {
            case 1: {
                return this.zoom * 50;
            }
            case 2: {
                return this.zoom * 20;
            }
            case 3: {
                return this.zoom * 20;
            }
            case 4: {
                return this.zoom * 10;
            }
            case 5: {
                return this.zoom * 10;
            }
            case 6: {
                return this.zoom * 10;
            }
        }
        return this.zoom * 5;
    }

    private int getMinorTicks() {
        switch (this.zoom) {
            case 1: {
                return this.zoom * 5;
            }
            case 2: {
                return this.zoom * 5;
            }
            case 3: {
                return this.zoom * 2;
            }
            case 4: {
                return this.zoom * 2;
            }
            case 5: {
                return this.zoom;
            }
            case 6: {
                return this.zoom;
            }
        }
        return this.zoom;
    }

    private List<Integer> getHorizontalGuides() {
        ArrayList<Integer> horizontalGuides = new ArrayList<Integer>();
        for (NinePatchInterval npi : this.ninePatchIcon.getHorizontalStretch()) {
            if (!horizontalGuides.contains(npi.getStart())) {
                horizontalGuides.add(npi.getStart());
            }
            if (horizontalGuides.contains(npi.getEnd() + 1)) continue;
            horizontalGuides.add(npi.getEnd() + 1);
        }
        Insets margin = this.ninePatchIcon.getMargin();
        if (!horizontalGuides.contains(margin.left)) {
            horizontalGuides.add(margin.left);
        }
        if (!horizontalGuides.contains(this.getRawImage().getWidth() - margin.right)) {
            horizontalGuides.add(this.getRawImage().getWidth() - margin.right);
        }
        Collections.sort(horizontalGuides);
        return horizontalGuides;
    }

    private List<Integer> getVerticalGuides() {
        ArrayList<Integer> verticalGuides = new ArrayList<Integer>();
        for (NinePatchInterval npi : this.ninePatchIcon.getVerticalStretch()) {
            if (!verticalGuides.contains(npi.getStart())) {
                verticalGuides.add(npi.getStart());
            }
            if (verticalGuides.contains(npi.getEnd() + 1)) continue;
            verticalGuides.add(npi.getEnd() + 1);
        }
        Insets margin = this.ninePatchIcon.getMargin();
        if (!verticalGuides.contains(margin.top)) {
            verticalGuides.add(margin.top);
        }
        if (!verticalGuides.contains(this.getRawImage().getHeight() - margin.bottom)) {
            verticalGuides.add(this.getRawImage().getHeight() - margin.bottom);
        }
        Collections.sort(verticalGuides);
        return verticalGuides;
    }

    private int getContentStartX(int imageStartX, Insets margin) {
        return imageStartX + margin.left * this.zoom;
    }

    private int getContentEndX(int imageStartX, int iw, Insets margin) {
        return imageStartX + iw - margin.right * this.zoom;
    }

    private int getContentStartY(int imageStartY, Insets margin) {
        return imageStartY + margin.top * this.zoom;
    }

    private int getContentEndY(int imageStartY, int ih, Insets margin) {
        return imageStartY + ih - margin.bottom * this.zoom;
    }

    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : CollectionUtils.copy(this.changeListeners)) {
            listener.stateChanged(changeEvent);
        }
    }

    public List<ZoomChangeListener> getZoomChangeListeners() {
        return this.zoomChangeListeners;
    }

    public void addZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        this.zoomChangeListeners.add(zoomChangeListener);
    }

    public void removeZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        this.zoomChangeListeners.add(zoomChangeListener);
    }

    private void fireZoomChanged() {
        for (ZoomChangeListener listener : CollectionUtils.copy(this.zoomChangeListeners)) {
            listener.zoomChanged();
        }
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public NinePatchEditor setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public NinePatchEditor setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public NinePatchEditor setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public NinePatchEditor setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, this.getActualPreferredSize());
    }

    public Dimension getActualPreferredSize() {
        boolean imageExists = this.ninePatchImage != null;
        int iw = imageExists ? (this.ninePatchImage.getWidth() + 2) * this.zoom : 400;
        int ih = imageExists ? (this.ninePatchImage.getHeight() + 2) * this.zoom : 400;
        return new Dimension(20 + iw + 80, 20 + ih + 80);
    }

    private class NinePatchEditorMouseAdapter
    extends MouseAdapter {
        private boolean cameraDragged = false;
        private boolean hContentAreaDragged = false;
        private boolean hContentStartDragged = false;
        private boolean hContentEndDragged = false;
        private boolean vContentAreaDragged = false;
        private boolean vContentStartDragged = false;
        private boolean vContentEndDragged = false;
        private boolean contentAreaDragged = false;
        private boolean hStretchAreaDragged = false;
        private boolean hStretchStartDragged = false;
        private boolean hStretchEndDragged = false;
        private boolean vStretchAreaDragged = false;
        private boolean vStretchStartDragged = false;
        private boolean vStretchEndDragged = false;
        private boolean addingHorizontalStretch = false;
        private boolean addingVerticalStretch = false;
        private boolean removingHorizontalStretch = false;
        private boolean removingVerticalStretch = false;
        private int startX = -1;
        private int startY = -1;
        private Rectangle startRect = null;
        private Insets startMargin = null;
        private NinePatchInterval changedInterval = null;
        private NinePatchInterval removedInterval = null;

        private NinePatchEditorMouseAdapter() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.mouseEvent(e, MouseEventType.mouseWheelMoved);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseEvent(e, MouseEventType.mousePressed);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseEvent(e, MouseEventType.mouseDragged);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseEvent(e, MouseEventType.mouseReleased);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseEvent(e, MouseEventType.mouseEntered);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseEvent(e, MouseEventType.mouseExited);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseEvent(e, MouseEventType.mouseMoved);
        }

        private void mouseEvent(MouseEvent e, MouseEventType mouseEventType) {
            if (this.processMouseEvent(e, mouseEventType)) {
                NinePatchEditor.this.repaint();
            }
        }

        private boolean processMouseEvent(MouseEvent e, MouseEventType mouseEventType) {
            BufferedImage image = NinePatchEditor.this.getRawImage();
            if (image == null) {
                return false;
            }
            int x = e.getX();
            int y = e.getY();
            int cw = NinePatchEditor.this.getWidth();
            int ch = NinePatchEditor.this.getHeight();
            int iw = image.getWidth() * NinePatchEditor.this.zoom;
            int ih = image.getHeight() * NinePatchEditor.this.zoom;
            Insets margin = NinePatchEditor.this.ninePatchIcon.getMargin();
            int imageStartX = (cw + (NinePatchEditor.this.showRuler ? 20 : 0)) / 2 - iw / 2;
            int imageStartY = (ch + (NinePatchEditor.this.showRuler ? 20 : 0)) / 2 - ih / 2;
            boolean repaintRequired = false;
            int contentStartX = NinePatchEditor.this.getContentStartX(imageStartX, margin);
            int contentEndX = NinePatchEditor.this.getContentEndX(imageStartX, iw, margin);
            int contentStartY = NinePatchEditor.this.getContentStartY(imageStartY, margin);
            int contentEndY = NinePatchEditor.this.getContentEndY(imageStartY, ih, margin);
            if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                NinePatchEditor.this.requestFocusInWindow();
            }
            if ((NinePatchEditor.this.showRulerCursorPosition || NinePatchEditor.this.showAreaCursorPosition) && mouseEventType.equals((Object)MouseEventType.mouseMoved) || mouseEventType.equals((Object)MouseEventType.mouseDragged) || mouseEventType.equals((Object)MouseEventType.mouseEntered) || mouseEventType.equals((Object)MouseEventType.mouseExited)) {
                repaintRequired = true;
            }
            if (!NinePatchEditor.this.someDragged && mouseEventType.equals((Object)MouseEventType.mouseWheelMoved) && (SwingUtils.isCtrl(e) || SwingUtils.isAlt(e))) {
                MouseWheelEvent mwe = (MouseWheelEvent)e;
                NinePatchEditor.this.setZoom(NinePatchEditor.this.getZoom() - mwe.getWheelRotation());
                NinePatchEditor.this.setCursor(Cursor.getDefaultCursor());
                return repaintRequired;
            }
            if (SwingUtilities.isMiddleMouseButton(e) && (this.cameraDragged || !NinePatchEditor.this.someDragged)) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.cameraDragged = true;
                    this.startRect = NinePatchEditor.this.getVisibleRect();
                    e = SwingUtilities.convertMouseEvent(NinePatchEditor.this, e, NinePatchEditor.this.view);
                    this.startX = e.getX();
                    this.startY = e.getY();
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (this.cameraDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    e = SwingUtilities.convertMouseEvent(NinePatchEditor.this, e, NinePatchEditor.this.view);
                    NinePatchEditor.this.view.getWebHorizontalScrollBar().setValue(this.startRect.x - (e.getX() - this.startX));
                    NinePatchEditor.this.view.getWebVerticalScrollBar().setValue(this.startRect.y - (e.getY() - this.startY));
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (this.cameraDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.cameraDragged = false;
                    NinePatchEditor.this.setCursor(Cursor.getDefaultCursor());
                }
                return repaintRequired;
            }
            if (NinePatchEditor.this.ninePatchIcon == null || NinePatchEditor.this.ninePatchImage == null) {
                return repaintRequired;
            }
            if (this.hContentAreaDragged || !NinePatchEditor.this.someDragged && new Rectangle(contentStartX, imageStartY + ih, contentEndX - contentStartX, NinePatchEditor.this.zoom).contains(x, y)) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hContentAreaDragged = true;
                    this.startX = x;
                    this.startMargin = margin;
                } else if (this.hContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int right;
                    int changeX = (x - this.startX) / NinePatchEditor.this.zoom;
                    int left = this.startMargin.left + changeX;
                    if (left < 0) {
                        left = 0;
                    }
                    if (left > image.getWidth() - 1) {
                        left = image.getWidth() - 1;
                    }
                    if ((right = this.startMargin.right - changeX) < 0) {
                        right = 0;
                    }
                    if (right > image.getWidth() - 1) {
                        right = image.getWidth() - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(this.startMargin.top, left, this.startMargin.bottom, right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.hContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hContentAreaDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                return repaintRequired;
            }
            if (this.vContentAreaDragged || !NinePatchEditor.this.someDragged && new Rectangle(imageStartX + iw, contentStartY, NinePatchEditor.this.zoom, contentEndY - contentStartY).contains(x, y)) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vContentAreaDragged = true;
                    this.startY = y;
                    this.startMargin = margin;
                } else if (this.vContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int bottom;
                    int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                    int top = this.startMargin.top + changeY;
                    if (top < 0) {
                        top = 0;
                    }
                    if (top > image.getHeight() - 1) {
                        top = image.getHeight() - 1;
                    }
                    if ((bottom = this.startMargin.bottom - changeY) < 0) {
                        bottom = 0;
                    }
                    if (bottom > image.getHeight() - 1) {
                        bottom = image.getHeight() - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(top, this.startMargin.left, bottom, this.startMargin.right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.vContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vContentAreaDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                return repaintRequired;
            }
            if (this.hContentStartDragged || !NinePatchEditor.this.someDragged && y >= imageStartY && contentStartX + NinePatchEditor.this.getSnap() >= x && contentStartX - NinePatchEditor.this.getSnap() <= x) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hContentStartDragged = true;
                    this.startX = x;
                    this.startMargin = margin;
                } else if (this.hContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int changeX = (x - this.startX) / NinePatchEditor.this.zoom;
                    int left = this.startMargin.left + changeX;
                    if (left < 0) {
                        left = 0;
                    }
                    if (left > image.getWidth() - this.startMargin.right - 1) {
                        left = image.getWidth() - this.startMargin.right - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(this.startMargin.top, left, this.startMargin.bottom, this.startMargin.right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.hContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hContentStartDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                return repaintRequired;
            }
            if (this.hContentEndDragged || !NinePatchEditor.this.someDragged && y >= imageStartY && contentEndX + NinePatchEditor.this.getSnap() >= x && contentEndX - NinePatchEditor.this.getSnap() <= x) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hContentEndDragged = true;
                    this.startX = x;
                    this.startMargin = margin;
                } else if (this.hContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int changeX = (x - this.startX) / NinePatchEditor.this.zoom;
                    int right = this.startMargin.right - changeX;
                    if (right < 0) {
                        right = 0;
                    }
                    if (right > image.getWidth() - this.startMargin.left - 1) {
                        right = image.getWidth() - this.startMargin.left - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(this.startMargin.top, this.startMargin.left, this.startMargin.bottom, right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.hContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hContentEndDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                return repaintRequired;
            }
            if (this.vContentStartDragged || !NinePatchEditor.this.someDragged && x >= imageStartX && contentStartY + NinePatchEditor.this.getSnap() >= y && contentStartY - NinePatchEditor.this.getSnap() <= y) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vContentStartDragged = true;
                    this.startY = y;
                    this.startMargin = margin;
                } else if (this.vContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                    int top = this.startMargin.top + changeY;
                    if (top < 0) {
                        top = 0;
                    }
                    if (top > image.getHeight() - this.startMargin.bottom - 1) {
                        top = image.getHeight() - this.startMargin.bottom - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(top, this.startMargin.left, this.startMargin.bottom, this.startMargin.right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.vContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vContentStartDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                return repaintRequired;
            }
            if (this.vContentEndDragged || !NinePatchEditor.this.someDragged && x >= imageStartX && contentEndY + NinePatchEditor.this.getSnap() >= y && contentEndY - NinePatchEditor.this.getSnap() <= y) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vContentEndDragged = true;
                    this.startY = y;
                    this.startMargin = margin;
                } else if (this.vContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                    int bottom = this.startMargin.bottom - changeY;
                    if (bottom < 0) {
                        bottom = 0;
                    }
                    if (bottom > image.getHeight() - this.startMargin.top - 1) {
                        bottom = image.getHeight() - this.startMargin.top - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(this.startMargin.top, this.startMargin.left, bottom, this.startMargin.right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.vContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vContentEndDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                return repaintRequired;
            }
            for (NinePatchInterval npi : NinePatchEditor.this.ninePatchIcon.getHorizontalStretch()) {
                if (npi.isPixel()) continue;
                if (this.hStretchAreaDragged && this.changedInterval.isSame(npi) || !NinePatchEditor.this.someDragged && new Rectangle(imageStartX + npi.getStart() * NinePatchEditor.this.zoom, imageStartY - NinePatchEditor.this.zoom, (npi.getEnd() - npi.getStart() + 1) * NinePatchEditor.this.zoom, NinePatchEditor.this.zoom + (NinePatchEditor.this.fillStretchAreas ? ih : 0)).contains(x, y)) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.hStretchAreaDragged = true;
                        this.startX = x;
                        this.changedInterval = npi.clone();
                    } else if (this.hStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int end;
                        int changeX = (x - this.startX) / NinePatchEditor.this.zoom;
                        int start = this.changedInterval.getStart() + changeX;
                        if (start < 0) {
                            start = 0;
                        }
                        if (start > image.getWidth() - 1) {
                            start = image.getWidth() - 1;
                        }
                        if ((end = this.changedInterval.getEnd() + changeX) < 0) {
                            end = 0;
                        }
                        if (end > image.getWidth() - 1) {
                            end = image.getWidth() - 1;
                        }
                        npi.setStart(start);
                        npi.setEnd(end);
                        repaintRequired = true;
                    } else if (this.hStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.hStretchAreaDragged = false;
                        NinePatchEditor.this.verifyHorizontalStretchAreas();
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                    return repaintRequired;
                }
                if (y > imageStartY + ih) continue;
                if (this.hStretchStartDragged && this.changedInterval.isSame(npi) || !NinePatchEditor.this.someDragged && imageStartX + npi.getStart() * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() <= x && x <= imageStartX + npi.getStart() * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap()) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.hStretchStartDragged = true;
                        this.startX = x;
                        this.changedInterval = npi.clone();
                    } else if (this.hStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int changeX = (x - this.startX) / NinePatchEditor.this.zoom;
                        int start = this.changedInterval.getStart() + changeX;
                        if (start < 0) {
                            start = 0;
                        }
                        if (start > this.changedInterval.getEnd()) {
                            start = this.changedInterval.getEnd();
                        }
                        npi.setStart(start);
                        repaintRequired = true;
                    } else if (this.hStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.hStretchStartDragged = false;
                        NinePatchEditor.this.verifyHorizontalStretchAreas();
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                    return repaintRequired;
                }
                if ((!this.hStretchEndDragged || !this.changedInterval.isSame(npi)) && (NinePatchEditor.this.someDragged || imageStartX + (npi.getEnd() + 1) * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() > x || x > imageStartX + (npi.getEnd() + 1) * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap())) continue;
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hStretchEndDragged = true;
                    this.startX = x;
                    this.changedInterval = npi.clone();
                } else if (this.hStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int changeX = (x - this.startX) / NinePatchEditor.this.zoom;
                    int end = this.changedInterval.getEnd() + changeX;
                    if (end < this.changedInterval.getStart()) {
                        end = this.changedInterval.getStart();
                    }
                    if (end > image.getWidth() - 1) {
                        end = image.getWidth() - 1;
                    }
                    npi.setEnd(end);
                    repaintRequired = true;
                } else if (this.hStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hStretchEndDragged = false;
                    NinePatchEditor.this.verifyHorizontalStretchAreas();
                    repaintRequired = true;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                return repaintRequired;
            }
            for (NinePatchInterval npi : NinePatchEditor.this.ninePatchIcon.getVerticalStretch()) {
                if (npi.isPixel()) continue;
                if (this.vStretchAreaDragged && this.changedInterval.isSame(npi) || !NinePatchEditor.this.someDragged && new Rectangle(imageStartX - NinePatchEditor.this.zoom, imageStartY + npi.getStart() * NinePatchEditor.this.zoom, NinePatchEditor.this.zoom + (NinePatchEditor.this.fillStretchAreas ? iw : 0), (npi.getEnd() - npi.getStart() + 1) * NinePatchEditor.this.zoom).contains(x, y)) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.vStretchAreaDragged = true;
                        this.startY = y;
                        this.changedInterval = npi.clone();
                    } else if (this.vStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int end;
                        int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                        int start = this.changedInterval.getStart() + changeY;
                        if (start < 0) {
                            start = 0;
                        }
                        if (start > image.getHeight() - 1) {
                            start = image.getHeight() - 1;
                        }
                        if ((end = this.changedInterval.getEnd() + changeY) < 0) {
                            end = 0;
                        }
                        if (end > image.getHeight() - 1) {
                            end = image.getHeight() - 1;
                        }
                        npi.setStart(start);
                        npi.setEnd(end);
                        repaintRequired = true;
                    } else if (this.vStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.vStretchAreaDragged = false;
                        NinePatchEditor.this.verifyVerticalStretchAreas();
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                    return repaintRequired;
                }
                if (x > imageStartX + iw) continue;
                if (this.vStretchStartDragged && this.changedInterval.isSame(npi) || !NinePatchEditor.this.someDragged && imageStartY + npi.getStart() * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() <= y && y <= imageStartY + npi.getStart() * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap()) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.vStretchStartDragged = true;
                        this.startY = y;
                        this.changedInterval = npi.clone();
                    } else if (this.vStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                        int start = this.changedInterval.getStart() + changeY;
                        if (start < 0) {
                            start = 0;
                        }
                        if (start > this.changedInterval.getEnd()) {
                            start = this.changedInterval.getEnd();
                        }
                        npi.setStart(start);
                        repaintRequired = true;
                    } else if (this.vStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.vStretchStartDragged = false;
                        NinePatchEditor.this.verifyVerticalStretchAreas();
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                    return repaintRequired;
                }
                if ((!this.vStretchEndDragged || !this.changedInterval.isSame(npi)) && (NinePatchEditor.this.someDragged || imageStartY + (npi.getEnd() + 1) * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() > y || y > imageStartY + (npi.getEnd() + 1) * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap())) continue;
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vStretchEndDragged = true;
                    this.startY = y;
                    this.changedInterval = npi.clone();
                } else if (this.vStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                    int end = this.changedInterval.getEnd() + changeY;
                    if (end < this.changedInterval.getStart()) {
                        end = this.changedInterval.getStart();
                    }
                    if (end > image.getHeight() - 1) {
                        end = image.getHeight() - 1;
                    }
                    npi.setEnd(end);
                    repaintRequired = true;
                } else if (this.vStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vStretchEndDragged = false;
                    NinePatchEditor.this.verifyVerticalStretchAreas();
                    repaintRequired = true;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                return repaintRequired;
            }
            if (NinePatchEditor.this.fillContentArea && (this.contentAreaDragged || !NinePatchEditor.this.someDragged && new Rectangle(contentStartX, contentStartY, contentEndX - contentStartX, contentEndY - contentStartY).contains(x, y))) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.contentAreaDragged = true;
                    this.startX = x;
                    this.startY = y;
                    this.startMargin = margin;
                } else if (this.contentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int right;
                    int changeX;
                    int left;
                    int bottom;
                    int changeY = (y - this.startY) / NinePatchEditor.this.zoom;
                    int top = this.startMargin.top + changeY;
                    if (top < 0) {
                        top = 0;
                    }
                    if (top > image.getHeight() - 1) {
                        top = image.getHeight() - 1;
                    }
                    if ((bottom = this.startMargin.bottom - changeY) < 0) {
                        bottom = 0;
                    }
                    if (bottom > image.getHeight() - 1) {
                        bottom = image.getHeight() - 1;
                    }
                    if ((left = this.startMargin.left + (changeX = (x - this.startX) / NinePatchEditor.this.zoom)) < 0) {
                        left = 0;
                    }
                    if (left > image.getWidth() - 1) {
                        left = image.getWidth() - 1;
                    }
                    if ((right = this.startMargin.right - changeX) < 0) {
                        right = 0;
                    }
                    if (right > image.getWidth() - 1) {
                        right = image.getWidth() - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(top, left, bottom, right);
                    repaintRequired = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.contentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.contentAreaDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                return repaintRequired;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.addingHorizontalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && x > imageStartX && x < imageStartX + iw && y < imageStartY) {
                        NinePatchEditor.this.someDragged = true;
                        this.addingHorizontalStretch = true;
                        this.startX = x;
                        this.changedInterval = new NinePatchInterval((x - imageStartX) / NinePatchEditor.this.zoom, false);
                        NinePatchEditor.this.ninePatchIcon.addHorizontalStretch(this.changedInterval);
                        repaintRequired = true;
                    } else if (this.addingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int start = (this.startX - imageStartX) / NinePatchEditor.this.zoom;
                        int end = (x - imageStartX) / NinePatchEditor.this.zoom;
                        this.changedInterval.setStart(Math.max(0, Math.min(start, end)));
                        this.changedInterval.setEnd(Math.min(image.getWidth() - 1, Math.max(start, end)));
                        repaintRequired = true;
                    } else if (this.addingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.addingHorizontalStretch = false;
                        NinePatchEditor.this.verifyHorizontalStretchAreas();
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
                if (this.addingVerticalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && y > imageStartY && y < imageStartY + ih && x < imageStartX) {
                        NinePatchEditor.this.someDragged = true;
                        this.addingVerticalStretch = true;
                        this.startY = y;
                        this.changedInterval = new NinePatchInterval((y - imageStartY) / NinePatchEditor.this.zoom, false);
                        NinePatchEditor.this.ninePatchIcon.addVerticalStretch(this.changedInterval);
                        repaintRequired = true;
                    } else if (this.addingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int start = (this.startY - imageStartY) / NinePatchEditor.this.zoom;
                        int end = (y - imageStartY) / NinePatchEditor.this.zoom;
                        this.changedInterval.setStart(Math.max(0, Math.min(start, end)));
                        this.changedInterval.setEnd(Math.min(image.getHeight() - 1, Math.max(start, end)));
                        repaintRequired = true;
                    } else if (this.addingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.addingVerticalStretch = false;
                        NinePatchEditor.this.verifyVerticalStretchAreas();
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                if (this.removingHorizontalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && x > imageStartX && x < imageStartX + iw && y < imageStartY) {
                        NinePatchEditor.this.someDragged = true;
                        this.removingHorizontalStretch = true;
                        this.startX = x;
                        this.removedInterval = new NinePatchInterval((x - imageStartX) / NinePatchEditor.this.zoom, false);
                        this.finishHorizontalRemoval();
                        repaintRequired = true;
                    } else if (this.removingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int start = (this.startX - imageStartX) / NinePatchEditor.this.zoom;
                        int end = (x - imageStartX) / NinePatchEditor.this.zoom;
                        this.removedInterval.setStart(Math.max(0, Math.min(start, end)));
                        this.removedInterval.setEnd(Math.min(image.getWidth() - 1, Math.max(start, end)));
                        this.finishHorizontalRemoval();
                        repaintRequired = true;
                    } else if (this.removingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.removingHorizontalStretch = false;
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
                if (this.removingVerticalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && y > imageStartY && y < imageStartY + ih && x < imageStartX) {
                        NinePatchEditor.this.someDragged = true;
                        this.removingVerticalStretch = true;
                        this.startY = y;
                        this.removedInterval = new NinePatchInterval((y - imageStartY) / NinePatchEditor.this.zoom, false);
                        this.finishVerticalRemoval();
                        repaintRequired = true;
                    } else if (this.removingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int start = (this.startY - imageStartY) / NinePatchEditor.this.zoom;
                        int end = (y - imageStartY) / NinePatchEditor.this.zoom;
                        this.removedInterval.setStart(Math.max(0, Math.min(start, end)));
                        this.removedInterval.setEnd(Math.min(image.getHeight() - 1, Math.max(start, end)));
                        this.finishVerticalRemoval();
                        repaintRequired = true;
                    } else if (this.removingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.removingVerticalStretch = false;
                        repaintRequired = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
            }
            NinePatchEditor.this.setCursor(Cursor.getDefaultCursor());
            return repaintRequired;
        }

        private void finishHorizontalRemoval() {
            boolean[] filled = NinePatchEditor.this.getHorizontalFilledPixels();
            for (int i = this.removedInterval.getStart(); i <= this.removedInterval.getEnd(); ++i) {
                filled[i] = false;
            }
            NinePatchEditor.this.ninePatchIcon.setHorizontalStretch(NinePatchUtils.parseStretchIntervals(filled));
            NinePatchEditor.this.validateIcon();
        }

        private void finishVerticalRemoval() {
            boolean[] filled = NinePatchEditor.this.getVerticalFilledPixels();
            for (int i = this.removedInterval.getStart(); i <= this.removedInterval.getEnd(); ++i) {
                filled[i] = false;
            }
            NinePatchEditor.this.ninePatchIcon.setVerticalStretch(NinePatchUtils.parseStretchIntervals(filled));
            NinePatchEditor.this.validateIcon();
        }
    }
}

