/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.menu;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.menu.DynamicMenuType;
import com.alee.extended.menu.WebDynamicMenu;
import com.alee.utils.GeometryUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;

public class DynamicMenuLayout
extends AbstractLayoutManager {
    @Override
    public void layoutContainer(Container parent) {
        WebDynamicMenu menu = (WebDynamicMenu)parent;
        float displayProgress = MathUtils.sqr((float)menu.getCurrentProgress());
        Dimension max = SwingUtils.max(menu.getComponents());
        Point center = new Point(menu.getRadius(), menu.getRadius());
        int itemSide = Math.max(max.width, max.height);
        int hidingCause = menu.getHidingCause();
        int hidingCauseIndex = hidingCause != -1 ? hidingCause : 0;
        int radius = menu.getRadius() - itemSide / 2;
        double singleComponentSpacing = this.getSingleComponentSpacing(menu);
        double startingAngle = this.getStartingAngle(menu);
        DynamicMenuType type = !menu.isHiding() ? menu.getType() : menu.getHideType();
        int cwSign = menu.isClockwise() ? 1 : -1;
        int itemsCount = menu.getComponentCount();
        switch (type) {
            case roll: {
                double oneAngle = (double)displayProgress * singleComponentSpacing;
                for (int i = 0; i < itemsCount; ++i) {
                    int ai = hidingCauseIndex + i;
                    int ci = ai < itemsCount ? ai : ai - itemsCount;
                    double angle = startingAngle + (double)hidingCauseIndex * singleComponentSpacing + oneAngle * (double)i * (double)cwSign;
                    int x = (int)Math.round((double)center.x + (double)radius * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)radius * Math.sin(angle));
                    this.placeElement(menu, ci, x, y);
                }
                break;
            }
            case star: {
                int cradius = Math.round((float)radius * displayProgress);
                for (int i = 0; i < itemsCount; ++i) {
                    double angle = startingAngle + singleComponentSpacing * (double)i * (double)cwSign;
                    int r = i == hidingCause ? radius : cradius;
                    int x = (int)Math.round((double)center.x + (double)r * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)r * Math.sin(angle));
                    this.placeElement(menu, i, x, y);
                }
                break;
            }
            case shutter: {
                int cradius = Math.round((float)radius * displayProgress);
                int modSign = menu.isDisplaying() ? -1 : 1;
                double angleMod = GeometryUtils.toRadians((double)((float)(modSign * 90) * (1.0f - displayProgress)));
                for (int i = 0; i < itemsCount; ++i) {
                    double mod = i == hidingCause ? 0.0 : angleMod;
                    double angle = startingAngle + (singleComponentSpacing * (double)i + mod) * (double)cwSign;
                    int r = i == hidingCause ? radius : cradius;
                    int x = (int)Math.round((double)center.x + (double)r * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)r * Math.sin(angle));
                    this.placeElement(menu, i, x, y);
                }
                break;
            }
            case fade: {
                for (int i = 0; i < itemsCount; ++i) {
                    double angle = startingAngle + singleComponentSpacing * (double)i * (double)cwSign;
                    int x = (int)Math.round((double)center.x + (double)radius * Math.cos(angle));
                    int y = (int)Math.round((double)center.y + (double)radius * Math.sin(angle));
                    this.placeElement(menu, i, x, y);
                }
                break;
            }
        }
    }

    public double getSingleComponentSpacing(WebDynamicMenu menu) {
        double fullCircle = GeometryUtils.toRadians((double)Math.min(menu.getAngleRange(), 360.0));
        return fullCircle < Math.PI * 2 ? fullCircle / (double)(menu.getComponentCount() - 1) : fullCircle / (double)menu.getComponentCount();
    }

    public double getStartingAngle(WebDynamicMenu menu) {
        return GeometryUtils.toRadians((double)menu.getStartingAngle()) - 1.5707963267948966;
    }

    public double getItemAngle(WebDynamicMenu menu, int index) {
        int cwSign = menu.isClockwise() ? 1 : -1;
        switch (menu.getType()) {
            default: 
        }
        double startingAngle = this.getStartingAngle(menu);
        double singleComponentSpacing = this.getSingleComponentSpacing(menu);
        return startingAngle + singleComponentSpacing * (double)index * (double)cwSign;
    }

    protected void placeElement(WebDynamicMenu menu, int i, int x, int y) {
        Component menuItem = menu.getComponent(i);
        Dimension ps = menuItem.getPreferredSize();
        menuItem.setBounds(x - ps.width / 2, y - ps.height / 2, ps.width, ps.height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        WebDynamicMenu menu = (WebDynamicMenu)parent;
        switch (menu.getType()) {
            default: 
        }
        int radius = menu.getRadius();
        return new Dimension(radius * 2, radius * 2);
    }
}

