/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListModel;
import com.alee.extended.list.FileListViewType;
import com.alee.extended.list.WebFileList;
import com.alee.extended.list.WebFileListCellRenderer;
import com.alee.laf.list.WebListStyle;
import com.alee.laf.list.editor.AbstractListCellEditor;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.FileUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JList;
import javax.swing.text.JTextComponent;

public class WebFileListCellEditor
extends AbstractListCellEditor<WebTextField, FileElement> {
    protected Object savedSelection = null;

    @Override
    protected void installStartEditActions(final JList list) {
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.F2.isTriggered(e)) {
                    WebFileListCellEditor.this.startEdit(list, list.getSelectedIndex());
                }
            }
        };
        list.addKeyListener(this.keyAdapter);
    }

    @Override
    protected void uninstallStartEditActions(JList list) {
        list.removeKeyListener(this.keyAdapter);
    }

    @Override
    public boolean isCellEditable(JList list, int index, FileElement value) {
        File file = value != null ? value.getFile() : null;
        return file != null && FileUtils.isNameEditable((File)file) && super.isCellEditable(list, index, value);
    }

    @Override
    protected WebTextField createCellEditor(JList list, int index, FileElement value) {
        WebTextField editor = WebTextField.createWebTextField(true, WebListStyle.selectionRound, WebListStyle.selectionShadeWidth);
        editor.setDrawFocus(false);
        FileUtils.displayFileName((JTextComponent)editor, (File)value.getFile());
        if (list instanceof WebFileList) {
            boolean tiles = ((WebFileList)list).getFileListViewType().equals((Object)FileListViewType.tiles);
            editor.setHorizontalAlignment(tiles ? 2 : 0);
        }
        return editor;
    }

    @Override
    protected Rectangle getEditorBounds(JList list, int index, FileElement value, Rectangle cellBounds) {
        if (list instanceof WebFileList) {
            WebFileListCellRenderer cellRenderer = ((WebFileList)list).getWebFileListCellRenderer();
            Rectangle dpBounds = cellRenderer.getDescriptionBounds();
            Dimension size = ((WebTextField)this.editor).getPreferredSize();
            return new Rectangle(dpBounds.x, dpBounds.y + dpBounds.height / 2 - size.height / 2, dpBounds.width, size.height);
        }
        return super.getEditorBounds(list, index, value, cellBounds);
    }

    @Override
    public FileElement getCellEditorValue(JList list, int index, FileElement oldValue) {
        this.savedSelection = list.getSelectedValue();
        File renamed = new File(oldValue.getFile().getParent(), ((WebTextField)this.editor).getText());
        if (oldValue.getFile().renameTo(renamed)) {
            if (this.savedSelection == oldValue) {
                this.savedSelection = renamed;
            }
            return new FileElement(renamed);
        }
        return oldValue;
    }

    @Override
    public boolean updateListModel(JList list, int index, FileElement oldValue, FileElement newValue, boolean updateSelection) {
        if (list.getModel() instanceof FileListModel) {
            FileListModel model = (FileListModel)list.getModel();
            if (!oldValue.getFile().getAbsolutePath().equals(newValue.getFile().getAbsolutePath())) {
                model.setElementAt(newValue, index);
                if (this.savedSelection != null) {
                    list.setSelectedValue(this.savedSelection, true);
                } else {
                    list.clearSelection();
                }
                list.repaint();
                return true;
            }
            return false;
        }
        return super.updateListModel(list, index, oldValue, newValue, updateSelection);
    }
}

