/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListModel;
import com.alee.extended.list.FileListViewType;
import com.alee.extended.list.WebFileListCellEditor;
import com.alee.extended.list.WebFileListCellRenderer;
import com.alee.extended.list.WebFileListStyle;
import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.utils.FileUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class WebFileList
extends WebList {
    protected boolean generateThumbnails = WebFileListStyle.generateThumbnails;
    protected int preferredColumnCount = WebFileListStyle.preferredColumnCount;
    protected int preferredRowCount = WebFileListStyle.preferredRowCount;
    protected FileListViewType fileListViewType = WebFileListStyle.fileListViewType;
    protected FileFilter fileFilter = WebFileListStyle.fileFilter;
    protected File displayedDirectory = null;
    protected WebScrollPane scrollView = null;

    public WebFileList() {
        super((ListModel)new FileListModel());
        this.initializeDefaultSettings();
    }

    public WebFileList(String directoryPath) {
        super((ListModel)new FileListModel(directoryPath));
        this.initializeDefaultSettings();
    }

    public WebFileList(File directory) {
        super((ListModel)new FileListModel(directory));
        this.initializeDefaultSettings();
    }

    public WebFileList(File[] data) {
        super((ListModel)new FileListModel(data));
        this.initializeDefaultSettings();
    }

    public WebFileList(List<File> data) {
        super((ListModel)new FileListModel(data));
        this.initializeDefaultSettings();
    }

    protected void initializeDefaultSettings() {
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(0);
        this.setCellRenderer(new WebFileListCellRenderer(this));
    }

    public WebFileListCellRenderer getWebFileListCellRenderer() throws ClassCastException {
        ListCellRenderer cellRenderer = this.getCellRenderer();
        return cellRenderer instanceof WebFileListCellRenderer ? (WebFileListCellRenderer)cellRenderer : null;
    }

    public FileListModel getFileListModel() throws ClassCastException {
        return (FileListModel)this.getModel();
    }

    @Override
    protected ListCellEditor createDefaultCellEditor() {
        return new WebFileListCellEditor();
    }

    public void setPreferredColumnCount(int preferredColumnCount) {
        this.preferredColumnCount = preferredColumnCount;
    }

    public int getPreferredColumnCount() {
        return this.preferredColumnCount;
    }

    public int getPreferredRowCount() {
        return this.preferredRowCount;
    }

    public void setPreferredRowCount(int preferredRowCount) {
        this.preferredRowCount = preferredRowCount;
    }

    public boolean isGenerateThumbnails() {
        return this.generateThumbnails;
    }

    public void setGenerateThumbnails(boolean generateThumbnails) {
        this.generateThumbnails = generateThumbnails;
    }

    public FileListViewType getFileListViewType() {
        return this.fileListViewType;
    }

    public void setFileListViewType(FileListViewType fileListViewType) {
        this.fileListViewType = fileListViewType;
        this.getWebFileListCellRenderer().updateFilesView();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.reloadFiles();
    }

    public void reloadFiles() {
        this.setDisplayedDirectory(this.getDisplayedDirectory());
    }

    public File getDisplayedDirectory() {
        return this.displayedDirectory;
    }

    public void setDisplayedDirectory(File file) {
        this.stopCellEditing();
        List<File> oldSelection = this.getSelectedFiles();
        File[] files = file != null ? FileUtils.sortFiles((File[])file.listFiles(this.fileFilter)) : FileUtils.getDiskRoots();
        this.getFileListModel().setData(files);
        if (FileUtils.equals((File)this.displayedDirectory, (File)file)) {
            this.setSelectedFiles(oldSelection);
        }
        this.displayedDirectory = file;
    }

    public List<File> getSelectedFiles() {
        Object[] selectedValues = this.getSelectedValues();
        ArrayList<File> selectedFiles = new ArrayList<File>(selectedValues.length);
        for (Object value : selectedValues) {
            selectedFiles.add(((FileElement)value).getFile());
        }
        return selectedFiles;
    }

    public File getSelectedFile() {
        Object selectedValue = this.getSelectedValue();
        return selectedValue != null ? ((FileElement)selectedValue).getFile() : null;
    }

    public void setSelectedFile(File file) {
        this.setSelectedFile(file, true);
    }

    public void setSelectedFile(File file, boolean shouldScroll) {
        FileElement element = this.getFileListModel().getElement(file);
        if (element != null) {
            this.setSelectedValue(element, shouldScroll);
        } else {
            this.clearSelection();
        }
    }

    public void setSelectedFiles(Collection<File> files) {
        ArrayList<FileElement> elements = new ArrayList<FileElement>(files.size());
        for (File file : files) {
            FileElement element = this.getFileListModel().getElement(file);
            if (element == null) continue;
            elements.add(element);
        }
        this.setSelectedValues(elements);
    }

    public WebScrollPane getScrollView() {
        if (this.scrollView == null) {
            this.scrollView = this.createScrollView();
        }
        return this.scrollView;
    }

    public WebScrollPane createScrollView() {
        return new WebScrollPane(this){

            @Override
            public Dimension getPreferredSize() {
                Dimension oneCell;
                Dimension ps = super.getPreferredSize();
                int fcw = WebFileList.this.getFixedCellWidth();
                int fch = WebFileList.this.getFixedCellHeight();
                if (fcw != -1 && fch != -1) {
                    oneCell = new Dimension(fcw, fch);
                } else {
                    WebFileListCellRenderer fileListCellRenderer;
                    oneCell = WebFileList.this.getModel().getSize() > 0 ? WebFileList.this.getCellBounds(0, 0).getSize() : ((fileListCellRenderer = WebFileList.this.getWebFileListCellRenderer()) != null ? fileListCellRenderer.getPreferredSize() : new Dimension(90, 90));
                    if (fcw != -1) {
                        oneCell.width = fcw;
                    } else if (fch != -1) {
                        oneCell.width = fcw;
                    }
                }
                Insets bi = this.getInsets();
                JScrollBar vsb = this.getVerticalScrollBar();
                int sbw = vsb != null && vsb.isShowing() ? vsb.getPreferredSize().width : 0;
                ps.width = oneCell.width * WebFileList.this.preferredColumnCount + bi.left + bi.right + sbw + 1;
                ps.height = oneCell.height * WebFileList.this.preferredRowCount + bi.top + bi.bottom + 1;
                return ps;
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.getModel().getSize() > 0) {
            Dimension oneCell = this.getCellBounds(0, 0).getSize();
            ps.width = oneCell.width * this.preferredColumnCount;
        }
        return ps;
    }

    public void repaint(FileElement element) {
        this.repaint(this.getFileListModel().indexOf(element));
    }
}

