/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HorizontalFlowLayout
extends AbstractLayoutManager {
    protected int horizGap;
    protected boolean fillLast;

    public HorizontalFlowLayout() {
        this(2);
    }

    public HorizontalFlowLayout(int gap) {
        this(gap, false);
    }

    public HorizontalFlowLayout(int gap, boolean fillLast) {
        this.horizGap = gap;
        this.fillLast = fillLast;
    }

    public int getHorizontalGap() {
        return this.horizGap;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension required = this.preferredLayoutSize(parent);
        Dimension available = new Dimension(required.width, parent.getSize().height);
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        Insets insets = parent.getInsets();
        int ls = ltr ? insets.left : insets.right;
        int rs = ltr ? insets.right : insets.left;
        boolean min = required.width < available.width;
        int x = ls;
        int y = insets.top;
        int height = Math.max(available.height, required.height) - insets.top - insets.bottom;
        int xsWidth = available.width - required.width;
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int width;
            int w;
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            int n = w = min ? c.getMinimumSize().width : c.getPreferredSize().width;
            if (xsWidth > 0) {
                w += w * xsWidth / required.width;
            }
            int n2 = width = this.fillLast && i == count - 1 && parent.getWidth() - x - rs > 0 ? parent.getWidth() - x - rs : w;
            if (ltr) {
                c.setBounds(x, y, width, height);
            } else {
                c.setBounds(parent.getWidth() - x - width, y, width, height);
            }
            x += w + this.getHorizontalGap();
        }
    }

    protected Dimension getLayoutSize(Container parent, boolean min) {
        int count = parent.getComponentCount();
        Dimension size = new Dimension(0, 0);
        for (int i = 0; i < count; ++i) {
            Component c = parent.getComponent(i);
            Dimension tmp = min ? c.getMinimumSize() : c.getPreferredSize();
            size.height = Math.max(tmp.height, size.height);
            size.width += tmp.width;
            if (i == 0) continue;
            size.width += this.getHorizontalGap();
        }
        Insets border = parent.getInsets();
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

