/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.layout.TableLayout;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebTipLabel
extends JComponent
implements SwingConstants,
ActionListener {
    public static final ImageIcon HIDE_ICON = new ImageIcon(WebTipLabel.class.getResource("icons/hide.png"));
    public static final ImageIcon HIDE_DARK_ICON = new ImageIcon(WebTipLabel.class.getResource("icons/hide_dark.png"));
    public static final String SETTINGS_GROUP = "WebTipLabel";
    private String id;
    private int opacity = 100;
    private WebTimer timer = null;
    private final WebButton hideButton;
    private final WebLabel helpLabel;

    public WebTipLabel(String id) {
        this(id, "");
    }

    public WebTipLabel(String id, String text) {
        this(id, text, null);
    }

    public WebTipLabel(String id, int horizontalAlignment) {
        this(id, "", horizontalAlignment);
    }

    public WebTipLabel(String id, Icon icon) {
        this(id, "", icon);
    }

    public WebTipLabel(String id, String text, Icon icon) {
        this(id, text, icon, 2);
    }

    public WebTipLabel(String id, String text, int horizontalAlignment) {
        this(id, text, null, horizontalAlignment);
    }

    public WebTipLabel(String id, String text, Icon icon, int horizontalAlignment) {
        double[] dArray;
        this.id = id;
        SwingUtils.setOrientation(this);
        this.setFocusable(false);
        this.setOpaque(false);
        double[][] dArrayArray = new double[2][];
        if (horizontalAlignment == 2) {
            double[] dArray2 = new double[2];
            dArray2[0] = -2.0;
            dArray = dArray2;
            dArray2[1] = -2.0;
        } else if (horizontalAlignment == 0) {
            double[] dArray3 = new double[4];
            dArray3[0] = -1.0;
            dArray3[1] = -2.0;
            dArray3[2] = -2.0;
            dArray = dArray3;
            dArray3[3] = -1.0;
        } else {
            double[] dArray4 = new double[3];
            dArray4[0] = -1.0;
            dArray4[1] = -2.0;
            dArray = dArray4;
            dArray4[2] = -2.0;
        }
        dArrayArray[0] = dArray;
        dArrayArray[1] = new double[]{-2.0};
        TableLayout layout = new TableLayout(dArrayArray);
        layout.setHGap(4);
        this.setLayout(layout);
        this.hideButton = new WebButton(HIDE_ICON);
        this.hideButton.setRolloverIcon(HIDE_DARK_ICON);
        this.hideButton.setUndecorated(true);
        this.hideButton.addActionListener(this);
        this.helpLabel = new WebLabel();
        this.helpLabel.setIcon(icon);
        this.helpLabel.setText(text);
        this.helpLabel.setForeground(Color.DARK_GRAY);
        SwingUtils.changeFontSize(this.helpLabel, -1);
        if (horizontalAlignment == 2) {
            this.add((Component)this.hideButton, "0,0");
            this.add((Component)this.helpLabel, "1,0");
        } else {
            this.add((Component)this.hideButton, "1,0");
            this.add((Component)this.helpLabel, "2,0");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hideButton.setEnabled(false);
        this.timer = new WebTimer("WebTipLabel.animator", StyleConstants.animationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebTipLabel.this.opacity > 0) {
                    WebTipLabel.this.opacity -= 10;
                    WebTipLabel.this.repaint();
                } else {
                    Container parent = WebTipLabel.this.getParent();
                    parent.remove(WebTipLabel.this);
                    if (parent instanceof JComponent) {
                        ((JComponent)parent).revalidate();
                    } else {
                        parent.invalidate();
                    }
                    parent.repaint();
                    SettingsManager.set((String)WebTipLabel.SETTINGS_GROUP, (String)WebTipLabel.this.id, (Object)false);
                    WebTipLabel.this.timer.stop();
                }
            }
        });
        this.timer.start();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf((float)this.opacity / 100.0f), (this.opacity < 100 ? 1 : 0) != 0);
        super.paint(g);
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setText(String text) {
        this.helpLabel.setText(text);
    }

    public String getText() {
        return this.helpLabel.getText();
    }

    public void setIcon(Icon icon) {
        this.helpLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.helpLabel.getIcon();
    }

    public void setVerticalAlignment(int alignment) {
        this.helpLabel.setVerticalAlignment(alignment);
    }

    public void setHorizontalAlignment(int alignment) {
        this.helpLabel.setHorizontalAlignment(alignment);
    }

    public void setVerticalTextPosition(int textPosition) {
        this.helpLabel.setVerticalTextPosition(textPosition);
    }

    public void setHorizontalTextPosition(int textPosition) {
        this.helpLabel.setHorizontalTextPosition(textPosition);
    }

    public WebLabel getHelpLabel() {
        return this.helpLabel;
    }

    public WebButton getHideButton() {
        return this.hideButton;
    }
}

