/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.global.StyleConstants;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WebImageGallery
extends JComponent {
    private final int spacing = 20;
    private int imageLength = 200;
    private final int borderWidth = 3;
    private final float fadeHeight = 0.7f;
    private final int opacity = 125;
    private final Color light = new Color(128, 128, 128);
    private final Color selectedLight = new Color(255, 255, 255);
    private final Color transparent = new Color(128, 128, 128, 0);
    private final Color selectedTransparent = new Color(255, 255, 255, 0);
    private int maxWidth = 0;
    private int maxHeight = 0;
    private final List<ImageIcon> images = new ArrayList<ImageIcon>();
    private final List<BufferedImage> reflections = new ArrayList<BufferedImage>();
    private final List<String> descriptions = new ArrayList<String>();
    private int preferredColumnCount = 4;
    private boolean scrollOnSelection = true;
    private int selectedIndex = -1;
    private int oldSelectedIndex = -1;
    private float progress = 0.0f;
    private WebTimer reflectionMover = null;
    private WebScrollPane view;

    public WebImageGallery() {
        SwingUtils.setOrientation(this);
        this.setFocusable(true);
        this.setFont(new JLabel().getFont().deriveFont(1));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    WebImageGallery.this.requestFocusInWindow();
                    for (int i = 0; i < WebImageGallery.this.images.size(); ++i) {
                        if (!WebImageGallery.this.getImageRect(i).contains(e.getPoint())) continue;
                        WebImageGallery.this.setSelectedIndex(i);
                        break;
                    }
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int newIndex;
                int index = WebImageGallery.this.getSelectedIndex();
                int maxIndex = WebImageGallery.this.images.size() - 1;
                int wheelRotation = e.getWheelRotation();
                if (wheelRotation > 0) {
                    for (newIndex = index + wheelRotation; newIndex > maxIndex; newIndex -= WebImageGallery.this.images.size()) {
                    }
                } else {
                    for (newIndex = index + wheelRotation; newIndex < 0; newIndex += WebImageGallery.this.images.size()) {
                    }
                }
                WebImageGallery.this.setSelectedIndex(newIndex);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (WebImageGallery.this.images.size() > 0) {
                    int si = WebImageGallery.this.getSelectedIndex();
                    if (Hotkey.LEFT.isTriggered(e)) {
                        WebImageGallery.this.setSelectedIndex(si == -1 || si == 0 ? WebImageGallery.this.images.size() - 1 : si - 1);
                    } else if (Hotkey.RIGHT.isTriggered(e)) {
                        WebImageGallery.this.setSelectedIndex(si == -1 || si == WebImageGallery.this.images.size() - 1 ? 0 : si + 1);
                    } else if (Hotkey.HOME.isTriggered(e)) {
                        WebImageGallery.this.setSelectedIndex(0);
                    } else if (Hotkey.END.isTriggered(e)) {
                        WebImageGallery.this.setSelectedIndex(WebImageGallery.this.images.size() - 1);
                    }
                }
            }
        });
    }

    public List<ImageIcon> getImages() {
        return this.images;
    }

    public int getPreferredColumnCount() {
        return this.preferredColumnCount;
    }

    public void setPreferredColumnCount(int preferredColumnCount) {
        this.preferredColumnCount = preferredColumnCount;
    }

    public WebScrollPane getView() {
        return this.getView(true);
    }

    public WebScrollPane getView(boolean withBorder) {
        if (this.view == null) {
            this.view = new WebScrollPane(this, withBorder){

                @Override
                public Dimension getPreferredSize() {
                    int columns = Math.min(WebImageGallery.this.images.size(), WebImageGallery.this.preferredColumnCount);
                    JScrollBar hsb = this.getHorizontalScrollBar();
                    int sbh = hsb != null && hsb.isShowing() ? hsb.getPreferredSize().height : 0;
                    return new Dimension(20 * (columns + 1) + columns * WebImageGallery.this.maxWidth, WebImageGallery.this.getPreferredSize().height + sbh);
                }
            };
            this.view.setHorizontalScrollBarPolicy(31);
            this.view.setVerticalScrollBarPolicy(21);
            InputMap im = this.view.getInputMap(1);
            im.put(KeyStroke.getKeyStroke("UP"), "none");
            im.put(KeyStroke.getKeyStroke("DOWN"), "none");
            im.put(KeyStroke.getKeyStroke("LEFT"), "none");
            im.put(KeyStroke.getKeyStroke("RIGHT"), "none");
        }
        return this.view;
    }

    public int getImageLength() {
        return this.imageLength;
    }

    public void setImageLength(int imageLength) {
        this.imageLength = imageLength;
    }

    public boolean isScrollOnSelection() {
        return this.scrollOnSelection;
    }

    public void setScrollOnSelection(boolean scrollOnSelection) {
        this.scrollOnSelection = scrollOnSelection;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.selectedIndex == selectedIndex) {
            return;
        }
        this.oldSelectedIndex = this.selectedIndex;
        this.selectedIndex = selectedIndex;
        this.repaint();
        if (this.scrollOnSelection) {
            Rectangle rect = this.getImageRect(selectedIndex);
            SwingUtils.scrollSmoothly(this.getView(), rect.x + rect.width / 2 - this.getVisibleRect().width / 2, rect.y);
        }
        this.moveReflection();
    }

    private void moveReflection() {
        if (this.reflectionMover != null && this.reflectionMover.isRunning()) {
            this.reflectionMover.stop();
        }
        this.progress = 0.0f;
        this.reflectionMover = new WebTimer("WebImageGallery.reflectionMoveTimer", StyleConstants.fastAnimationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebImageGallery.this.progress < 1.0f) {
                    WebImageGallery.this.progress += 0.08f;
                    WebImageGallery.this.progress = Math.min(WebImageGallery.this.progress, 1.0f);
                    WebImageGallery.this.repaint();
                } else {
                    WebImageGallery.this.reflectionMover.stop();
                }
            }
        });
        this.reflectionMover.start();
    }

    public Rectangle getImageRect(int index) {
        int iconWidth = this.images.get(index).getIconWidth();
        int iconHeight = this.images.get(index).getIconHeight();
        Dimension ps = this.getPreferredSize();
        int x = (this.getWidth() > ps.width ? (this.getWidth() - ps.width) / 2 : 0) + 20 + (this.maxWidth + 20) * index + this.maxWidth / 2;
        int y = this.getHeight() / 2 - 10 - iconHeight / 2;
        return new Rectangle(x - iconWidth / 2, y - iconHeight / 2, iconWidth, iconHeight);
    }

    public void addImage(ImageIcon image) {
        this.addImage(0, image);
    }

    public void addImage(int index, ImageIcon image) {
        try {
            ImageIcon previewIcon = ImageUtils.createPreviewIcon((ImageIcon)image, (int)this.imageLength);
            int rwidth = previewIcon.getIconWidth();
            int rheight = previewIcon.getIconHeight();
            BufferedImage reflection = ImageUtils.createCompatibleImage((int)rwidth, (int)rheight, (int)3);
            Graphics2D g2d = reflection.createGraphics();
            GraphicsUtils.setupAntialias((Graphics2D)g2d);
            g2d.drawImage(previewIcon.getImage(), 0, 0, null);
            g2d.setComposite(AlphaComposite.getInstance(6));
            g2d.setPaint(new GradientPaint(0.0f, (float)rheight * 0.3f, new Color(0, 0, 0, 0), 0.0f, rheight, new Color(0, 0, 0, 125)));
            g2d.fillRect(0, 0, rwidth, rheight);
            g2d.dispose();
            this.images.add(index, previewIcon);
            this.descriptions.add(index, image.getIconWidth() + " x " + image.getIconHeight() + " px");
            this.reflections.add(index, reflection);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.recalcualteMaxSizes();
        this.updateContainer();
    }

    public void removeImage(ImageIcon image) {
        if (this.images.contains(image)) {
            this.removeImage(this.images.indexOf(image));
        }
    }

    public void removeImage(int index) {
        if (index >= 0 && index < this.images.size()) {
            boolean wasSelected = this.getSelectedIndex() == index;
            this.images.remove(index);
            this.descriptions.remove(index);
            this.reflections.remove(index).flush();
            this.recalcualteMaxSizes();
            this.updateContainer();
            if (wasSelected && this.images.size() > 0) {
                this.setSelectedIndex(index < this.images.size() ? index : index - 1);
            }
        }
    }

    private void updateContainer() {
        if (this.getParent() instanceof JComponent) {
            ((JComponent)this.getParent()).revalidate();
        }
        this.repaint();
    }

    private void recalcualteMaxSizes() {
        for (ImageIcon icon : this.images) {
            this.maxWidth = Math.max(this.maxWidth, icon.getIconWidth());
            this.maxHeight = Math.max(this.maxHeight, icon.getIconHeight());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int height = this.getHeight();
        int width = this.getWidth();
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, height, Color.darkGray));
        g2d.fillRect(0, 0, width, height);
        Rectangle vr = this.getVisibleRect();
        Dimension ps = this.getPreferredSize();
        Composite oldComposite = g2d.getComposite();
        for (int i = 0; i < this.images.size(); ++i) {
            int addition;
            if (!this.getImageRect(i).intersects(vr)) continue;
            ImageIcon icon = this.images.get(i);
            BufferedImage bi = ImageUtils.getBufferedImage((ImageIcon)icon);
            int imageWidth = icon.getIconWidth();
            int imageHeight = icon.getIconHeight();
            int x = (this.getWidth() > ps.width ? (this.getWidth() - ps.width) / 2 : 0) + 20 + (this.maxWidth + 20) * i + this.maxWidth / 2;
            int y = height / 2 - 10 - imageHeight / 2;
            int y2 = height / 2 + 10 + imageHeight / 2;
            float add = this.selectedIndex == i ? this.progress * 0.4f : (this.oldSelectedIndex == i ? 0.4f - this.progress * 0.4f : 0.0f);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f + add));
            g2d.drawImage((Image)bi, x - imageWidth / 2, y - imageHeight / 2, null);
            g2d.setPaint(this.selectedIndex == i ? Color.WHITE : Color.GRAY);
            Area gp = new Area(new RoundRectangle2D.Double(x - imageWidth / 2 - 3, y - imageHeight / 2 - 3, imageWidth + 6, imageHeight + 6, 6.0, 6.0));
            gp.subtract(new Area(new Rectangle(x - imageWidth / 2, y - imageHeight / 2, imageWidth, imageHeight)));
            g2d.fill(gp);
            g2d.setComposite(oldComposite);
            if (this.selectedIndex == i || this.oldSelectedIndex == i) {
                float opacity = this.selectedIndex == i ? this.progress : 1.0f - this.progress;
                g2d.setComposite(AlphaComposite.getInstance(3, opacity));
                g2d.setPaint(Color.WHITE);
                String infoText = this.descriptions.get(i);
                Point ts = LafUtils.getTextCenterShear(g2d.getFontMetrics(), infoText);
                g2d.drawString(infoText, x + ts.x, this.getHeight() / 2 + 10 + ts.y);
                g2d.setComposite(oldComposite);
            }
            int rwidth = imageWidth + 6;
            int rheight = imageHeight + 6;
            int n = this.selectedIndex == i ? Math.round(this.progress * 20.0f) : (addition = this.oldSelectedIndex == i ? 20 - Math.round(this.progress * 20.0f) : 0);
            if (this.reflections.get(i) != null) {
                g2d.drawImage(this.reflections.get(i), x - imageWidth / 2, y2 + imageHeight / 2 + addition, imageWidth, -imageHeight, null);
            }
            gp = new Area(new RoundRectangle2D.Double(x - rwidth / 2, y2 - rheight / 2 + addition, rwidth, rheight, 6.0, 6.0));
            gp.subtract(new Area(new Rectangle(x - rwidth / 2 + 3, y2 - rheight / 2 + addition + 3, rwidth - 6, rheight - 6)));
            g2d.setPaint(new GradientPaint(0.0f, y2 - imageHeight / 2 + addition, this.selectedIndex == i ? this.selectedLight : this.light, 0.0f, (float)(y2 - imageHeight / 2 + addition) + (float)imageHeight * 0.7f, this.selectedIndex == i ? this.selectedTransparent : this.transparent));
            g2d.fill(gp);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20 * (this.images.size() + 1) + this.maxWidth * this.images.size(), 60 + this.maxHeight * 2);
    }
}

