/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.extended.image.DisplayType;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebImage
extends JComponent
implements SwingConstants {
    private BufferedImage image;
    private BufferedImage disabledImage;
    private DisplayType displayType;
    private int horizontalAlignment;
    private int verticalAlignment;
    private float transparency;
    private Insets margin;
    private Dimension lastDimention = null;
    private BufferedImage lastPreviewImage = null;

    public WebImage() {
        this((Image)null);
    }

    public WebImage(String src) {
        this(ImageUtils.loadImage((String)src));
    }

    public WebImage(Class nearClass, String src) {
        this(ImageUtils.loadImage((Class)nearClass, (String)src));
    }

    public WebImage(URL url) {
        this(ImageUtils.loadImage((URL)url));
    }

    public WebImage(Icon icon) {
        this(ImageUtils.getBufferedImage((Icon)icon));
    }

    public WebImage(ImageIcon icon) {
        this(icon.getImage());
    }

    public WebImage(Image image) {
        this(ImageUtils.getBufferedImage((Image)image));
    }

    public WebImage(BufferedImage image) {
        this.image = image;
        this.disabledImage = null;
        this.displayType = DisplayType.preferred;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
        this.transparency = 1.0f;
        SwingUtils.setOrientation(this);
        this.setOpaque(false);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!WebImage.this.isEnabled()) {
                    WebImage.this.calculateDisabledImage();
                    WebImage.this.repaint();
                } else {
                    WebImage.this.clearDisabledImage();
                    WebImage.this.repaint();
                }
            }
        });
    }

    protected void calculateDisabledImage() {
        this.disabledImage = this.image != null ? ImageUtils.createDisabledCopy((Image)this.image) : null;
        this.lastPreviewImage = null;
    }

    private void clearDisabledImage() {
        if (this.disabledImage != null) {
            this.disabledImage.flush();
            this.disabledImage = null;
        }
        this.lastPreviewImage = null;
    }

    public int getImageWidth() {
        return this.image != null ? this.image.getWidth() : -1;
    }

    public int getImageHeight() {
        return this.image != null ? this.image.getHeight() : -1;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public WebImage setIcon(Icon icon) {
        this.setImage(ImageUtils.getBufferedImage((Icon)icon));
        return this;
    }

    public WebImage setIcon(ImageIcon icon) {
        this.setImage(icon.getImage());
        return this;
    }

    public WebImage setImage(Image image) {
        this.setImage(ImageUtils.getBufferedImage((Image)image));
        return this;
    }

    public WebImage setImage(BufferedImage image) {
        this.image = image;
        if (!this.isEnabled()) {
            this.calculateDisabledImage();
        }
        this.revalidate();
        this.repaint();
        return this;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public WebImage setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
        this.updateView();
        return this;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WebImage setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.updateView();
        return this;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WebImage setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.updateView();
        return this;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public WebImage setTransparency(float transparency) {
        this.transparency = transparency;
        this.updateView();
        return this;
    }

    protected void updateView() {
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public WebImage setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
        return this;
    }

    public WebImage setMargin(int top, int left, int bottom, int right) {
        return this.setMargin(new Insets(top, left, bottom, right));
    }

    public WebImage setMargin(int spacing) {
        return this.setMargin(spacing, spacing, spacing, spacing);
    }

    protected void updateBorder() {
        if (this.margin != null) {
            this.setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
        } else {
            this.setBorder(null);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.transparency <= 0.0f) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(this.transparency), (this.transparency < 1.0f ? 1 : 0) != 0);
        BufferedImage currentImage = this.getCurrentImage();
        if (currentImage != null) {
            Insets insets = this.getInsets();
            if (this.getSize().equals(this.getRequiredSize())) {
                g2d.drawImage((Image)currentImage, insets.left, insets.top, null);
            } else {
                switch (this.displayType) {
                    case preferred: {
                        int x;
                        int n = this.horizontalAlignment == 2 ? insets.left : (x = this.horizontalAlignment == 4 ? this.getWidth() - currentImage.getWidth() - insets.right : this.getCenterX(insets) - currentImage.getWidth() / 2);
                        int y = this.verticalAlignment == 1 ? insets.top : (this.verticalAlignment == 3 ? this.getHeight() - currentImage.getHeight() - insets.bottom : this.getCenterY(insets) - currentImage.getHeight() / 2);
                        g2d.drawImage((Image)currentImage, x, y, null);
                        break;
                    }
                    case fitComponent: {
                        BufferedImage preview = this.getPreviewImage(insets);
                        g2d.drawImage((Image)preview, this.getCenterX(insets) - preview.getWidth() / 2, this.getCenterY(insets) - preview.getHeight() / 2, null);
                        break;
                    }
                    case repeat: {
                        int x;
                        int n = this.horizontalAlignment == 2 ? insets.left : (x = this.horizontalAlignment == 4 ? this.getWidth() - currentImage.getWidth() - insets.right : this.getCenterX(insets) - currentImage.getWidth() / 2);
                        int y = this.verticalAlignment == 1 ? insets.top : (this.verticalAlignment == 3 ? this.getHeight() - currentImage.getHeight() - insets.bottom : this.getCenterY(insets) - currentImage.getHeight() / 2);
                        g2d.setPaint(new TexturePaint(currentImage, new Rectangle2D.Double(x, y, currentImage.getWidth(), currentImage.getHeight())));
                        g2d.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                        break;
                    }
                }
            }
        }
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (this.transparency < 1.0f ? 1 : 0) != 0);
    }

    protected int getCenterX(Insets insets) {
        return insets.left + (this.getWidth() - insets.left - insets.right) / 2;
    }

    protected int getCenterY(Insets insets) {
        return insets.top + (this.getHeight() - insets.top - insets.bottom) / 2;
    }

    protected BufferedImage getPreviewImage(Insets insets) {
        if (this.image.getWidth() > this.getWidth() || this.image.getHeight() > this.getHeight()) {
            Dimension size = this.getSize();
            size.setSize(size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
            if (this.lastPreviewImage == null || this.lastDimention != null && !this.lastDimention.equals(size)) {
                if (this.lastPreviewImage != null) {
                    this.lastPreviewImage.flush();
                    this.lastPreviewImage = null;
                }
                this.lastPreviewImage = ImageUtils.createPreviewImage((BufferedImage)this.getCurrentImage(), (Dimension)size);
                this.lastDimention = this.getSize();
            }
            return this.lastPreviewImage;
        }
        return this.image;
    }

    protected BufferedImage getCurrentImage() {
        return !this.isEnabled() && this.disabledImage != null ? this.disabledImage : this.image;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.getRequiredSize();
    }

    protected Dimension getRequiredSize() {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + (this.image != null ? this.image.getWidth() : 0) + insets.right, insets.top + (this.image != null ? this.image.getHeight() : 0) + insets.bottom);
    }
}

