/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.WebFileTableColumns;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class WebFileTableModel
extends AbstractTableModel
implements WebFileTableColumns {
    private List<String> columns;
    private List<File> files;

    public WebFileTableModel() {
        this(new ArrayList<File>(), CollectionUtils.copy((Collection)DEFAULT_COLUMNS));
    }

    public WebFileTableModel(String ... columns) {
        this(new ArrayList<File>(), Arrays.asList(columns));
    }

    public WebFileTableModel(List<String> columns) {
        this(new ArrayList<File>(), columns);
    }

    public WebFileTableModel(Collection<File> files, String ... columns) {
        this(files, Arrays.asList(columns));
    }

    public WebFileTableModel(Collection<File> files, List<String> columns) {
        this.columns = columns;
        this.files = new ArrayList<File>(files);
    }

    public void setFiles(Collection<File> files) {
        this.files.clear();
        this.files.addAll(files);
        this.fireTableDataChanged();
    }

    public void addFiles(Collection<File> files) {
        if (files.size() > 0) {
            int lastIndex = this.files.size();
            this.files.addAll(files);
            this.fireTableRowsInserted(lastIndex, lastIndex + files.size() - 1);
        }
    }

    public int getFileRow(File file) {
        return this.files.indexOf(file);
    }

    public File getFileAtRow(int row) {
        return this.files.get(row);
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
        this.fireTableStructureChanged();
    }

    public String getColumnId(int column) {
        return this.columns.get(column);
    }

    public boolean isColumnDisplayed(String column) {
        return this.columns.contains(column);
    }

    public int getColumnIndex(String column) {
        return this.columns.indexOf(column);
    }

    @Override
    public String getColumnName(int column) {
        return LanguageManager.get((String)this.columns.get(column));
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.files.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.files.set(rowIndex, (File)aValue);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return File.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getColumnId(columnIndex).equals("weblaf.filechooser.table.column.name") && FileUtils.isNameEditable((File)this.getFileAtRow(rowIndex));
    }
}

