/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.image.WebImage;
import com.alee.laf.text.WebTextField;
import com.alee.utils.FileUtils;
import com.alee.utils.swing.WebDefaultCellEditor;
import java.io.File;
import javax.swing.text.JTextComponent;

public class WebFileTableCellEditor
extends WebDefaultCellEditor<WebTextField> {
    public WebFileTableCellEditor() {
        this.clickCountToStart = 3;
        this.editorComponent = new WebTextField(false);
        ((WebTextField)this.editorComponent).setMargin(2);
        ((WebTextField)this.editorComponent).setFieldMargin(0, 4, 0, 0);
        this.delegate = new FileNameEditorDelegate();
    }

    protected class FileNameEditorDelegate
    extends WebDefaultCellEditor.EditorDelegate<File> {
        protected FileNameEditorDelegate() {
            super(WebFileTableCellEditor.this);
        }

        @Override
        public void setValue(File file) {
            ((WebTextField)WebFileTableCellEditor.this.editorComponent).setLeadingComponent(new WebImage(FileUtils.getFileIcon((File)file)));
            FileUtils.displayFileName((JTextComponent)((JTextComponent)WebFileTableCellEditor.this.editorComponent), (File)file);
            super.setValue(file);
        }

        @Override
        public boolean stopCellEditing() {
            String newName = ((WebTextField)WebFileTableCellEditor.this.editorComponent).getText();
            if (!newName.equals(((File)this.value).getName())) {
                File renamed = new File(((File)this.value).getParent(), newName);
                if (((File)this.value).renameTo(renamed)) {
                    this.value = renamed;
                }
                return super.stopCellEditing();
            }
            super.cancelCellEditing();
            return true;
        }
    }
}

