/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientColorDataComparator;
import com.alee.managers.settings.DefaultValue;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="GradientData")
public class GradientData
implements Serializable,
Cloneable,
DefaultValue {
    private static final transient GradientColorDataComparator locationsComparator = new GradientColorDataComparator();
    @XStreamImplicit(itemFieldName="Color")
    private List<GradientColorData> gradientColorsData;

    public GradientData() {
        this.gradientColorsData = new ArrayList<GradientColorData>();
    }

    public GradientData(List<GradientColorData> gradientColorsData) {
        this.setGradientColorsData(gradientColorsData);
    }

    public boolean containtsLocation(float location) {
        for (GradientColorData gradientColorData : this.gradientColorsData) {
            if (gradientColorData.getLocation() != location) continue;
            return true;
        }
        return false;
    }

    public void addGradientColorData(GradientColorData gradientColorData) {
        this.gradientColorsData.add(gradientColorData);
        this.sort();
    }

    public void addGradientColorData(float location, Color color) {
        this.gradientColorsData.add(new GradientColorData(location, color));
        this.sort();
    }

    public void removeGradientColorData(GradientColorData gradientColorData) {
        this.gradientColorsData.remove(gradientColorData);
        this.sort();
    }

    public List<GradientColorData> getGradientColorsData() {
        this.sort();
        return this.gradientColorsData;
    }

    public void setGradientColorsData(List<GradientColorData> gradientColorsData) {
        this.gradientColorsData = gradientColorsData;
        this.sort();
    }

    public float[] getFractions() {
        this.sort();
        float[] fractions = new float[this.gradientColorsData.size()];
        for (int i = 0; i < this.gradientColorsData.size(); ++i) {
            fractions[i] = this.gradientColorsData.get(i).getLocation();
        }
        return fractions;
    }

    public Color[] getColors() {
        this.sort();
        Color[] colors = new Color[this.gradientColorsData.size()];
        for (int i = 0; i < this.gradientColorsData.size(); ++i) {
            colors[i] = this.gradientColorsData.get(i).getColor();
        }
        return colors;
    }

    public int size() {
        return this.gradientColorsData.size();
    }

    public GradientColorData get(int index) {
        return this.gradientColorsData.get(index);
    }

    public float getLocation(int index) {
        return this.get(index).getLocation();
    }

    public Color getColor(int index) {
        return this.get(index).getColor();
    }

    public GradientColorData getFirst() {
        return this.size() > 0 ? this.gradientColorsData.get(0) : null;
    }

    public GradientColorData getLast() {
        return this.size() > 0 ? this.gradientColorsData.get(this.size() - 1) : null;
    }

    public Color getColorForLocation(float location) {
        if (this.size() == 0) {
            return null;
        }
        if (location <= this.getFirst().getLocation()) {
            return SwingUtils.copy(this.get(0).getColor());
        }
        if (location >= this.getLast().getLocation()) {
            return SwingUtils.copy(this.getLast().getColor());
        }
        int nextIndex = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getLocation(i) > location)) continue;
            nextIndex = i;
            break;
        }
        float before = this.getLocation(nextIndex - 1);
        float current = location - before;
        float after = this.getLocation(nextIndex) - before;
        float progress = current / after;
        Color c1 = this.getColor(nextIndex - 1);
        Color c2 = this.getColor(nextIndex);
        return ColorUtils.getIntermediateColor((Color)c1, (Color)c2, (float)progress);
    }

    public void sort() {
        Collections.sort(this.gradientColorsData, locationsComparator);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GradientData)) {
            return false;
        }
        GradientData other = (GradientData)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public GradientData clone() {
        return new GradientData(CollectionUtils.clone(this.gradientColorsData));
    }

    public static GradientData getDefaultValue() {
        GradientData gradientData = new GradientData();
        gradientData.addGradientColorData(0.0f, Color.RED);
        gradientData.addGradientColorData(0.25f, Color.YELLOW);
        gradientData.addGradientColorData(0.5f, Color.GREEN);
        gradientData.addGradientColorData(0.75f, Color.CYAN);
        gradientData.addGradientColorData(1.0f, Color.BLUE);
        return gradientData;
    }
}

