/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.WebSwitchGripper;
import com.alee.extended.button.WebSwitchLayout;
import com.alee.extended.button.WebSwitchStyle;
import com.alee.global.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class WebSwitch
extends WebPanel {
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>(1);
    private boolean animate = WebSwitchStyle.animate;
    private boolean selected = false;
    private boolean animating = false;
    private WebTimer animator;
    private final WebSwitchGripper gripper;
    private WebLabel leftComponent;
    private WebLabel rightComponent;

    public WebSwitch() {
        this(false);
    }

    public WebSwitch(boolean selected) {
        super(true, (LayoutManager)new WebSwitchLayout());
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.setRound(WebSwitchStyle.round);
        this.setPaintFocus(true);
        this.setFocusable(true);
        this.gripper = new WebSwitchGripper();
        this.add((Component)this.gripper, (Object)"GRIPPER");
        this.leftComponent = new WebLabel("ON", 0);
        this.leftComponent.setBoldFont();
        this.leftComponent.setMargin(2, 5, 2, 5);
        this.leftComponent.setDrawShade(true);
        this.leftComponent.setForeground(Color.DARK_GRAY);
        this.add((Component)this.leftComponent, (Object)"LEFT");
        this.rightComponent = new WebLabel("OFF", 0);
        this.rightComponent.setBoldFont();
        this.rightComponent.setMargin(2, 5, 2, 5);
        this.rightComponent.setDrawShade(true);
        this.rightComponent.setForeground(Color.DARK_GRAY);
        this.add((Component)this.rightComponent, (Object)"RIGHT");
        this.createAnimator();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtils.isLeftMouseButton(e) && WebSwitch.this.isEnabled()) {
                    WebSwitch.this.requestFocusInWindow();
                    WebSwitch.this.setSelected(!WebSwitch.this.isSelected());
                }
            }
        };
        this.gripper.addMouseListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.setSelected(selected, false);
    }

    private void createAnimator() {
        this.animator = new WebTimer("WebSwitch.animator", StyleConstants.maxAnimationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSwitchLayout switchLayout = WebSwitch.this.getSwitchLayout();
                switchLayout.setGripperLocation(switchLayout.getGripperLocation() + (WebSwitch.this.selected ? 0.1f : -0.1f));
                if (WebSwitch.this.selected && switchLayout.getGripperLocation() >= 1.0f || !WebSwitch.this.selected && switchLayout.getGripperLocation() <= 0.0f) {
                    switchLayout.setGripperLocation(WebSwitch.this.selected ? 1.0f : 0.0f);
                    WebSwitch.this.revalidate();
                    WebSwitch.this.animating = false;
                    WebSwitch.this.animator.stop();
                } else {
                    WebSwitch.this.revalidate();
                }
            }
        });
    }

    private void startAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animator.start();
        }
    }

    public WebSwitchLayout getSwitchLayout() {
        return (WebSwitchLayout)this.getLayout();
    }

    public WebSwitchGripper getGripper() {
        return this.gripper;
    }

    public WebLabel getLeftComponent() {
        return this.leftComponent;
    }

    public void setLeftComponent(WebLabel leftComponent) {
        if (this.leftComponent != null) {
            this.remove(this.leftComponent);
        }
        this.leftComponent = leftComponent;
        this.add((Component)leftComponent, (Object)"LEFT");
        this.revalidate();
    }

    public WebLabel getRightComponent() {
        return this.rightComponent;
    }

    public void setRightComponent(WebLabel rightComponent) {
        if (this.rightComponent != null) {
            this.remove(this.rightComponent);
        }
        this.rightComponent = rightComponent;
        this.add((Component)rightComponent, (Object)"RIGHT");
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.gripper.setEnabled(enabled);
        this.leftComponent.setEnabled(enabled);
        this.rightComponent.setEnabled(enabled);
    }

    @Override
    public WebPanel setRound(int round) {
        if (this.gripper != null) {
            this.gripper.setRound(Math.max(round - 3, 0));
        }
        return super.setRound(round);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, this.animate);
    }

    public void setSelected(boolean selected, boolean animate) {
        this.selected = selected;
        if (animate) {
            this.startAnimation();
        } else {
            this.getSwitchLayout().setGripperLocation(selected ? 1.0f : 0.0f);
            this.revalidate();
        }
        this.fireActionPerformed();
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Selection changed");
        for (ActionListener actionListener : CollectionUtils.copy(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

