/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.SplitButtonListener;
import com.alee.extended.button.WebSplitButtonStyle;
import com.alee.extended.button.WebSplitButtonUI;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.utils.ReflectUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class WebSplitButton
extends WebButton
implements MouseMotionListener,
MouseListener,
ActionListener,
Serializable {
    private static final String uiClassID = "SplitButtonUI";
    protected boolean alwaysShowMenu = WebSplitButtonStyle.alwaysShowMenu;
    protected PopupMenuWay popupMenuWay = WebSplitButtonStyle.popupMenuWay;
    protected JPopupMenu popupMenu = null;
    protected boolean onSplit = false;

    public WebSplitButton() {
    }

    public WebSplitButton(Icon icon) {
        super(icon);
    }

    public WebSplitButton(String text) {
        super(text);
    }

    public WebSplitButton(String text, Icon icon) {
        super(text, icon);
    }

    public WebSplitButton(ActionListener listener) {
        super(listener);
    }

    public WebSplitButton(Icon icon, ActionListener listener) {
        super(icon, listener);
    }

    public WebSplitButton(String text, ActionListener listener) {
        super(text, listener);
    }

    public WebSplitButton(String text, Icon icon, ActionListener listener) {
        super(text, icon, listener);
    }

    public WebSplitButton(Action a) {
        super(a);
    }

    @Override
    protected void init(String text, Icon icon) {
        super.init(text, icon);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addActionListener(this);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public boolean isAlwaysShowMenu() {
        return this.alwaysShowMenu;
    }

    public void setAlwaysShowMenu(boolean alwaysShowMenu) {
        this.alwaysShowMenu = alwaysShowMenu;
    }

    public PopupMenuWay getPopupMenuWay() {
        return this.popupMenuWay;
    }

    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
    }

    public ImageIcon getSplitIcon() {
        return this.getWebUI().getSplitIcon();
    }

    public void setSplitIcon(ImageIcon splitIcon) {
        this.getWebUI().setSplitIcon(splitIcon);
    }

    public int getSplitIconGap() {
        return this.getWebUI().getSplitIconGap();
    }

    public void setSplitIconGap(int splitIconGap) {
        this.getWebUI().setSplitIconGap(splitIconGap);
    }

    public int getContentGap() {
        return this.getWebUI().getContentGap();
    }

    public void setContentGap(int contentGap) {
        this.getWebUI().setContentGap(contentGap);
    }

    public void addSplitButtonListener(SplitButtonListener listener) {
        this.listenerList.add(SplitButtonListener.class, listener);
    }

    public void removeSplitButtonListener(SplitButtonListener listener) {
        if (listener != null && this.getAction() == listener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(SplitButtonListener.class, listener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.popupMenu == null) {
            this.fireButtonClicked(e);
        } else if (this.alwaysShowMenu) {
            this.showPopupMenu();
            this.fireButtonClicked(e);
        } else if (this.onSplit) {
            this.showPopupMenu();
            this.fireSplitbuttonClicked(e);
        } else {
            this.fireButtonClicked(e);
        }
    }

    public void showPopupMenu() {
        if (this.popupMenu.getUI() instanceof WebPopupMenuUI) {
            ((WebPopupMenuUI)this.popupMenu.getUI()).setPopupMenuWay(this.popupMenuWay);
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            this.popupMenu.show(this, 0, this.getHeight());
        } else {
            this.popupMenu.show(this, this.getWidth() - this.popupMenu.getPreferredSize().width, this.getHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean wasOnSplit = this.onSplit;
        this.onSplit = this.getWebUI().getSplitButtonHitbox(this).contains(e.getPoint());
        if (wasOnSplit != this.onSplit) {
            this.repaint(this.getWebUI().getSplitButtonBounds(this));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        boolean wasOnSplit = this.onSplit;
        this.onSplit = false;
        if (wasOnSplit != this.onSplit) {
            this.repaint(this.getWebUI().getSplitButtonBounds(this));
        }
    }

    protected void fireButtonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonListener)listeners[i + 1]).buttonClicked(e);
        }
    }

    protected void fireSplitbuttonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonListener)listeners[i + 1]).splitButtonClicked(e);
        }
    }

    @Override
    public WebSplitButtonUI getWebUI() {
        return (WebSplitButtonUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebSplitButtonUI)) {
            try {
                this.setUI((WebSplitButtonUI)ReflectUtils.createInstance((String)WebLookAndFeel.splitButtonUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebSplitButtonUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

