/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.extended.breadcrumb.BreadcrumbElement;
import com.alee.extended.breadcrumb.BreadcrumbElementType;
import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.WebBreadcrumbStyle;
import com.alee.global.StyleConstants;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ShapeCache;
import com.alee.utils.laf.ShadeType;
import com.alee.utils.swing.DataProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;

public final class BreadcrumbUtils {
    private static final String BORDER_SHAPE = "border";
    private static final String FILL_SHAPE = "fill";
    public static final float[] progressFractions = new float[]{0.0f, 0.5f, 1.0f};
    public static final Color progressSideColor = new Color(255, 255, 255, 0);
    public static final Color[] progressFillColors = new Color[]{progressSideColor, new Color(0, 255, 0, 100), progressSideColor};
    public static final Color[] selectedProgressFillColors = new Color[]{progressSideColor, new Color(0, 255, 0, 100), progressSideColor};
    public static final Color[] progressLineColors = new Color[]{progressSideColor, Color.GRAY, progressSideColor};
    public static final float[] shadeFractions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
    public static final Color[] shadeColors = new Color[]{StyleConstants.transparent, StyleConstants.shadeColor, StyleConstants.shadeColor, StyleConstants.transparent};

    public static Insets getElementMargin(JComponent element) {
        int right;
        int left;
        Container container = element.getParent();
        if (container != null && container instanceof WebBreadcrumb && element instanceof BreadcrumbElement) {
            WebBreadcrumb wbc = (WebBreadcrumb)container;
            BreadcrumbElementType type = BreadcrumbElementType.getType(element, wbc);
            boolean isNone = type.equals((Object)BreadcrumbElementType.none);
            int n = isNone ? 0 : (left = type.equals((Object)BreadcrumbElementType.start) ? 0 : wbc.getElementOverlap());
            right = isNone ? 0 : (type.equals((Object)BreadcrumbElementType.end) ? 0 : wbc.getElementOverlap() + wbc.getShadeWidth());
        } else {
            left = 0;
            right = 0;
        }
        return new Insets(0, left, 0, right);
    }

    public static void paintElementBackground(Graphics2D g2d, JComponent element) {
        AbstractButton ab;
        ButtonModel bm;
        Container container = element.getParent();
        if (container == null || !(container instanceof WebBreadcrumb)) {
            return;
        }
        if (!(element instanceof BreadcrumbElement)) {
            return;
        }
        Object old = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        WebBreadcrumb breadcrumb = (WebBreadcrumb)container;
        int overlap = breadcrumb.getElementOverlap();
        int shadeWidth = breadcrumb.getShadeWidth();
        int round = breadcrumb.getRound();
        boolean encloseLast = breadcrumb.isEncloseLastElement();
        BreadcrumbElement breadcrumbElement = (BreadcrumbElement)((Object)element);
        int w = element.getWidth();
        int h = element.getHeight();
        BreadcrumbElementType type = BreadcrumbElementType.getType(element, breadcrumb);
        boolean showProgress = breadcrumbElement.isShowProgress();
        float progress = breadcrumbElement.getProgress();
        boolean ltr = element.getComponentOrientation().isLeftToRight();
        boolean selected = element instanceof AbstractButton ? (bm = (ab = (AbstractButton)element).getModel()).isPressed() || bm.isSelected() : false;
        Shape fs = BreadcrumbUtils.getFillShape(element, type, w, h, overlap, shadeWidth, round, encloseLast, ltr);
        if (!type.equals((Object)BreadcrumbElementType.end) && !type.equals((Object)BreadcrumbElementType.none)) {
            Shape bs = BreadcrumbUtils.getBorderShape(element, w, h, overlap, shadeWidth, ltr);
            Rectangle rect = bs.getBounds();
            if (element.isEnabled() && !selected) {
                g2d.setPaint(new LinearGradientPaint(0.0f, rect.y, 0.0f, rect.y + rect.height, shadeFractions, shadeColors));
                GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)bs, (ShadeType)WebBreadcrumbStyle.shadeType, null, (int)shadeWidth);
            }
            g2d.setPaint(selected ? WebBreadcrumbStyle.selectedBgColor : new GradientPaint(0.0f, 0.0f, WebBreadcrumbStyle.bgTop, 0.0f, element.getHeight(), WebBreadcrumbStyle.bgBottom));
            g2d.fill(fs);
            if (element.isEnabled() && selected) {
                g2d.setPaint(new LinearGradientPaint(0.0f, rect.y, 0.0f, rect.y + rect.height, shadeFractions, shadeColors));
                GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)bs, (ShadeType)WebBreadcrumbStyle.shadeType, null, (int)shadeWidth, (Shape)bs);
            }
            Color bc = element.isEnabled() ? WebBreadcrumbStyle.borderColor : WebBreadcrumbStyle.disabledBorderColor;
            Color sideColor = ColorUtils.getTransparentColor((Color)bc, (int)20);
            Color[] borderColors = new Color[]{sideColor, bc, bc, sideColor};
            g2d.setPaint(new LinearGradientPaint(0.0f, rect.y, 0.0f, rect.y + rect.height, shadeFractions, borderColors));
            g2d.draw(bs);
        } else {
            g2d.setPaint(selected ? WebBreadcrumbStyle.selectedBgColor : new GradientPaint(0.0f, 0.0f, WebBreadcrumbStyle.bgTop, 0.0f, element.getHeight(), WebBreadcrumbStyle.bgBottom));
            g2d.fill(fs);
        }
        if (showProgress && progress > 0.0f) {
            Shape progressFillShape = BreadcrumbUtils.getProgressFillShape(fs, progress, ltr);
            Rectangle pb = progressFillShape.getBounds();
            g2d.setPaint(BreadcrumbUtils.getProgressPaint(element, h));
            g2d.fill(progressFillShape);
            Shape oldClip = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)fs);
            g2d.setPaint(BreadcrumbUtils.getProgressLinePaint(h));
            g2d.drawLine(ltr ? pb.x + pb.width : pb.x, pb.y, ltr ? pb.x + pb.width : pb.x, pb.y + pb.height);
            GraphicsUtils.restoreClip((Graphics)g2d, (Shape)oldClip);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)old);
    }

    public static Shape getBorderShape(JComponent element, final int w, final int h, final int overlap, final int shadeWidth, final boolean ltr) {
        return ShapeCache.getShape((Component)element, (String)BORDER_SHAPE, (DataProvider)new DataProvider<Shape>(){

            public Shape provide() {
                return BreadcrumbUtils.createBorderShape(w, h, overlap, shadeWidth, ltr);
            }
        }, (Object[])new Object[]{w, h, overlap, shadeWidth, ltr});
    }

    public static GeneralPath createBorderShape(int w, int h, int overlap, int shadeWidth, boolean ltr) {
        GeneralPath gp = new GeneralPath(0);
        if (ltr) {
            gp.moveTo(w - overlap - shadeWidth - 1, -1.0f);
            gp.lineTo(w - shadeWidth - 1, h / 2);
            gp.lineTo(w - overlap - shadeWidth - 1, h);
        } else {
            gp.moveTo(shadeWidth + overlap, -1.0f);
            gp.lineTo(shadeWidth, h / 2);
            gp.lineTo(shadeWidth + overlap, h);
        }
        return gp;
    }

    public static Shape getFillShape(final JComponent element, final BreadcrumbElementType type, final int w, final int h, final int overlap, final int shadeWidth, final int round, final boolean encloseLast, final boolean ltr) {
        return ShapeCache.getShape((Component)element, (String)FILL_SHAPE, (DataProvider)new DataProvider<Shape>(){

            public Shape provide() {
                return BreadcrumbUtils.createFillShape(element, type, w, h, overlap, shadeWidth, round, encloseLast, ltr);
            }
        }, (Object[])new Object[]{type, w, h, overlap, shadeWidth, round, encloseLast, ltr});
    }

    public static Shape createFillShape(JComponent element, BreadcrumbElementType type, int w, int h, int overlap, int shadeWidth, int round, boolean encloseLast, boolean ltr) {
        if (element.getParent() != null && element.getParent().getComponentCount() == 1 && !encloseLast) {
            if (round > 0) {
                return new RoundRectangle2D.Double(0.0, 0.0, w, h, round, round);
            }
            return new Rectangle(0, 0, w, h);
        }
        if (!type.equals((Object)BreadcrumbElementType.end)) {
            GeneralPath gp = new GeneralPath(0);
            if (ltr) {
                gp.moveTo(w - overlap - shadeWidth - 1, 0.0f);
                gp.lineTo(w - shadeWidth - 1, h / 2);
                gp.lineTo(w - overlap - shadeWidth - 1, h);
                if (round > 0 && type.equals((Object)BreadcrumbElementType.start)) {
                    gp.lineTo(round, h);
                    gp.quadTo(0.0f, h, 0.0f, h - round);
                    gp.lineTo(0.0f, round);
                    gp.quadTo(0.0f, 0.0f, round, 0.0f);
                } else {
                    gp.lineTo(0.0f, h);
                    gp.lineTo(0.0f, 0.0f);
                }
                gp.closePath();
            } else {
                gp.moveTo(shadeWidth + overlap, 0.0f);
                gp.lineTo(shadeWidth, h / 2);
                gp.lineTo(shadeWidth + overlap, h);
                if (round > 0 && type.equals((Object)BreadcrumbElementType.start)) {
                    gp.lineTo(w - round, h);
                    gp.quadTo(w, h, w, h - round);
                    gp.lineTo(w, round);
                    gp.quadTo(w, 0.0f, w - round, 0.0f);
                } else {
                    gp.lineTo(w, h);
                    gp.lineTo(w, 0.0f);
                }
                gp.closePath();
            }
            return gp;
        }
        if (round > 0) {
            GeneralPath gp = new GeneralPath(0);
            if (ltr) {
                gp.moveTo(0.0f, 0.0f);
                gp.lineTo(w - round, 0.0f);
                gp.quadTo(w, 0.0f, w, round);
                gp.lineTo(w, h - round);
                gp.quadTo(w, h, w - round, h);
                gp.lineTo(0.0f, h);
            } else {
                gp.moveTo(w, 0.0f);
                gp.lineTo(round, 0.0f);
                gp.quadTo(0.0f, 0.0f, 0.0f, round);
                gp.lineTo(0.0f, h - round);
                gp.quadTo(0.0f, h, round, h);
                gp.lineTo(w, h);
            }
            gp.closePath();
            return gp;
        }
        return new Rectangle(0, 0, w, h);
    }

    public static Shape getProgressFillShape(Shape fillShape, float progress, boolean ltr) {
        Area fill = new Area(fillShape);
        Rectangle bounds = fill.getBounds();
        int oldWidth = bounds.width;
        bounds.width = Math.round((float)oldWidth * progress);
        bounds.x = ltr ? bounds.x : bounds.x + oldWidth - bounds.width;
        fill.intersect(new Area(bounds));
        return fill;
    }

    public static LinearGradientPaint getProgressPaint(JComponent element, int h) {
        boolean pressed = false;
        if (element instanceof AbstractButton) {
            ButtonModel bm = ((AbstractButton)element).getModel();
            pressed = bm.isPressed() || bm.isSelected();
        }
        return new LinearGradientPaint(0.0f, 0.0f, 0.0f, h, progressFractions, pressed ? selectedProgressFillColors : progressFillColors);
    }

    public static LinearGradientPaint getProgressLinePaint(int h) {
        return new LinearGradientPaint(0.0f, 0.0f, 0.0f, h, progressFractions, progressLineColors);
    }

    public static boolean contains(JComponent element, int x, int y) {
        int w = element.getWidth();
        int h = element.getHeight();
        Container container = element.getParent();
        if (container != null && container instanceof WebBreadcrumb && element instanceof BreadcrumbElement) {
            WebBreadcrumb breadcrumb = (WebBreadcrumb)container;
            BreadcrumbElementType type = BreadcrumbElementType.getType(element, breadcrumb);
            int overlap = breadcrumb.getElementOverlap();
            int shadeWidth = breadcrumb.getShadeWidth();
            int round = breadcrumb.getRound();
            boolean encloseLast = breadcrumb.isEncloseLastElement();
            boolean ltr = element.getComponentOrientation().isLeftToRight();
            return BreadcrumbUtils.getFillShape(element, type, w, h, overlap, shadeWidth, round, encloseLast, ltr).contains(x, y);
        }
        return 0 < x && x < w && 0 < y && y < h;
    }
}

