/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.expression;

import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.expression.BooleanUtil;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.expression.JexlExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JsExpressionHandler
implements ExpressionHandler {
    JexlExpressionHandler jexlExpressionHandler = new JexlExpressionHandler();
    ScriptEngineManager mgr = new ScriptEngineManager();
    ScriptEngine jsEngine = this.mgr.getEngineByName("JavaScript");

    @Override
    public Boolean evaluateBooleanExpression(String expression, JadeModel model) throws ExpressionException {
        return BooleanUtil.convert(this.evaluateExpression(expression, model));
    }

    @Override
    public Object evaluateExpression(String expression, JadeModel model) throws ExpressionException {
        try {
            Bindings bindings = this.jsEngine.createBindings();
            bindings.putAll(model);
            Object eval = this.jsEngine.eval(expression, bindings);
            for (Map.Entry stringObjectEntry : bindings.entrySet()) {
                model.put((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
            return eval;
        }
        catch (ScriptException ex) {
            throw new ExpressionException(expression, ex);
        }
    }

    @Override
    public String evaluateStringExpression(String expression, JadeModel model) throws ExpressionException {
        Object result = this.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    @Override
    public void assertExpression(String expression) throws ExpressionException {
        this.jexlExpressionHandler.assertExpression(expression);
    }

    @Override
    public void setCache(boolean cache) {
    }

    @Override
    public void clearCache() {
    }
}

