/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.compiler.Utils;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.filter.Filter;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.HashMap;
import java.util.Map;

public class FilterNode
extends Node {
    private Node textBlock;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public boolean hasTextBlock() {
        return this.textBlock != null;
    }

    public void setTextBlock(Node textBlock) {
        this.textBlock = textBlock;
    }

    public Node getTextBlock() {
        return this.textBlock;
    }

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        Filter filter = model.getFilter(this.getValue());
        String result = this.textBlock.getValue();
        if (filter != null) {
            result = filter.convert(result, this.attributes, model);
        }
        try {
            result = Utils.interpolate(result, model, false);
        }
        catch (ExpressionException e) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
        }
        writer.append(result);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

