/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.expression;

import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.expression.BooleanUtil;
import de.neuland.jade4j.model.JadeModel;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JadeJexlEngine;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;

public class ExpressionHandler {
    private static final int MAX_ENTRIES = 5000;
    private static JexlEngine jexl = new JadeJexlEngine();

    public static Boolean evaluateBooleanExpression(String expression, JadeModel model) throws ExpressionException {
        return BooleanUtil.convert(ExpressionHandler.evaluateExpression(expression, model));
    }

    public static Object evaluateExpression(String expression, JadeModel model) throws ExpressionException {
        try {
            Expression e = jexl.createExpression(expression);
            return e.evaluate((JexlContext)new MapContext((Map)model));
        }
        catch (Exception e) {
            throw new ExpressionException(expression, e);
        }
    }

    public static String evaluateStringExpression(String expression, JadeModel model) throws ExpressionException {
        Object result = ExpressionHandler.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    public static void setCache(boolean cache) {
        jexl.setCache(cache ? 5000 : 0);
    }

    public static void clearCache() {
        jexl.clearCache();
    }

    static {
        jexl.setCache(5000);
    }
}

