/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BSONTimestamp
implements Serializable {
    private static final long serialVersionUID = -3268482672267936464L;
    static final boolean D = Boolean.getBoolean("DEBUG.DBTIMESTAMP");
    final int _inc;
    final Date _time;

    public BSONTimestamp() {
        this._inc = 0;
        this._time = null;
    }

    public BSONTimestamp(int time, int inc) {
        this._time = new Date((long)time * 1000L);
        this._inc = inc;
    }

    public int getTime() {
        if (this._time == null) {
            return 0;
        }
        return (int)(this._time.getTime() / 1000L);
    }

    public int getInc() {
        return this._inc;
    }

    public String toString() {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
        String strDate = formater.format(this._time);
        return "{ $timestamp : " + strDate + "." + this._inc + "}";
    }

    public Date getDate() {
        if (this._time == null) {
            return null;
        }
        return this._time;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BSONTimestamp) {
            BSONTimestamp t2 = (BSONTimestamp)obj;
            return this.getTime() == t2.getTime() && this.getInc() == t2.getInc();
        }
        return false;
    }
}

