/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.net;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.ConfigOptions;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.net.ServerAddress;
import com.sequoiadb.util.Helper;
import com.sequoiadb.util.logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectionTCPImpl
implements IConnection {
    private Socket clientSocket;
    private InputStream input;
    private OutputStream output;
    private ConfigOptions options;
    private ServerAddress hostAddress;
    private boolean endianConvert;
    private byte[] receive_buffer;
    private static final int DEF_BUFFER_LENGTH = 65536;
    private int REAL_BUFFER_LENGTH;
    private long lastUseTime;

    @Override
    public void setEndianConvert(boolean endianConvert) {
        this.endianConvert = endianConvert;
    }

    @Override
    public boolean isEndianConvert() {
        return this.endianConvert;
    }

    @Override
    public long getLastUseTime() {
        return this.lastUseTime;
    }

    public ConnectionTCPImpl(ServerAddress addr, ConfigOptions options) {
        this.hostAddress = addr;
        this.options = options;
        this.endianConvert = false;
        this.receive_buffer = new byte[65536];
        this.REAL_BUFFER_LENGTH = 65536;
    }

    private void connect() throws BaseException {
        logger.getInstance().debug(0, "enter connect\n");
        String objectidentity = Integer.toString(this.hashCode());
        logger.getInstance().debug(0, "objidentity:" + objectidentity + "\n");
        if (this.clientSocket != null) {
            return;
        }
        long sleepTime = 100L;
        long maxAutoConnectRetryTime = this.options.getMaxAutoConnectRetryTime();
        long start = System.currentTimeMillis();
        while (true) {
            BaseException lastError = null;
            InetSocketAddress addr = this.hostAddress.getHostAddress();
            try {
                this.clientSocket = this.options.getUseSSL() ? SSLContextHelper.getSSLContext().getSocketFactory().createSocket() : new Socket();
                this.clientSocket.connect(addr, this.options.getConnectTimeout());
                this.clientSocket.setTcpNoDelay(!this.options.getUseNagle());
                this.clientSocket.setKeepAlive(this.options.getSocketKeepAlive());
                this.clientSocket.setSoTimeout(this.options.getSocketTimeout());
                this.input = new BufferedInputStream(this.clientSocket.getInputStream());
                this.output = this.clientSocket.getOutputStream();
                logger.getInstance().debug(0, "leave connect\n");
                return;
            }
            catch (IOException ioe) {
                lastError = new BaseException("SDB_NETWORK", new Object[]{ioe});
                this.close();
                long executedTime = System.currentTimeMillis() - start;
                if (executedTime >= maxAutoConnectRetryTime) {
                    throw lastError;
                }
                if (sleepTime + executedTime > maxAutoConnectRetryTime) {
                    sleepTime = maxAutoConnectRetryTime - executedTime;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                sleepTime *= 2L;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        logger.getInstance().debug(0, "enter close\n");
        String trace = logger.getInstance().getStackMsg();
        logger.getInstance().debug(0, trace);
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.receive_buffer = null;
                this.REAL_BUFFER_LENGTH = 0;
                this.input = null;
                this.output = null;
                this.clientSocket = null;
            }
        }
        logger.getInstance().debug(0, "leave close\n");
        logger.getInstance().save();
    }

    @Override
    public boolean isClosed() {
        if (this.clientSocket == null) {
            return true;
        }
        return this.clientSocket.isClosed();
    }

    @Override
    public void changeConfigOptions(ConfigOptions opts) throws BaseException {
        logger.getInstance().debug(0, "enter changeConfigOptions\n");
        this.options = opts;
        this.close();
        this.connect();
        logger.getInstance().debug(0, "leave changeConfigOptions\n");
    }

    @Override
    public ByteBuffer receiveMessage(boolean endianConvert) throws BaseException {
        this.lastUseTime = System.currentTimeMillis();
        logger.getInstance().debug(0, "enter receiveMessage\n");
        try {
            int rtn;
            int retSize;
            if (this.REAL_BUFFER_LENGTH < 65536) {
                this.receive_buffer = new byte[65536];
                this.REAL_BUFFER_LENGTH = 65536;
            }
            this.input.mark(4);
            for (rtn = 0; rtn < 4; rtn += retSize) {
                retSize = this.input.read(this.receive_buffer, rtn, 4 - rtn);
                if (retSize != -1) continue;
                this.close();
                throw new BaseException("SDB_NETWORK", new Object[0]);
            }
            int msgSize = Helper.byteToInt(this.receive_buffer, endianConvert);
            if (msgSize > this.REAL_BUFFER_LENGTH) {
                this.receive_buffer = new byte[msgSize];
                this.REAL_BUFFER_LENGTH = msgSize;
            }
            this.input.reset();
            int retSize2 = 0;
            for (rtn = 0; rtn < msgSize; rtn += retSize2) {
                retSize2 = this.input.read(this.receive_buffer, rtn, msgSize - rtn);
                if (-1 != retSize2) continue;
                this.close();
                throw new BaseException("SDB_NETWORK", new Object[0]);
            }
            if (rtn != msgSize) {
                this.close();
                throw new BaseException("SDB_NETWORK", new Object[0]);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.receive_buffer, 0, msgSize);
            if (endianConvert) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            logger.getInstance().debug(0, "leave receiveMessage\n");
            return byteBuffer;
        }
        catch (IOException e) {
            throw new BaseException("SDB_NETWORK", new Object[0]);
        }
        catch (NullPointerException e) {
            logger.getInstance().error("objidentity:" + Integer.toString(this.hashCode()) + "\n");
            logger.getInstance().error("thread id:" + Long.toString(Thread.currentThread().getId()) + "\n");
            throw new BaseException("SDB_NETWORK", new Object[0]);
        }
    }

    @Override
    public byte[] receiveSysInfoMsg(int msgSize) throws BaseException {
        logger.getInstance().debug(0, "enter receiveSysInfoMsg\n");
        byte[] buf = new byte[msgSize];
        try {
            int rtn;
            int retSize = 0;
            for (rtn = 0; rtn < msgSize; rtn += retSize) {
                retSize = this.input.read(buf, rtn, msgSize - rtn);
                if (-1 != retSize) continue;
                this.close();
                throw new BaseException("SDB_NETWORK", new Object[0]);
            }
            if (rtn != msgSize) {
                StringBuffer bbf = new StringBuffer();
                for (byte by : buf) {
                    bbf.append(String.format("%02x", by));
                }
                this.close();
                throw new BaseException("SDB_INVALIDARG", new Object[0]);
            }
        }
        catch (IOException e) {
            throw new BaseException("SDB_NETWORK", new Object[0]);
        }
        catch (NullPointerException e) {
            logger.getInstance().error("objidentity:" + Integer.toString(this.hashCode()) + "\n");
            logger.getInstance().error("thread id:" + Long.toString(Thread.currentThread().getId()) + "\n");
            throw new BaseException("SDB_NETWORK", new Object[0]);
        }
        logger.getInstance().debug(0, "leave receiveSysInfoMsg\n");
        return buf;
    }

    @Override
    public void initialize() throws BaseException {
        this.connect();
    }

    @Override
    public void sendMessage(byte[] msg) throws BaseException {
        logger.getInstance().debug(0, "enter sendMessage\n");
        try {
            if (this.output != null) {
                this.output.write(msg);
            }
        }
        catch (IOException e) {
            throw new BaseException("SDB_NETWORK", new Object[]{e});
        }
        logger.getInstance().debug(0, "leave sendMessage\n");
    }

    @Override
    public void sendMessage(byte[] msg, int length) throws BaseException {
        logger.getInstance().debug(0, "enter sendMessage2\n");
        try {
            if (this.output == null) {
                throw new BaseException("SDB_NETWORK", new Object[0]);
            }
            this.output.write(msg, 0, length);
        }
        catch (IOException e) {
            throw new BaseException("SDB_NETWORK", new Object[]{e});
        }
        logger.getInstance().debug(0, "leave sendMessage2\n");
    }

    @Override
    public void shrinkBuffer() {
        if (this.REAL_BUFFER_LENGTH != 65536) {
            this.receive_buffer = new byte[65536];
            this.REAL_BUFFER_LENGTH = 65536;
        }
    }

    static class SSLContextHelper {
        private static volatile SSLContext sslContext = null;

        SSLContextHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static SSLContext getSSLContext() throws BaseException {
            if (sslContext != null) return sslContext;
            Class<SSLContextHelper> clazz = SSLContextHelper.class;
            synchronized (SSLContextHelper.class) {
                if (sslContext != null) return sslContext;
                try {
                    X509TrustManager tm = new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        }
                    };
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, new TrustManager[]{tm}, null);
                    sslContext = ctx;
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new BaseException("SDB_NETWORK", new Object[]{nsae});
                }
                catch (KeyManagementException kme) {
                    throw new BaseException("SDB_NETWORK", new Object[]{kme});
                }
                return sslContext;
            }
        }
    }
}

